/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.DefaultClusterConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.CarrierLoader;
import com.couchbase.client.core.config.loader.HttpLoader;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.config.refresher.CarrierRefresher;
import com.couchbase.client.core.config.refresher.HttpRefresher;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.BucketClosedEvent;
import com.couchbase.client.core.event.system.BucketOpenedEvent;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigurationProvider.class);
    private final ClusterFacade cluster;
    private final Subject<ClusterConfig, ClusterConfig> configObservable;
    private final List<Loader> loaderChain;
    private final Map<LoaderType, Refresher> refreshers;
    private final CoreEnvironment environment;
    private final EventBus eventBus;
    private volatile boolean terminated;
    private volatile boolean bootstrapped;
    private volatile ClusterConfig currentConfig;
    private volatile Set<NetworkAddress> seedHosts;

    public DefaultConfigurationProvider(final ClusterFacade cluster, final CoreEnvironment environment) {
        this(cluster, environment, Arrays.asList(new CarrierLoader(cluster, environment), new HttpLoader(cluster, environment)), (Map<LoaderType, Refresher>)new HashMap<LoaderType, Refresher>(){
            {
                this.put(LoaderType.Carrier, new CarrierRefresher(environment, cluster));
                this.put(LoaderType.HTTP, new HttpRefresher(environment, cluster));
            }
        });
    }

    public DefaultConfigurationProvider(ClusterFacade cluster, CoreEnvironment environment, List<Loader> loaderChain, Map<LoaderType, Refresher> refreshers) {
        if (cluster == null) {
            throw new IllegalArgumentException("A cluster reference needs to be provided");
        }
        if (loaderChain == null || loaderChain.isEmpty()) {
            throw new IllegalArgumentException("At least one config loader needs to be provided");
        }
        this.cluster = cluster;
        this.loaderChain = loaderChain;
        this.refreshers = refreshers;
        this.environment = environment;
        this.eventBus = environment.eventBus();
        this.configObservable = PublishSubject.create().toSerialized();
        this.seedHosts = null;
        this.bootstrapped = false;
        this.terminated = false;
        this.currentConfig = new DefaultClusterConfig();
        Observable.from(refreshers.values()).doOnNext(new Action1<Refresher>(){

            @Override
            public void call(Refresher refresher) {
                refresher.provider(DefaultConfigurationProvider.this);
            }
        }).flatMap(new Func1<Refresher, Observable<String>>(){

            @Override
            public Observable<String> call(Refresher refresher) {
                return refresher.configs();
            }
        }).subscribe(new Action1<String>(){

            @Override
            public void call(String bucketConfig) {
                DefaultConfigurationProvider.this.proposeBucketConfig(null, bucketConfig);
            }
        });
    }

    @Override
    public Observable<ClusterConfig> configs() {
        return this.configObservable;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig;
    }

    @Override
    public boolean seedHosts(Set<NetworkAddress> hosts, boolean shuffle) {
        if (this.bootstrapped) {
            LOGGER.debug("Seed hosts called with {}, but already bootstrapped.", (Object)hosts);
            return false;
        }
        LOGGER.debug("Setting seed hosts to {}", (Object)hosts);
        if (shuffle) {
            ArrayList<NetworkAddress> hostsList = new ArrayList<NetworkAddress>(hosts);
            Collections.shuffle(hostsList);
            this.seedHosts = new HashSet<NetworkAddress>(hostsList);
        } else {
            this.seedHosts = hosts;
        }
        return true;
    }

    @Override
    public Observable<ClusterConfig> openBucket(String bucket, String password) {
        return this.openBucket(bucket, bucket, password);
    }

    @Override
    public Observable<ClusterConfig> openBucket(final String bucket, final String username, final String password) {
        LOGGER.debug("Got instructed to open bucket {}", (Object)bucket);
        if (this.currentConfig != null && this.currentConfig.hasBucket(bucket)) {
            LOGGER.debug("Bucket {} already opened.", (Object)bucket);
            return Observable.just(this.currentConfig);
        }
        if (this.seedHosts == null || this.seedHosts.isEmpty()) {
            return Observable.error(new ConfigurationException("Seed node list not provided or empty."));
        }
        Observable<Tuple2<LoaderType, BucketConfig>> observable = Observable.mergeDelayError(Observable.from(this.seedHosts).map(new Func1<NetworkAddress, Observable<Tuple2<LoaderType, BucketConfig>>>(){

            @Override
            public Observable<Tuple2<LoaderType, BucketConfig>> call(NetworkAddress seedHost) {
                Observable<Tuple2<LoaderType, BucketConfig>> node = ((Loader)DefaultConfigurationProvider.this.loaderChain.get(0)).loadConfig(seedHost, bucket, username, password);
                for (int i = 1; i < DefaultConfigurationProvider.this.loaderChain.size(); ++i) {
                    node = node.onErrorResumeNext(((Loader)DefaultConfigurationProvider.this.loaderChain.get(i)).loadConfig(seedHost, bucket, username, password));
                }
                return node;
            }
        })).take(1);
        return observable.doOnNext(new Action1<Tuple2<LoaderType, BucketConfig>>(){

            @Override
            public void call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.registerBucketForRefresh(tuple.value1(), tuple.value2());
            }
        }).map(new Func1<Tuple2<LoaderType, BucketConfig>, ClusterConfig>(){

            @Override
            public ClusterConfig call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.upsertBucketConfig(tuple.value2());
                return DefaultConfigurationProvider.this.currentConfig;
            }
        }).doOnNext(new Action1<ClusterConfig>(){

            @Override
            public void call(ClusterConfig clusterConfig) {
                LOGGER.info("Opened bucket " + bucket);
                if (DefaultConfigurationProvider.this.eventBus != null && DefaultConfigurationProvider.this.eventBus.hasSubscribers()) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketOpenedEvent(bucket));
                }
                DefaultConfigurationProvider.this.bootstrapped = true;
            }
        }).doOnError(new Action1<Throwable>(){

            @Override
            public void call(Throwable throwable) {
                LOGGER.debug("Explicitly closing bucket {} after failed open attempt to clean resources.", (Object)bucket);
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
            }
        }).onErrorResumeNext(new Func1<Throwable, Observable<ClusterConfig>>(){

            @Override
            public Observable<ClusterConfig> call(Throwable throwable) {
                return Observable.error(new ConfigurationException("Could not open bucket.", throwable));
            }
        });
    }

    @Override
    public Observable<ClusterConfig> closeBucket(String name) {
        LOGGER.debug("Closing bucket {}", (Object)name);
        return Observable.just(name).map(new Func1<String, ClusterConfig>(){

            @Override
            public ClusterConfig call(String bucket) {
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
                LOGGER.info("Closed bucket " + bucket);
                if (DefaultConfigurationProvider.this.eventBus != null && DefaultConfigurationProvider.this.eventBus.hasSubscribers()) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketClosedEvent(bucket));
                }
                return DefaultConfigurationProvider.this.currentConfig;
            }
        });
    }

    @Override
    public Observable<Boolean> closeBuckets() {
        LOGGER.debug("Closing all open buckets");
        if (this.currentConfig == null || this.currentConfig.bucketConfigs().isEmpty()) {
            return Observable.just(true);
        }
        HashSet<String> configs = new HashSet<String>(this.currentConfig.bucketConfigs().keySet());
        return Observable.from(configs).observeOn(this.environment.scheduler()).flatMap(new Func1<String, Observable<? extends ClusterConfig>>(){

            @Override
            public Observable<? extends ClusterConfig> call(String bucketName) {
                return DefaultConfigurationProvider.this.closeBucket(bucketName);
            }
        }).last().map(new Func1<ClusterConfig, Boolean>(){

            @Override
            public Boolean call(ClusterConfig clusterConfig) {
                return true;
            }
        });
    }

    @Override
    public void proposeBucketConfig(String bucket, String rawConfig) {
        try {
            LOGGER.debug("New Bucket {} config proposed.", (Object)bucket);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Proposed raw config is {}", (Object)rawConfig);
            }
            JsonNode configNodes = BucketConfigParser.jackson().readTree(rawConfig);
            String bucketName = bucket == null ? configNodes.get("name").textValue() : bucket;
            JsonNode revNode = configNodes.get("rev");
            long newRev = revNode == null ? 0L : revNode.asLong();
            BucketConfig oldConfig = this.currentConfig.bucketConfig(bucketName);
            if (newRev > 0L && oldConfig != null && newRev <= oldConfig.rev()) {
                LOGGER.trace("Not applying new configuration, older or same rev ID.");
                return;
            }
            BucketConfig config = BucketConfigParser.parse(rawConfig, this.environment);
            this.upsertBucketConfig(config);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not read proposed configuration, ignoring.", ex);
        }
    }

    @Override
    public void signalOutdated() {
        LOGGER.debug("Received signal to proactively refresh (a maybe outdated) configuration.");
        if (this.currentConfig.bucketConfigs().isEmpty()) {
            LOGGER.debug("Ignoring outdated signal, since no buckets are open.");
            return;
        }
        for (Refresher refresher : this.refreshers.values()) {
            refresher.refresh(this.currentConfig);
        }
    }

    @Override
    public synchronized Observable<Boolean> shutdown() {
        if (this.terminated) {
            LOGGER.debug("ConfigurationProvider already shut down, ignoring.");
            return Observable.just(true);
        }
        LOGGER.debug("Shutting down ConfigurationProvider.");
        this.terminated = true;
        return Observable.just(true).doOnNext(new Action1<Boolean>(){

            @Override
            public void call(Boolean ignored) {
                if (DefaultConfigurationProvider.this.configObservable != null) {
                    LOGGER.trace("Completing ConfigObservable for termination.");
                    DefaultConfigurationProvider.this.configObservable.onCompleted();
                }
            }
        }).flatMap(new Func1<Boolean, Observable<Boolean>>(){

            @Override
            public Observable<Boolean> call(Boolean aBoolean) {
                Observable<Boolean> shutdownObs = Observable.just(true);
                for (final Refresher refresher : DefaultConfigurationProvider.this.refreshers.values()) {
                    shutdownObs = shutdownObs.flatMap(new Func1<Boolean, Observable<Boolean>>(){

                        @Override
                        public Observable<Boolean> call(Boolean ignored) {
                            LOGGER.trace("Initiating {} shutdown.", (Object)refresher.getClass().getSimpleName());
                            return refresher.shutdown();
                        }
                    });
                }
                return shutdownObs;
            }
        });
    }

    private void registerBucketForRefresh(LoaderType loaderType, BucketConfig bucketConfig) {
        LOGGER.debug("Registering Bucket {} to refresh at Loader {}", (Object)bucketConfig.name(), (Object)loaderType);
        Refresher refresher = this.refreshers.get((Object)loaderType);
        if (refresher == null) {
            throw new IllegalStateException("Could not find refresher for loader type: " + (Object)((Object)loaderType));
        }
        refresher.registerBucket(bucketConfig.name(), bucketConfig.username(), bucketConfig.password()).subscribe();
    }

    private void upsertBucketConfig(BucketConfig newConfig) {
        ClusterConfig cluster = this.currentConfig;
        BucketConfig oldConfig = cluster.bucketConfig(newConfig.name());
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            LOGGER.trace("Not applying new configuration, older or same rev ID.");
            return;
        }
        if (newConfig.password() == null && oldConfig != null) {
            newConfig.password(oldConfig.password());
        }
        if (oldConfig != null) {
            newConfig.username(oldConfig.username());
        }
        cluster.setBucketConfig(newConfig.name(), newConfig);
        LOGGER.debug("Applying new configuration {}", (Object)newConfig);
        this.currentConfig = cluster;
        boolean tainted = newConfig.tainted();
        for (Refresher refresher : this.refreshers.values()) {
            if (tainted) {
                refresher.markTainted(newConfig);
                continue;
            }
            refresher.markUntainted(newConfig);
        }
        this.configObservable.onNext(this.currentConfig);
    }

    private void removeBucketConfig(String name) {
        LOGGER.debug("Removing bucket {} configuration from known configs.", (Object)name);
        ClusterConfig cluster = this.currentConfig;
        cluster.deleteBucketConfig(name);
        this.currentConfig = cluster;
        this.configObservable.onNext(this.currentConfig);
    }
}

