/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.logging;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.JdkLoggerFactory;
import com.couchbase.client.core.logging.Log4JLoggerFactory;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.core.logging.Slf4JLoggerFactory;
import com.couchbase.client.deps.io.netty.util.internal.ThreadLocalRandom;

public abstract class CouchbaseLoggerFactory {
    private static volatile RedactionLevel redactionLevel = RedactionLevel.NONE;
    private static volatile CouchbaseLoggerFactory defaultFactory = CouchbaseLoggerFactory.newDefaultFactory(CouchbaseLoggerFactory.class.getName());

    private static CouchbaseLoggerFactory newDefaultFactory(String name) {
        CouchbaseLoggerFactory f;
        try {
            f = new Slf4JLoggerFactory(true, redactionLevel);
            f.newInstance(name).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable t1) {
            try {
                f = new Log4JLoggerFactory(redactionLevel);
                f.newInstance(name).debug("Using Log4J as the default logging framework");
            }
            catch (Throwable t2) {
                f = new JdkLoggerFactory(redactionLevel);
                f.newInstance(name).debug("Using java.util.logging as the default logging framework");
            }
        }
        if (redactionLevel != RedactionLevel.NONE) {
            f.newInstance(name).info("Log redaction enabled. Previous log entries might not be redacted. Logs have reduced identifying information. Diagnosis and support of issues may be challenging or not possible in this configuration.");
        }
        return f;
    }

    public static CouchbaseLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(CouchbaseLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        CouchbaseLoggerFactory.defaultFactory = defaultFactory;
    }

    public static RedactionLevel getRedactionLevel() {
        return redactionLevel;
    }

    public static void setRedactionLevel(RedactionLevel redactionLevel) {
        if (redactionLevel == null) {
            throw new NullPointerException("redactionLevel");
        }
        CouchbaseLoggerFactory.redactionLevel = redactionLevel;
    }

    public static CouchbaseLogger getInstance(Class<?> clazz) {
        return CouchbaseLoggerFactory.getInstance(clazz.getName());
    }

    public static CouchbaseLogger getInstance(String name) {
        return CouchbaseLoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract CouchbaseLogger newInstance(String var1);

    static {
        try {
            Class.forName(ThreadLocalRandom.class.getName(), true, CouchbaseLoggerFactory.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

