/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.logging;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.core.logging.Slf4JLogger;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public class Slf4JLoggerFactory
extends CouchbaseLoggerFactory {
    private final RedactionLevel redactionLevel;

    public Slf4JLoggerFactory(RedactionLevel redactionLevel) {
        this.redactionLevel = redactionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Slf4JLoggerFactory(boolean failIfNOP, RedactionLevel redactionLevel) {
        this.redactionLevel = redactionLevel;
        assert (failIfNOP);
        final StringBuffer buf = new StringBuffer();
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                    buf.append((char)b);
                }
            }, true, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        try {
            if (LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
                throw new NoClassDefFoundError(buf.toString());
            }
            err.print(buf);
            err.flush();
        }
        finally {
            System.setErr(err);
        }
    }

    @Override
    public CouchbaseLogger newInstance(String name) {
        return new Slf4JLogger(LoggerFactory.getLogger((String)name), this.redactionLevel);
    }
}

