/**
 * 
 */
package org.gcube.accounting.datamodel.backwardcompatibility;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;

public class MoveToCreationTimeAction implements FieldAction {
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
		if(value instanceof Date){
			Calendar calendar = Calendar.getInstance();
			calendar.setTime((Date) value);
			value = calendar;
		}
		if(value instanceof Long){
			Calendar calendar = Calendar.getInstance();
			calendar.setTimeInMillis((Long) value);
			value = calendar;
		}
		
		if(value instanceof Calendar){
			usageRecord.setCreationTime((Calendar) value);
		}else{
			throw new InvalidValueException();
		}
		
		return value;
	}
}