/**
 * 
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.validators.NotEmptyIfNotNullValidator;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public abstract class AbstractPortletUsageRecord extends BasicUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 8339324883678974869L;
	
	@DeprecatedWarning @MoveToConsumerId
	protected static final String USER_ID = "userId";
	@Target(ElementType.FIELD)
	@Retention(RetentionPolicy.RUNTIME)
	@FieldDecorator(managed=MoveToConsumerIdAction.class) 
	protected @interface MoveToConsumerId { }
	protected class MoveToConsumerIdAction implements FieldAction {
		@Override
		public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
			NotEmptyIfNotNullValidator neinnv = new NotEmptyIfNotNullValidator();
			value = neinnv.validate(key, value, usageRecord);
			usageRecord.setConsumerId((String) value);
			return value;
		}
	}
	
	@RequiredField @NotEmpty
	public static final String PORTLET_ID = "portletId";
	@RequiredField @NotEmpty
	public static final String OPERATION_ID = "operationId";
	@NotEmptyIfNotNull
	public static final String MESSAGE = "message";
	
	public AbstractPortletUsageRecord(){
		super();
	}
	
	public AbstractPortletUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
		super(properties);
	}
	
	private static final String ABSTRACT_TO_REPLACE = "Abstract";
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String giveMeUsageRecordType() {
		return AbstractPortletUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
	}
	
	/* *
	 * Use {@link #getConsumerId()} instead
	 * @return the Consumer ID
	 * /
	@Deprecated
	public String getUserId() {
		return (String) this.resourceProperties.get(CONSUMER_ID);
	}

	/**
	 * If correct,ly set is a duplicated for Consumer Id, use 
	 * {@link #setConsumerId()} instead.
	 * @param userId Consumer Id
	 * @throws InvalidValueException if fails
	 * /
	@Deprecated
	public void setUserId(String userId) throws InvalidValueException {
		setResourceProperty(USER_ID, userId);
		
	}
	*/
	
	public String getPortletId() {
		return (String) this.resourceProperties.get(PORTLET_ID);
	}

	public void setPortletId(String portletId) throws InvalidValueException {
		setResourceProperty(PORTLET_ID, portletId);
	}
	
	public String getOperationId() {
		return (String) this.resourceProperties.get(OPERATION_ID);
	}

	public void setOperationId(String operationId) throws InvalidValueException {
		setResourceProperty(OPERATION_ID, operationId);
	}
	
	public String getMessage() {
		return (String) this.resourceProperties.get(MESSAGE);
	}

	public void setMessage(String message) throws InvalidValueException {
		setResourceProperty(MESSAGE, message);
	}
}
