/**
 * 
 */
package org.gcube.accounting.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.datamodel.UsageRecord;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class FallbackPersistenceBackend extends AccountingPersistenceBackend {
	
	private File accountingFallbackFile; 
	
	/**
	 * @return the accountingFallbackFile
	 */
	protected File getAccountingFallbackFile() {
		return accountingFallbackFile;
	}
	
	protected FallbackPersistenceBackend(File accountingFallbackFile) {
		super(null, AggregationScheduler.newInstance());
		this.accountingFallbackFile = accountingFallbackFile;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void prepareConnection(AccountingPersistenceConfiguration configuration) {
		// Nothing TO DO
	}

	/**
	 * {@inheritDoc}
	 * This method is synchronized on {@link File} used, so any actions which 
	 * has to modify, rename or delete the file must be synchronized on this 
	 * file. To retrieve it use {@link #getAccountingFallbackFile()} method.  
	 * This is intended for internal library usage only so that is protected
	 */
	@Override
	protected void reallyAccount(UsageRecord usageRecord) throws Exception {
		printLine(String.valueOf( usageRecord));
	}

	public void printLine(String line) throws Exception {
		synchronized (accountingFallbackFile) {
			try(FileWriter fw = new FileWriter(accountingFallbackFile, true);
				BufferedWriter bw = new BufferedWriter(fw);
				PrintWriter out = new PrintWriter(bw)){
					out.println(line);
					out.flush();
			} catch( IOException e ){
			   throw e;
			}
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws Exception {
		// Nothing TO DO
	}
	
}
