/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.rest.resources.raw;

import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.apache.log4j.Logger;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordsResource;
import org.gcube.accounting.datamodel.JobUsageRecord;
import org.gcube.accounting.datamodel.NetworkUsageRecord;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.StorageRecord;
import org.gcube.accounting.datamodel.VMUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.rest.ServerErrorException;

@Path("/usagerecords")
public class RawRecordsResource extends AbstractRecordsResource<RawUsageRecord> {

	private static Logger logger = Logger.getLogger(RawRecordsResource.class);
	
	public RawUsageRecord createRecord(RawUsageRecord record) {
		return record;
	}

	@Path("{usagerecord}")
	public RawRecordResource getRecordResource(
			@PathParam("usagerecord") String record_id) {
		RawRecordResource out = new RawRecordResource(record_id);
		out.setUserId((String)request.getAttribute("userId"));
		return out;
	}

	@DELETE
	public void delete() {
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			db.clear();
		} catch (Exception e) {
			e.printStackTrace();
			throw new ServerErrorException();
		}
	}

	protected void validate(RawUsageRecord record) throws InvalidValueException {
		String resourceType = record.getResourceType();
		logger.debug("resource type is " + resourceType);
		if(resourceType.equals(VMUsageRecord.TYPE_VM))
			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
		if(resourceType.equals(NetworkUsageRecord.TYPE_NETWORK))
			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
		if(resourceType.equals(JobUsageRecord.TYPE_JOB))
			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
		if(resourceType.equals(StorageRecord.STORAGE))
			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
		record.validate();
	}
	
}
