/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.configuration;

import javax.naming.NamingException;
import org.gcube.accounting.webservice.configuration.ConfigurationResource;
import org.gcube.accounting.webservice.configuration.PropertiesBaseConfiguration;

public class Configuration
extends PropertiesBaseConfiguration {
    private static String configurationFile = "gcube-accounting-usagetracker.properties";
    private static Configuration instance;

    public static Configuration getInstance() {
        if (instance == null) {
            try {
                instance = new Configuration();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    private Configuration() throws NamingException {
        super(ConfigurationResource.getConfigurationLocation() + "/" + configurationFile);
    }

    public String getDBHost() {
        return super.getString("dbHost");
    }

    public int getDBPort() {
        return super.getInt("dbPort", Integer.valueOf(27017));
    }

    public String getDBName() {
        return super.getString("dbName");
    }

    public String getDBUser() {
        return super.getString("dbUser");
    }

    public String getDBPassword() {
        return super.getString("dbPassword");
    }

    public Boolean isMembershipServiceEnabled() {
        return super.getBoolean("membershipService.enabled", Boolean.valueOf(false));
    }

    public String getMembershipServiceURL() {
        return super.getString("membershipService.url");
    }

    public Boolean isMembershipServiceAuthnEnabled() {
        return super.getBoolean("membershipService.authn.enabled", Boolean.valueOf(false));
    }

    public String getMembershipUsername() {
        return super.getString("membershipService.username");
    }

    public String getMembershipPassword() {
        return super.getString("membershipService.password");
    }

    public String getDefaultGroup() {
        String out = super.getString("defaultUserGroup");
        if (out == null || out.trim().isEmpty()) {
            return "nogroup";
        }
        return out;
    }
}

