/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.configuration;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.log4j.Logger;
import org.gcube.accounting.webservice.configuration.CommonConfigurator;

public class StartupListener implements ServletContextListener {

	private static final String loggingConfigurationFile = "gcube-accounting-usagetracker-log4j.properties";

	private static Logger logger = Logger.getLogger(StartupListener.class);

	private CommonConfigurator ac;

	public void contextInitialized(ServletContextEvent event) {
		System.out.println(loggingConfigurationFile);
		this.ac = new CommonConfigurator();
		this.ac.configureLogging(loggingConfigurationFile);
		this.ac.configureProxy(Configuration.getInstance());
		this.ac.configureAuthentication(Configuration.getInstance());
		this.ac.configureAuthorization(Configuration.getInstance());
	}

	public void contextDestroyed(ServletContextEvent event) {
		this.ac.destroy();
	}

}
