/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.persistence;

public enum DBField {
	
	UR_ID("urId"),
	CREATOR_ID("creatorId"),
	START_TIME("startTime"),
	END_TIME("endTime"),
	CONSUMER_ID("consumerId"),
	FULLY_QUALIFIED_CONSUMER_ID("fullyQualifiedConsumerId"),
	RESOURCE_TYPE("resourceType"),
	CREATE_TIME("createTime"),
	MODIFY_TIME("modifyTime"),
	RESOURCE_OWNER("resourceOwner"), 

	USAGE_RECORDS("usageRecords"),
	CONSUMERS_RECORDS("consumersRecords"),
	SUBSET_GROUP("subsetGroup");
	
	private String name;
	
	private DBField(String name) {
		this.name = name;
	}
	
	public String toString() {
		return this.name;
	}
}
