/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.rest.resources.vm;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordsResource;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.VMUsageRecord;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryField;
import org.gcube.accounting.datamodel.query.QueryOperator;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.rest.BadRequestException;
import org.gcube.accounting.exception.rest.NotAuthorizedException;

@Path("/usagerecords/vm")
public class VMRecordsResource extends AbstractRecordsResource<VMUsageRecord> {

	private static Logger logger = Logger.getLogger(VMRecordsResource.class);
	
	public VMUsageRecord createRecord(RawUsageRecord record) {
		return new VMUsageRecord(record);
	}

	@Path("{usagerecord}")
	public VMRecordResource getRecordResource(@PathParam("usagerecord") String record_id) {
		VMRecordResource out = new VMRecordResource(record_id);
		out.setUserId((String)request.getAttribute("userId"));
		return out;
	}

	protected void validate(VMUsageRecord record) throws InvalidValueException {
		record.validate();
	}

	protected QueryClause getTypeClause() {
		return new QueryClause(QueryField.RESOURCE_TYPE, QueryOperator.eq, VMUsageRecord.TYPE_VM);
	}

}
