/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.Group;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryHelper;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.QueryFormatException;
import org.gcube.accounting.exception.rest.BadRequestException;
import org.gcube.accounting.exception.rest.NotAuthorizedException;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.usagetracker.configuration.Configuration;
import org.gcube.accounting.usagetracker.membership.MembershipRestAPI;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

public abstract class AbstractRecordsResource<T extends UsageRecord> {
    @Context
    protected HttpServletRequest request;
    private static Logger logger = Logger.getLogger(AbstractRecordsResource.class);

    private List<String> getGroupPathFor(String consumerId) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(consumerId);
        if (Configuration.getInstance().isMembershipServiceEnabled().booleanValue()) {
            String membershipServiceURL = Configuration.getInstance().getMembershipServiceURL();
            MembershipRestAPI membershipService = new MembershipRestAPI(membershipServiceURL);
            if (Configuration.getInstance().isMembershipServiceAuthnEnabled().booleanValue()) {
                logger.debug((Object)"accessing the membership service with username/password");
                String userName = Configuration.getInstance().getMembershipUsername();
                String password = Configuration.getInstance().getMembershipPassword();
                membershipService.setUserToken(userName, password);
            } else {
                logger.debug((Object)"accessing the membership service anonymously");
            }
            Group userGroup = membershipService.getGroups(consumerId);
            if (userGroup != null) {
                logger.debug((Object)("Membership found: " + userGroup.toString()));
                path.addAll(userGroup.getPath());
            } else {
                logger.warn((Object)("Membership not found for consumer " + consumerId));
                path.add(Configuration.getInstance().getDefaultGroup());
            }
        } else {
            logger.info((Object)"No membership service available. Using consumerId");
            path.add(Configuration.getInstance().getDefaultGroup());
        }
        Collections.reverse(path);
        return path;
    }

    private String getStringPath(List<String> groupPath) {
        String groupPathString = "";
        for (String string : groupPath) {
            groupPathString = groupPathString + "." + string;
        }
        groupPathString = groupPathString.substring(1);
        return groupPathString;
    }

    @POST
    @Consumes(value={"application/xml"})
    public String insertUsageRecord(T record) throws NotAuthorizedException {
        logger.info((Object)"inserting new usage record...");
        if (!SecurityManager.isAllowed((String)this.getUserId(), (Action)Action.WRITE_RECORD)) {
            logger.info((Object)("User " + this.getUserId() + " doesn't have permission to perform " + Action.WRITE_RECORD));
            throw new NotAuthorizedException();
        }
        try {
            if (record.getResourceType() == null || record.getResourceType().isEmpty()) {
                String message = "unable to insert record: a 'resourceType' must be set";
                logger.warn((Object)message);
                throw new BadRequestException(message);
            }
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            if (record.getFullyQualifiedConsumerId() == null) {
                List groupPath = this.getGroupPathFor(record.getConsumerId());
                String groupPathString = this.getStringPath(groupPath);
                record.setFullyQualifiedConsumerId(groupPathString);
            }
            if (!SecurityManager.isAllowed((String)this.getUserId(), (Action)Action.WRITE_RECORD, (String)record.getFullyQualifiedConsumerId())) {
                logger.info((Object)("User " + this.getUserId() + " doesn't have permission to perform '" + Action.WRITE_RECORD + "' over " + record.getFullyQualifiedConsumerId()));
                throw new NotAuthorizedException();
            }
            record.setId(UUID.randomUUID().toString());
            logger.debug((Object)("setting record id to '" + record.getId() + "'"));
            if (SecurityManager.isAuthnEnabled()) {
                record.setCreatorId(this.getUserId());
                logger.debug((Object)("forcing creator id to '" + record.getCreatorId() + "'"));
            }
            logger.debug((Object)record.getStartTime());
            try {
                this.validate(record);
            }
            catch (InvalidValueException e) {
                logger.info((Object)("invalid data for upload: " + e.getMessage()));
                throw new BadRequestException(e.getMessage());
            }
            db.addUsageRecord(record);
            logger.info((Object)("record added: " + record.getId()));
            return record.getId();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    protected abstract void validate(T var1) throws InvalidValueException;

    public Collection<T> getRecords(Map<String, QueryClause> clauses) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return this.convert(db.getUsageRecordByQuery(clauses));
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    private List<QueryClause> getTypeSpecificClause() {
        Vector<QueryClause> out = new Vector<QueryClause>();
        QueryClause typeClause = this.getTypeClause();
        if (typeClause != null) {
            out.add(typeClause);
        }
        return out;
    }

    protected QueryClause getTypeClause() {
        return null;
    }

    @GET
    @Produces(value={"application/xml"})
    public Collection<T> getRecords(@QueryParam(value="query") String query) throws NotAuthorizedException {
        if (!SecurityManager.isAllowed((String)this.getUserId(), (Action)Action.READ_RECORD)) {
            logger.info((Object)("User " + this.getUserId() + " doesn't have permission to perform " + Action.READ_RECORD));
            throw new NotAuthorizedException();
        }
        try {
            Map params = QueryHelper.parseQuery((String)query);
            for (QueryClause clause : this.getTypeSpecificClause()) {
                params.put(clause.getKey(), clause);
            }
            Collection records = this.getRecords(params);
            ArrayList<UsageRecord> recordsToReturn = new ArrayList<UsageRecord>();
            for (UsageRecord t : records) {
                if (SecurityManager.isAllowed((String)this.getUserId(), (Action)Action.READ_RECORD, (String)t.getFullyQualifiedConsumerId())) {
                    recordsToReturn.add(t);
                    continue;
                }
                logger.debug((Object)("filtering out record " + t.getId()));
            }
            return recordsToReturn;
        }
        catch (QueryFormatException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private String getUserId() {
        return (String)this.request.getAttribute("userId");
    }

    private Collection<T> convert(Collection<RawUsageRecord> records) {
        Vector<UsageRecord> out = new Vector<UsageRecord>();
        for (RawUsageRecord rawur : records) {
            out.add(this.createRecord(rawur));
        }
        return out;
    }

    protected abstract T createRecord(RawUsageRecord var1);
}

