/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.VersionHelper;
import org.gcube.accounting.VersionInfo;
import org.gcube.accounting.datamodel.Consumer;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.usagetracker.datamodel.DCI;
import org.gcube.accounting.usagetracker.datamodel.ResourceType;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.gcube.accounting.ut.UpdateInfo;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/meta")
public class MetaResource {
    private static Logger logger = Logger.getLogger(MetaResource.class);
    @Context
    protected HttpServletRequest request;

    @GET
    @Path(value="/version")
    @Produces(value={"application/xml"})
    public VersionInfo getVersion() {
        return new VersionHelper("/org/venusc/mab/usagetracker/version.properties").getVersionInfo();
    }

    @GET
    @Path(value="/dcis")
    @Produces(value={"application/xml"})
    public Collection<DCI> getDCI() {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            Vector<DCI> out = new Vector<DCI>();
            for (String s : db.getTrackedResourceOwners()) {
                DCI dci = new DCI();
                dci.setName(s);
                out.add(dci);
            }
            return out;
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @GET
    @Path(value="/resource_types")
    @Produces(value={"application/json"})
    public Collection<ResourceType> getResourceTypes() {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            Vector<ResourceType> out = new Vector<ResourceType>();
            for (String s : db.getTrackedResourceTypes()) {
                ResourceType rt = new ResourceType();
                rt.setName(s);
                out.add(rt);
            }
            return out;
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @GET
    @Path(value="/update_info")
    @Produces(value={"application/xml"})
    public Collection<UpdateInfo> getLastUpdates() {
        Vector<UpdateInfo> out = new Vector<UpdateInfo>();
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            for (String dci : db.getTrackedResourceOwners()) {
                UpdateInfo info = new UpdateInfo();
                info.setDci(dci);
                info.setTimestamp(db.getLastUpdate(dci));
                out.add(info);
            }
            return out;
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @GET
    @Path(value="/consumers")
    @Produces(value={"application/xml"})
    public Collection<Consumer> getConsumers() {
        Vector<Consumer> outc = new Vector<Consumer>();
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            ArrayList<String> set = new ArrayList<String>();
            Collection consumerGroup = db.getConsumersGroup();
            for (ArrayList currentGroup : consumerGroup) {
                ArrayList subSequence = MetaResource.getDottedSubstrings((ArrayList)currentGroup);
                for (String string : subSequence) {
                    if (set.contains(string)) continue;
                    set.add(string);
                }
            }
            Collections.sort(set);
            for (String element : set) {
                if (!SecurityManager.isAllowed((String)this.getUserId(), (Action)Action.READ_RECORD, (String)element)) continue;
                outc.add(new Consumer(element));
            }
            return outc;
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    private static ArrayList<String> getDottedSubstrings(ArrayList<String> current) {
        ArrayList<String> result = new ArrayList<String>();
        int size = current.size();
        for (int i = 0; i < size; ++i) {
            result.add(MetaResource.getDottedRepresentation(current.subList(0, i + 1)));
        }
        return result;
    }

    private static String getDottedRepresentation(List<String> list) {
        int size = list.size();
        String result = "";
        for (int i = 0; i < size; ++i) {
            result = result + list.get(i) + ".";
        }
        return result.substring(0, result.length() - 1);
    }

    private String getUserId() {
        return (String)this.request.getAttribute("userId");
    }
}

