/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.raw;

import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordsResource;
import org.gcube.accounting.usagetracker.rest.resources.raw.RawRecordResource;

@Path(value="/usagerecords")
public class RawRecordsResource
extends AbstractRecordsResource<RawUsageRecord> {
    private static Logger logger = Logger.getLogger(RawRecordsResource.class);

    public RawUsageRecord createRecord(RawUsageRecord record) {
        return record;
    }

    @Path(value="{usagerecord}")
    public RawRecordResource getRecordResource(@PathParam(value="usagerecord") String record_id) {
        RawRecordResource out = new RawRecordResource(record_id);
        out.setUserId((String)this.request.getAttribute("userId"));
        return out;
    }

    @DELETE
    public void delete() {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            db.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServerErrorException();
        }
    }

    protected void validate(RawUsageRecord record) throws InvalidValueException {
        String resourceType = record.getResourceType();
        logger.debug((Object)("resource type is " + resourceType));
        if (resourceType.equals("VM")) {
            throw new InvalidValueException("cannot upload " + resourceType + " records through the generic path");
        }
        if (resourceType.equals("network")) {
            throw new InvalidValueException("cannot upload " + resourceType + " records through the generic path");
        }
        if (resourceType.equals("job")) {
            throw new InvalidValueException("cannot upload " + resourceType + " records through the generic path");
        }
        if (resourceType.equals("storage")) {
            throw new InvalidValueException("cannot upload " + resourceType + " records through the generic path");
        }
        record.validate();
    }
}

