/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.filter;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Enumeration;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public class SecurityFilter implements Filter {

	private static Logger logger = Logger.getLogger(SecurityFilter.class);

	public void destroy() {
	}

	public void doFilter(final ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {
		
		HttpServletRequest request = (HttpServletRequest) req;
		HttpServletResponse response = (HttpServletResponse) res;
		Enumeration<String> list = request.getHeaderNames();
		String s = "";
		while(list.hasMoreElements()){
			s+=" "+list.nextElement();
		}
		logger.info(s);
		String requestURI = request.getRequestURI();
		logger.info("request URI = "+requestURI);
		String signatureClient = request.getHeader("signature");
		logger.info("signatureClient = "+signatureClient);
		if((signatureClient == null) || (signatureClient.equals("")))
			((HttpServletResponse)response).setStatus(401);
		String secretKey = "wJaIrXUtnFEMI/K7MDENG/bPxRfiCYzEXAMPLEKEY";
		String signature = "";
		try {
			signature = Signature.calculateRFC2104HMAC(requestURI,secretKey);
		} catch (SignatureException e) {
			((HttpServletResponse)response).sendError(500, "An error occurred while processing the signature for your request");
		}
		logger.info("Signature = "+signature);
		//signatureClient = signature = "s";
		if(signatureClient.equals(signature))
			chain.doFilter(req, res);
		else
			((HttpServletResponse)response).setStatus(401);


	}
	

	public void init(FilterConfig config) throws ServletException {
	}
}