/*
 * Copyright (C) 2012 Engineering Ingegneria Informatica S.p.A.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gcube.accounting.usagetracker.rest.resources.storage;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordsResource;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.StorageRecord;
import org.gcube.accounting.datamodel.VMUsageRecord;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryField;
import org.gcube.accounting.datamodel.query.QueryOperator;
import org.gcube.accounting.exception.InvalidValueException;

@Path("/usagerecords/storage")
public class StorageRecordsResource extends AbstractRecordsResource<StorageRecord>{

	public StorageRecord createRecord(RawUsageRecord record) {
		return new StorageRecord(record);
	}

	@Path("{usagerecord}")
	public StorageRecordResource getRecordResource(@PathParam("usagerecord") String record_id) {
		StorageRecordResource out = new StorageRecordResource(record_id);
		out.setUserId((String)request.getAttribute("userId"));
		return out;
	}

	protected void validate(StorageRecord record) throws InvalidValueException {
		record.validate();
	}

	protected QueryClause getTypeClause() {
		return new QueryClause(QueryField.RESOURCE_TYPE, QueryOperator.eq, StorageRecord.STORAGE);
	}

}
