/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryOperator;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.NotFoundException;
import org.gcube.accounting.usagetracker.configuration.Configuration;
import org.gcube.accounting.usagetracker.persistence.DBField;

public class UsageTrackerDB {
    private static final String RSP_PREFIX = "rsp:";
    private static final String CP_PREFIX = "cp:";
    private static final String DOLLAR = "\\\\DOL";
    private static final String DOT = "\\\\DOT";
    private static final String BACKSLASH = "\\\\\\\\";
    private static UsageTrackerDB utdb;
    private Mongo mongo;
    private DB db;
    private static DBField[] baseFields;
    private static Logger logger;

    private UsageTrackerDB(String hostname, String dbname, int port) throws UnknownHostException {
        this.mongo = new Mongo(hostname, port);
        this.db = this.mongo.getDB(dbname);
    }

    private UsageTrackerDB(String hostname, String dbname, int port, String username, String password) throws UnknownHostException {
        this(hostname, dbname, port);
        this.db.authenticate(username, password.toCharArray());
    }

    private boolean isBaseField(String field) {
        for (DBField f : baseFields) {
            if (!f.toString().equals(field)) continue;
            return true;
        }
        return false;
    }

    public static UsageTrackerDB getStorage() throws UnknownHostException {
        if (utdb == null) {
            utdb = new UsageTrackerDB(Configuration.getInstance().getDBHost(), Configuration.getInstance().getDBName(), Configuration.getInstance().getDBPort());
        }
        return utdb;
    }

    private DBObject createDBObject(UsageRecord ur) {
        Double value;
        Long value2;
        BasicDBObject doc = new BasicDBObject();
        doc.put(DBField.UR_ID.toString(), (Object)ur.getId());
        if (ur.getCreateTime() != null) {
            doc.put(DBField.CREATE_TIME.toString(), (Object)ur.getCreateTime().getTimeInMillis());
        }
        if (ur.getModifyTime() != null) {
            doc.put(DBField.MODIFY_TIME.toString(), (Object)ur.getModifyTime().getTimeInMillis());
        }
        doc.put(DBField.CREATOR_ID.toString(), (Object)ur.getCreatorId());
        doc.put(DBField.CONSUMER_ID.toString(), (Object)ur.getConsumerId());
        doc.put(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString(), (Object)ur.getFullyQualifiedConsumerId());
        doc.put(DBField.RESOURCE_TYPE.toString(), (Object)ur.getResourceType());
        doc.put(DBField.RESOURCE_OWNER.toString(), (Object)ur.getResourceOwner());
        if (ur.getStartTime() != null) {
            doc.put(DBField.START_TIME.toString(), (Object)ur.getStartTime().getTimeInMillis());
        }
        if (ur.getEndTime() != null) {
            doc.put(DBField.END_TIME.toString(), (Object)ur.getEndTime().getTimeInMillis());
        }
        Map properties = ur.getResourceSpecificProperties();
        for (String key : properties.keySet()) {
            if (doc.keySet().contains(key)) continue;
            try {
                value2 = Long.parseLong((String)properties.get(key));
                doc.put(RSP_PREFIX + this.encodeKey(key), (Object)value2);
            }
            catch (Exception e) {
                try {
                    value = Double.parseDouble((String)properties.get(key));
                    doc.put(RSP_PREFIX + this.encodeKey(key), (Object)value);
                }
                catch (Exception e2) {
                    doc.put(RSP_PREFIX + this.encodeKey(key), properties.get(key));
                }
                doc.put(RSP_PREFIX + this.encodeKey(key), properties.get(key));
            }
        }
        properties = ur.getCustomProperties();
        for (String key : properties.keySet()) {
            if (doc.keySet().contains(key)) continue;
            try {
                value2 = Long.parseLong((String)properties.get(key));
                doc.put(CP_PREFIX + this.encodeKey(key), (Object)value2);
            }
            catch (Exception e) {
                try {
                    value = Double.parseDouble((String)properties.get(key));
                    doc.put(CP_PREFIX + this.encodeKey(key), (Object)value);
                }
                catch (Exception e2) {
                    doc.put(CP_PREFIX + this.encodeKey(key), properties.get(key));
                }
                doc.put(CP_PREFIX + this.encodeKey(key), properties.get(key));
            }
        }
        return doc;
    }

    private RawUsageRecord createUsageRecord(DBObject dbo) {
        Calendar c;
        RawUsageRecord out = new RawUsageRecord();
        out.setId((String)dbo.get(DBField.UR_ID.toString()));
        out.setConsumerId((String)dbo.get(DBField.CONSUMER_ID.toString()));
        out.setFullyQualifiedConsumerId((String)dbo.get(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString()));
        out.setCreatorId((String)dbo.get(DBField.CREATOR_ID.toString()));
        out.setResourceType((String)dbo.get(DBField.RESOURCE_TYPE.toString()));
        out.setResourceOwner((String)dbo.get(DBField.RESOURCE_OWNER.toString()));
        if (dbo.get(DBField.START_TIME.toString()) != null) {
            c = Calendar.getInstance();
            c.setTimeInMillis((Long)dbo.get(DBField.START_TIME.toString()));
            try {
                out.setStartTime(c);
            }
            catch (InvalidValueException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (dbo.get(DBField.END_TIME.toString()) != null) {
            c = Calendar.getInstance();
            c.setTimeInMillis((Long)dbo.get(DBField.END_TIME.toString()));
            try {
                out.setEndTime(c);
            }
            catch (InvalidValueException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (dbo.get(DBField.CREATE_TIME.toString()) != null) {
            c = Calendar.getInstance();
            c.setTimeInMillis((Long)dbo.get(DBField.CREATE_TIME.toString()));
            out.setCreateTime(c);
        }
        if (dbo.get(DBField.MODIFY_TIME.toString()) != null) {
            c = Calendar.getInstance();
            c.setTimeInMillis((Long)dbo.get(DBField.MODIFY_TIME.toString()));
            out.setModifyTime(c);
        }
        for (String key : dbo.keySet()) {
            Object value;
            if (this.isBaseField(key) || !((value = dbo.get(key)) instanceof String) && !(value instanceof Double) && !(value instanceof Long)) continue;
            if (key.startsWith(RSP_PREFIX)) {
                out.setResourceSpecificProperty(this.decodeKey(key.substring(RSP_PREFIX.length())), dbo.get(key).toString());
            }
            if (!key.startsWith(CP_PREFIX)) continue;
            out.setCustomProperty(this.decodeKey(key.substring(CP_PREFIX.length())), dbo.get(key).toString());
        }
        return out;
    }

    public long size() {
        return this.getRecordsCollection().count();
    }

    public void addUsageRecord(UsageRecord ur) {
        ur.setCreateTime(Calendar.getInstance());
        try {
            ur.setModifyTime(ur.getCreateTime());
        }
        catch (InvalidValueException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        DBCollection coll = this.getRecordsCollection();
        logger.info((Object)String.format("inserting new record %s", ur.getId()));
        coll.insert(new DBObject[]{this.createDBObject(ur)});
        this.addConsumerGroup(ur.getFullyQualifiedConsumerId());
    }

    private DBCollection getRecordsCollection() {
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        logger.debug((Object)"enforcing indexes");
        coll.ensureIndex((DBObject)new BasicDBObject(DBField.UR_ID.toString(), (Object)1).append("unique", (Object)true).append("dropDups", (Object)true));
        coll.ensureIndex((DBObject)new BasicDBObject(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString(), (Object)1));
        return coll;
    }

    public void updateUsageRecord(UsageRecord ur) {
        DBCollection coll = this.getRecordsCollection();
        try {
            UsageRecord oldUR = this.getUsageRecord(ur.getId());
            ur.setCreateTime(oldUR.getCreateTime());
            ur.setModifyTime(Calendar.getInstance());
            DBObject newUR = this.createDBObject(ur);
            logger.info((Object)String.format("updating record %s", ur.getId()));
            coll.update((DBObject)new BasicDBObject().append("urId", (Object)ur.getId()), newUR);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private BasicDBObject getDBObject(String key, String op, String value) {
        try {
            Long d = Long.parseLong(value);
            return new BasicDBObject(op, (Object)d);
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.parseDouble(value);
                return new BasicDBObject(op, (Object)d);
            }
            catch (NumberFormatException e2) {
                return new BasicDBObject(op, (Object)value);
            }
        }
    }

    public Collection<RawUsageRecord> getUsageRecordByQuery(Map<String, QueryClause> props) {
        Vector<RawUsageRecord> out = new Vector<RawUsageRecord>();
        BasicDBObject query = new BasicDBObject();
        for (QueryClause clause : props.values()) {
            logger.debug((Object)("adding " + clause.getKey() + ":" + clause.getValue()));
            if (QueryOperator.eq.equals((Object)clause.getOperator())) {
                if (clause.getKey().equals(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString())) {
                    DBCollection coll = this.getRecordsCollection();
                    String pattern = "^" + clause.getValue().replace(".", "\\.");
                    Pattern match = Pattern.compile(pattern);
                    query.put(clause.getKey(), (Object)match);
                    continue;
                }
                try {
                    Long d = Long.parseLong(clause.getValue());
                    query.put(clause.getKey(), (Object)d);
                }
                catch (NumberFormatException e) {
                    try {
                        Double d = Double.parseDouble(clause.getValue());
                        query.put(clause.getKey(), (Object)d);
                    }
                    catch (NumberFormatException e2) {
                        query.put(clause.getKey(), (Object)clause.getValue());
                    }
                }
                continue;
            }
            if (QueryOperator.lt.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$lt", clause.getValue()));
                continue;
            }
            if (QueryOperator.lte.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$lte", clause.getValue()));
                continue;
            }
            if (QueryOperator.gt.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$gt", clause.getValue()));
                continue;
            }
            if (QueryOperator.gte.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$gte", clause.getValue()));
                continue;
            }
            logger.warn((Object)("operator '" + clause.getOperator() + "' is not yet supported"));
        }
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        DBCursor cursor = coll.find((DBObject)query);
        logger.debug((Object)("found " + cursor.size() + " records"));
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            out.add(this.createUsageRecord(dbo));
        }
        return out;
    }

    public UsageRecord getUsageRecord(String id) throws NotFoundException {
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.UR_ID.toString(), (Object)id);
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        DBCursor cur = coll.find((DBObject)query);
        if (cur.hasNext()) {
            DBObject out = cur.next();
            return this.createUsageRecord(out);
        }
        throw new NotFoundException("id");
    }

    public void deleteUsageRecord(String id) {
        logger.info((Object)String.format("deleting usage record '%s' ...", id));
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.UR_ID.toString(), (Object)id);
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        coll.remove((DBObject)query, WriteConcern.SAFE);
    }

    public void clear() {
        this.getTrackedUsers();
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        BasicDBObject query = new BasicDBObject();
        coll.remove((DBObject)query, WriteConcern.SAFE);
        coll = this.db.getCollection(DBField.CONSUMERS_RECORDS.toString());
        query = new BasicDBObject();
        coll.remove((DBObject)query, WriteConcern.SAFE);
    }

    public Collection<String> getTrackedUsers() {
        return this.getDistinct(DBField.CONSUMER_ID.toString());
    }

    public Collection<String> getTrackedResourceTypes() {
        return this.getDistinct(DBField.RESOURCE_TYPE.toString());
    }

    public Collection<String> getTrackedResourceOwners() {
        return this.getDistinct(DBField.RESOURCE_OWNER.toString());
    }

    public Collection<String> getTrackedGroups() {
        return this.getDistinct(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString());
    }

    private Collection<String> getDistinct(String key) {
        Vector<String> out = new Vector<String>();
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        List items = coll.distinct(key);
        for (Object o : items) {
            if (o == null) continue;
            out.add(o.toString());
        }
        return out;
    }

    public Long getLastUpdate(String dci) {
        Long max = 0L;
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.RESOURCE_OWNER.toString(), (Object)dci);
        DBCollection coll = this.db.getCollection(DBField.USAGE_RECORDS.toString());
        DBCursor cur = coll.find((DBObject)query);
        while (cur.hasNext()) {
            DBObject dbo = cur.next();
            Long l = (Long)dbo.get(DBField.END_TIME.toString());
            if (l == null || l <= max) continue;
            max = l;
        }
        return max;
    }

    public void addConsumerGroup(String consumerGroup) {
        Vector<String> l = new Vector<String>();
        StringTokenizer st = new StringTokenizer(consumerGroup, ".");
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.addConsumerGroup(l);
    }

    public void addConsumerGroup(List<String> consumerGroup) {
        logger.info((Object)("adding group: " + consumerGroup.toString()));
        DBCollection coll = this.db.getCollection(DBField.CONSUMERS_RECORDS.toString());
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.SUBSET_GROUP.toString(), consumerGroup);
        DBCursor cur = coll.find((DBObject)query);
        if (!cur.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put(DBField.SUBSET_GROUP.toString(), consumerGroup);
            coll.insert(new DBObject[]{doc});
        }
    }

    public Collection<ArrayList<String>> getConsumersGroup() {
        ArrayList<ArrayList<String>> consumersGroup = new ArrayList<ArrayList<String>>();
        DBCollection collCG = this.db.getCollection(DBField.CONSUMERS_RECORDS.toString());
        collCG.ensureIndex((DBObject)new BasicDBObject(DBField.SUBSET_GROUP.toString(), (Object)1).append("unique", (Object)true));
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = collCG.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            BasicDBList dblist = (BasicDBList)dbo.get(DBField.SUBSET_GROUP.toString());
            ArrayList<String> current = new ArrayList<String>();
            for (Object object : dblist) {
                current.add((String)object);
            }
            consumersGroup.add(current);
        }
        return consumersGroup;
    }

    private String encodeKey(String key) {
        key = key.replaceAll("\\\\", BACKSLASH);
        key = key.replaceAll("\\$", DOLLAR);
        key = key.replaceAll("\\.", DOT);
        return key;
    }

    private String decodeKey(String key) {
        key = key.replaceAll(DOT, ".");
        key = key.replaceAll(DOLLAR, "\\$");
        key = key.replaceAll(BACKSLASH, "\\\\");
        return key;
    }

    static {
        baseFields = new DBField[]{DBField.RESOURCE_TYPE, DBField.CONSUMER_ID, DBField.FULLY_QUALIFIED_CONSUMER_ID, DBField.START_TIME, DBField.END_TIME, DBField.CREATOR_ID, DBField.UR_ID, DBField.CREATE_TIME, DBField.MODIFY_TIME, DBField.RESOURCE_OWNER};
        logger = Logger.getLogger(UsageTrackerDB.class);
    }
}

