

package org.gcube.accounting.usagetracker.rest.resources;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.ResourceScope;
import org.gcube.accounting.datamodel.ResourceType;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.gcube.accounting.VersionHelper;
import org.gcube.accounting.VersionInfo;
import org.gcube.accounting.datamodel.Consumer;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryHelper;
import org.gcube.accounting.exception.QueryFormatException;
import org.gcube.accounting.exception.rest.NotAuthorizedException;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.ut.UpdateInfo;

@Path("/meta")
public class MetaResource {
		
	private static Logger logger = Logger.getLogger(MetaResource.class);

	protected @Context HttpServletRequest request;

//	@GET
//	@Path("/users")
//	@Produces(MediaType.APPLICATION_XML)
//	public Collection<User> getUsers(){
//		try {
//			UsageTrackerDB db = UsageTrackerDB.getStorage();
//			Collection<User> out = new Vector<User>();
//			for (String s : db.getTrackedUsers()) {
//				User u = new User();
//				u.setId(s);
//				out.add(u);
//			}
//			return out;
//		} catch (UnknownHostException e) {
//			logger.error(e.getMessage(), e);
//			throw new ServerErrorException(e.getMessage());
//		}
//	}
	
//	@GET
//	@Path("/version")
//	@Produces(MediaType.APPLICATION_XML)
//	public VersionInfo getVersion() {
//		return new VersionHelper(
//				"/org/gcube-accounting/mab/usagetracker/version.properties")
//				.getVersionInfo();
//	}
//
//	@GET
//	@Path("/dcis")
//	@Produces(MediaType.APPLICATION_XML)
//	public Collection<DCI> getDCI() {
//		try {
//			UsageTrackerDB db = UsageTrackerDB.getStorage();
//			Collection<DCI> out = new Vector<DCI>();
//			for (String s : db.getTrackedResourceOwners()) {
//				DCI dci = new DCI();
//				dci.setName(s);
//				out.add(dci);
//			}
//			return out;
//		} catch (UnknownHostException e) {
//			logger.error(e.getMessage(), e);
//			throw new ServerErrorException(e.getMessage());
//		}
//	}

	
	@GET
	@Path("/consumers")
	@Produces(MediaType.APPLICATION_XML)
	public Collection<Consumer> getConsumers() {

		Collection<Consumer> outc = new Vector<Consumer>();
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			List<String> set = new ArrayList<String>();
			Collection<ArrayList<String>> consumerGroup = db
					.getConsumersGroup();
			for (ArrayList<String> currentGroup : consumerGroup) {
				ArrayList<String> subSequence = getDottedSubstrings(currentGroup);
				for (String string : subSequence) {
					if (!set.contains(string)) {
						set.add(string);
					}
				}
			}
			Collections.sort(set);

			for (String element : set) {
				if(SecurityManager.isAllowed(this.getUserId(), Action.READ_RECORD, element))
					outc.add(new Consumer(element));
			}

			return outc;
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	
	@GET
	@Path("/resource_types")
	@Produces(MediaType.APPLICATION_XML)
	public Collection<ResourceType> getResourceTypes() {
		Collection<ResourceType> out = new Vector<ResourceType>();
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			for (String s : db.getTrackedResourceTypes()) {
				ResourceType rt = new ResourceType();
				rt.setName(s);
				out.add(rt);
			}
			return out;
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@GET
	@Path("/resource_scopes")
	@Produces(MediaType.APPLICATION_XML)
	public Collection<ResourceScope> getResourceScopes() {
		Collection<ResourceScope> out = new Vector<ResourceScope>();
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			for (String s : db.getTrackedResourceScopes()) {
				ResourceScope rt = new ResourceScope();
				rt.setName(s);
				out.add(rt);
			}
			return out;
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}

	@GET
	@Path("/update_info")
	@Produces(MediaType.APPLICATION_XML)
	public Collection<UpdateInfo> getLastUpdates() {
		Collection<UpdateInfo> out = new Vector<UpdateInfo>();
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			for (String dci : db.getTrackedResourceOwners()) {
				UpdateInfo info = new UpdateInfo();
				info.setDci(dci);
				info.setTimestamp(db.getLastUpdate(dci));
				out.add(info);
			}
			return out;
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	
	
	
	/**
	 * Given a list of string, return al sublists starting at the first element
	 * (i.e. index 0). Output sublists are represented using a dotted notation
	 * 
	 * @param current
	 * @return
	 */
	private static ArrayList<String> getDottedSubstrings(
			ArrayList<String> current) {
		ArrayList<String> result = new ArrayList<String>();
		int size = current.size();
		// Collections.reverse(current);
		for (int i = 0; i < size; i++) {
			result.add(getDottedRepresentation(current.subList(0, i + 1)));
		}
		return result;
	}

	/**
	 * Given a list of strings, return a dotted representation of the list
	 * 
	 * @param list
	 * @return
	 */
	private static String getDottedRepresentation(List<String> list) {
		int size = list.size();
		String result = "";
		for (int i = 0; i < size; i++) {
			result += list.get(i) + ".";
		}
		return result.substring(0, result.length() - 1);
	}

	private String getUserId() {
		return (String)request.getAttribute("userId");
	}

}
