

package org.gcube.accounting.usagetracker.membership;

import java.io.Serializable;
import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.Group;
import org.gcube.accounting.datamodel.User;
import org.gcube.accounting.datamodel.Membership;
import org.gcube.accounting.security.authn.HTTPBasicAuthentication;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;

/**
 * A client-side class for accessing the membership
 */

public class MembershipRestAPI implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3304321154372902643L;

	/**
	 * A logger for this class
	 */
	private static Logger logger = Logger.getLogger(MembershipRestAPI.class);

	private Client client;
	private WebResource service;

	/**
	 * 
	 * @param uri
	 *            the uri of the Membership
	 */
	public MembershipRestAPI(String uri) {
		ClientConfig config = new DefaultClientConfig();
		this.client = Client.create(config);
		this.service = client.resource(getBaseURI(uri));
	}

	private static URI getBaseURI(String uri) {
		return UriBuilder.fromUri(uri).build();
	}

	/**
	 * Return the membership matching the given query.
	 * 
	 * @param query
	 *            must have the form: userId
	 * @return
	 */

	// TODO: javadoc
	public Membership getMembership(String query) {
		Membership record = service.path("membership/" + query).get(
				Membership.class);
		return record;
	}

	// TODO: javadoc
	public User getUser(String query) {
		User record = service.path("users/" + query).get(User.class);
		return record;
	}

	// TODO: javadoc
	public Group getGroups(String query) {
		Group record = service.path("users/" + query + "/groups").get(
				Group.class);
		return record;
	}

	public void setUserToken(String username, String password) {
		client.addFilter(new HTTPBasicAuthentication(username,password));
	}

}
