/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.reports;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/reports/task")
public class TaskReports {
    private static Logger logger = Logger.getLogger(TaskReports.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="processors")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getCountProcessorsReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getTaskCountProcessorsReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="worker-time")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getWorkerTimeReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getTaskWorkerTimeReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="network-traffic")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getNetworkTrafficReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            if (report.getReportProperty().equals("rsp:overallNetworkIn")) {
                return db.getTaskNetworkTrafficInputReport(report);
            }
            if (report.getReportProperty().equals("rsp:overallNetworkOut")) {
                return db.getTaskNetworkTrafficOutputReport(report);
            }
            return new ArrayList<AggregatedResult>();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

