

package org.gcube.accounting.usagetracker.configuration;

import java.util.List;

import javax.naming.NamingException;

import org.gcube.accounting.webservice.configuration.ConfigurationResource;
import org.gcube.accounting.webservice.configuration.PropertiesBaseConfiguration;

/**
 * This class models Usage Tracker configuration. It relies on the configuration
 * location defined in the context file.
 */
public class Configuration extends PropertiesBaseConfiguration {

	/**
	 * The expected name for the configuration file
	 */
	private static String configurationFile = "gcube-accounting-usagetracker.properties";

	/**
	 * Singleton instance
	 */
	private static Configuration instance;

	/**
	 * Getter for the singleton instance
	 * @return
	 */
	public static Configuration getInstance() {
		if(instance==null) {
			try {
				instance=new Configuration();
			}
			catch(NamingException e) {
				e.printStackTrace();
			}
		}
		return instance;
	}
	
	/**
	 * Private constructor
	 */
	private Configuration() throws NamingException {
		super(ConfigurationResource.getConfigurationLocation()+"/"+configurationFile);
	}

	/**
	 * Getter for the database host
	 * @return
	 */
	public String getDBHost() {
		return super.getString("dbHost");
	}

	/**
	 * Getter for the database port
	 * @return
	 */
	public int getDBPort() {
		return super.getInt("dbPort", 27017);
	}
	
	/**
	 * Is DB authentication enabled?
	 * @return
	 */
	public Boolean isDBAuthnEnabled() {
		return super.getBoolean("dbAuthn", false);
	}
	

	/**
	 * Getter for the database name
	 * @return
	 */
	public String getDBName() {
		return super.getString("dbName");
	}

	/**
	 * Getter for the database user
	 * @return
	 */
	public String getDBUser() {
		return super.getString("dbUser");
	}

	/**
	 * Getter for the database password
	 * @return
	 */
	public String getDBPassword() {
		return super.getString("dbPassword");
	}

	/**
	 * Should the membership service be contacted?
	 * @return
	 */
	public Boolean isMembershipServiceEnabled() {
		return super.getBoolean("membershipService.enabled", false);
	}

	/**
	 * Getter for the membership service endpoint
	 * @return
	 */
	public String getMembershipServiceURL() {
		return super.getString("membershipService.url");
	}
	

	/**
	 * Should the membership service be contacted?
	 * @return
	 */
	public Boolean isMembershipServiceAuthnEnabled() {
		return super.getBoolean("membershipService.authn.enabled", false);
	}
	
	/**
	 * Getter for username to use when connecting to the membership service
	 * @return
	 */
	public String getMembershipUsername() {
		return super.getString("membershipService.username");
	}
	
	/**
	 * Getter for password to use when connecting to the membership service
	 * @return
	 */
	public String getMembershipPassword() {
		return super.getString("membershipService.password");
	}
	
	public String getDefaultGroup() {
		String out = super.getString("defaultUserGroup");
		if(out==null || out.trim().isEmpty())
			return "nogroup";
		return out;
	}
	
	/**
	 * Getter for the scopes
	 * @return
	 */
	public List<Object> getScopes() {
		return super.getList("infrastructure.scopes");
	}
	
	/**
	 * Getter for the broker endpoint
	 * @return
	 */
	public String getBroker() {
		return super.getString("infrastructure.broker");
	}
	
	/**
	 * Should the remote DB cluster be used?
	 * @return
	 */
	public Boolean isRemoteDBEnabled() {
		return super.getBoolean("infrastructure.remoteDB", false);
	}
	
	
	

}
