/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.commons.io.FileUtils;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.AreaFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.LocalObjectFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientObjectType;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientObject;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.ConnectionProvider;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBInterface;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBSession;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBUtil;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.SpeciesCSVProcessor;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.Tables;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ExportOperation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceStatus;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements DBInterface {
    private static final Logger log = LoggerFactory.getLogger(DBManager.class);
    protected DBSession session;
    protected String associatedScope;
    private long lastUpdateTime;

    public static Set<String> getInitializedScopes() {
        return ConnectionProvider.initializedScopes();
    }

    public static void deleteDb(String currentScope) throws Exception {
        log.debug("Delete dbinterface for scope " + currentScope);
        String scope = Utils.removeVRE((String)currentScope);
        ConnectionProvider.dropDataBase((String)scope);
    }

    public static DBInterface getInstance(String currentScopeString) throws Exception {
        log.debug("getDBInterface for scope : " + currentScopeString);
        String scope = Utils.removeVRE((String)currentScopeString);
        return new DBManager(scope);
    }

    protected DBManager(String scope) throws Exception {
        this.associatedScope = scope;
        this.session = new DBSession(scope);
        log.debug("Checking DB connection ...");
        this.session.executeQuery("SELECT * from " + Tables.Species);
        this.retrieveSpeciesFields();
    }

    public boolean isUpToDate() {
        return System.currentTimeMillis() - this.lastUpdateTime < 300000L;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getAssociatedScope() {
        return this.associatedScope;
    }

    public int fetchSpecies() throws Exception {
        File csvFile = null;
        try {
            ScopeProvider.instance.set(this.associatedScope.toString());
            csvFile = ((DataManagement)AbstractPlugin.dataManagement().withTimeout(2, TimeUnit.MINUTES).build()).exportTableAsCSV("speciesoccursum", null, null, null, ExportOperation.TRANSFER);
            int toReturn = this.importSpeciesOccursumCSV(csvFile);
            this.setLastUpdateTime(System.currentTimeMillis());
            log.debug("Inserted " + toReturn + " species into " + this.associatedScope + " DATABASE");
            int n = toReturn;
            return n;
        }
        catch (Throwable t) {
            log.error("Unable to fetch species", t);
            throw new Exception("Unable to fetch species", t);
        }
        finally {
            try {
                if (csvFile != null && csvFile.exists()) {
                    FileUtils.forceDelete((File)csvFile);
                }
            }
            catch (Exception e1) {
                log.error("Unable to delete csv File " + csvFile.getAbsolutePath(), (Throwable)e1);
            }
        }
    }

    public String getPhylogenyJSON(String level) throws Exception {
        log.debug("get Phylogeny for lvel : " + level);
        ResultSet rs = null;
        try {
            String table = level;
            if (level.equalsIgnoreCase(SpeciesFields.ordercolumn + "")) {
                table = Tables.order_table + "";
            }
            if (level.equalsIgnoreCase(SpeciesFields.classcolumn + "")) {
                table = Tables.class_table + "";
            }
            if (level.equalsIgnoreCase(SpeciesFields.familycolumn + "")) {
                table = Tables.family_table + "";
            }
            rs = this.session.executeQuery("SELECT * FROM " + table);
            String string = DBUtil.toJSon((ResultSet)rs);
            return string;
        }
        catch (Exception e) {
            log.error("Exception while retrieving philogeny level " + level, (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String getJSONAreasByType(boolean includeFAO, boolean includeEEZ, boolean includeLME, PagedRequestSettings settings) throws Exception {
        if (includeFAO || includeEEZ || includeLME) {
            String statement = DBUtil.getAreaQuery((String)(Tables.Area + ""), (boolean)includeFAO, (boolean)includeEEZ, (boolean)includeLME) + " order by " + settings.orderField() + " " + settings.orderDirection();
            ResultSet rs = null;
            try {
                log.debug("to submit query : " + statement);
                rs = this.session.executeQuery(statement);
                String string = DBUtil.toJSon((ResultSet)rs, (int)settings.offset(), (int)(settings.offset() + settings.limit()));
                return string;
            }
            catch (Exception e) {
                log.error("Exception while retrieving areas", (Throwable)e);
                throw new Exception();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return "{\"data\":[],\"totalcount\":0}";
    }

    public List<Area> getAreasByType(boolean includeFAO, boolean includeEEZ, boolean includeLME) throws Exception {
        ResultSet rs = null;
        try {
            rs = this.session.executeQuery(DBUtil.getAreaQuery((String)(Tables.Area + ""), (boolean)includeFAO, (boolean)includeEEZ, (boolean)includeLME));
            List list = DBUtil.loadAreas((ResultSet)rs);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String getUserJSONBasket(String userName, int start, int limit, String sortColumn, String sortDirection) throws Exception {
        log.debug("Getting selected species for user : " + userName);
        ResultSet rsPage = null;
        try {
            String pagedQuery = "Select " + Tables.Species + ".*," + Tables.Basket + "." + SpeciesFields.customized + " from " + Tables.Species + "," + Tables.Basket + " where " + Tables.Basket + "." + SpeciesFields.speciesid + " = " + Tables.Species + "." + SpeciesFields.speciesid + " AND " + Tables.Basket + "." + "userid" + " = '" + userName + "' ORDER BY " + Tables.Species + "." + sortColumn + " " + sortDirection;
            rsPage = this.session.executeQuery(pagedQuery);
            String string = DBUtil.toJSon((ResultSet)rsPage, (int)start, (int)(limit + start));
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rsPage != null) {
                rsPage.close();
            }
        }
    }

    public int removeFromBasket(List<String> speciesIds, String userName) throws Exception {
        try {
            int count = 0;
            if (speciesIds == null) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(new Field("userid", userName, FieldType.STRING));
                count += this.session.deleteOperation(Tables.Basket + "", row);
                this.session.deleteOperation(Tables.Objects_Basket + "", row);
            } else {
                for (String id : speciesIds) {
                    ArrayList<Field> row = new ArrayList<Field>();
                    row.add(new Field(SpeciesOccursumFields.speciesid + "", id, FieldType.STRING));
                    row.add(new Field("userid", userName, FieldType.STRING));
                    count += this.session.deleteOperation(Tables.Basket + "", row);
                    this.session.deleteOperation(Tables.Objects_Basket + "", row);
                }
            }
            this.updateObjectsBasketsReferences(userName);
            this.session.commit();
            return count;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    private void updateObjectsBasketsReferences(String userName) throws Exception {
        ResultSet rsObj = null;
        try {
            ArrayList<Field> userCondition = new ArrayList<Field>();
            userCondition.add(new Field("userid", userName, FieldType.STRING));
            rsObj = this.session.executeFilteredQuery(userCondition, Tables.Objects + "", "userid", "ASC");
            ArrayList toUpdateRows = new ArrayList();
            ArrayList toUpdateValues = new ArrayList();
            while (rsObj.next()) {
                ArrayList<Field> userAndTitleCondition = new ArrayList<Field>();
                userAndTitleCondition.add(new Field("userid", userName, FieldType.STRING));
                userAndTitleCondition.add(new Field(SubmittedFields.title + "", rsObj.getString(SubmittedFields.title + ""), FieldType.STRING));
                int count = this.session.getCount(Tables.Objects_Basket + "", userAndTitleCondition);
                String type = rsObj.getString(LocalObjectFields.type + "");
                if (type.equalsIgnoreCase(ClientObjectType.SpeciesDistribution.toString())) {
                    if (count != 0) continue;
                    this.session.deleteOperation(Tables.Objects + "", userAndTitleCondition);
                    continue;
                }
                toUpdateRows.add(userAndTitleCondition);
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(new Field(LocalObjectFields.species + "", count + "", FieldType.STRING));
                toUpdateValues.add(row);
            }
            if (toUpdateRows.size() > 0) {
                this.session.updateOperation(Tables.Objects + "", toUpdateRows, toUpdateValues);
            }
            this.session.commit();
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
        finally {
            if (rsObj != null) {
                rsObj.close();
            }
        }
    }

    public int addToUserBasket(List<String> speciesIds, String userName) throws Exception {
        Statement ps = null;
        try {
            Field userField = new Field("userid", userName, FieldType.STRING);
            Field customizedField = new Field(SpeciesFields.customized + "", "0", FieldType.INTEGER);
            Field perturbationField = new Field("perturbations", "{\"data\":[],\"totalcount\":0}", FieldType.STRING);
            int count = 0;
            for (String id : speciesIds) {
                ArrayList<Field> values = new ArrayList<Field>();
                values.add(userField);
                values.add(new Field(SpeciesOccursumFields.speciesid + "", id, FieldType.STRING));
                values.add(customizedField);
                values.add(perturbationField);
                if (ps == null) {
                    ps = this.session.getPreparedStatementForInsert(values, Tables.Basket + "");
                }
                try {
                    count += this.session.fillParameters(values, 0, (PreparedStatement)ps).executeUpdate();
                }
                catch (Exception e) {}
            }
            this.session.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public int addToObjectBasket(List<String> speciesIds, String userName, String title) throws Exception {
        return this.addToObjectBasket(speciesIds, userName, title, true);
    }

    private int addToObjectBasket(List<String> speciesIds, String userName, String title, boolean updateBasketsReferences) throws Exception {
        Statement psInsert = null;
        try {
            List rows = this.loadSelection(speciesIds, userName, title);
            psInsert = this.session.getPreparedStatementForInsert((List)rows.get(0), Tables.Objects_Basket + "");
            int count = 0;
            for (List row : rows) {
                try {
                    count += this.session.fillParameters(row, 0, (PreparedStatement)psInsert).executeUpdate();
                }
                catch (Exception e) {}
            }
            if (updateBasketsReferences) {
                this.updateObjectsBasketsReferences(userName);
            }
            this.session.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
        finally {
            if (psInsert != null) {
                psInsert.close();
            }
        }
    }

    private List<List<Field>> loadSelection(List<String> speciesIds, String userName, String title) throws Exception {
        ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
        Field userField = new Field("userid", userName, FieldType.STRING);
        Field titleField = new Field(SubmittedFields.title + "", title, FieldType.STRING);
        if (speciesIds == null || speciesIds.size() == 0) {
            ArrayList<Field> userCondition = new ArrayList<Field>();
            userCondition.add(userField);
            ResultSet rsSpecs = this.session.executeFilteredQuery(userCondition, Tables.Basket + "", SpeciesFields.speciesid + "", "ASC");
            while (rsSpecs.next()) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(titleField);
                row.add(userField);
                row.add(new Field(SpeciesFields.speciesid + "", rsSpecs.getString(SpeciesFields.speciesid + ""), FieldType.STRING));
                rows.add(row);
            }
            rsSpecs.close();
        } else {
            for (String id : speciesIds) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(titleField);
                row.add(userField);
                row.add(new Field(SpeciesFields.speciesid + "", id, FieldType.STRING));
                rows.add(row);
            }
        }
        return rows;
    }

    public int removeFromObjectBasket(List<String> speciesIds, String userName, String title) throws Exception {
        try {
            int count = 0;
            for (List row : this.loadSelection(speciesIds, userName, title)) {
                count += this.session.deleteOperation(Tables.Objects_Basket + "", row);
            }
            this.updateObjectsBasketsReferences(userName);
            this.session.commit();
            return count;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    private void addObject(String userName, String title, ClientObjectType type, String bbox, double threshold, String species, boolean gis) throws Exception {
        try {
            log.debug("Creating object " + title + " for user " + userName);
            ArrayList rows = new ArrayList();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field("userid", userName, FieldType.STRING));
            row.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
            row.add(new Field(LocalObjectFields.type + "", type + "", FieldType.STRING));
            row.add(new Field(LocalObjectFields.bbox + "", bbox, FieldType.STRING));
            row.add(new Field(LocalObjectFields.threshold + "", threshold + "", FieldType.DOUBLE));
            row.add(new Field(LocalObjectFields.species + "", species + "", FieldType.STRING));
            row.add(new Field(LocalObjectFields.gis + "", gis + "", FieldType.BOOLEAN));
            rows.add(row);
            this.session.insertOperation(Tables.Objects + "", rows);
            this.session.commit();
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public String getObjectJSONBasket(String userName, String title, int start, int limit, String sortColumn, String sortDirection) throws Exception {
        ResultSet rsPage = null;
        try {
            String pagedQuery = "Select " + Tables.Species + ".*," + Tables.Objects_Basket + "." + SpeciesFields.customized + " from " + Tables.Species + "," + Tables.Objects_Basket + " where " + Tables.Objects_Basket + "." + SpeciesFields.speciesid + " = " + Tables.Species + "." + SpeciesFields.speciesid + " AND " + Tables.Objects_Basket + "." + "userid" + " = '" + userName + "' AND " + Tables.Objects_Basket + "." + LocalObjectFields.title + " = '" + title + "' ORDER BY " + Tables.Species + "." + sortColumn + " " + sortDirection;
            rsPage = this.session.executeQuery(pagedQuery);
            String string = DBUtil.toJSon((ResultSet)rsPage, (int)start, (int)(limit + start));
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rsPage != null) {
                rsPage.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getObjectBasketIds(String userName, String title) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("userid", userName, FieldType.STRING));
        filter.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
        ArrayList<String> toReturn = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = this.session.executeFilteredQuery(filter, Tables.Objects_Basket + "", SpeciesFields.speciesid + "", "ASC");
            while (rs.next()) {
                toReturn.add(rs.getString(SpeciesFields.speciesid + ""));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserBasketIds(String userName) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("userid", userName, FieldType.STRING));
        ArrayList<String> toReturn = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = this.session.executeFilteredQuery(filter, Tables.Basket + "", SpeciesFields.speciesid + "", "ASC");
            while (rs.next()) {
                toReturn.add(rs.getString(SpeciesFields.speciesid + ""));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return toReturn;
    }

    public int removeObjectByTitle(String userName, String title) throws Exception {
        try {
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field("userid", userName, FieldType.STRING));
            row.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
            this.session.deleteOperation(Tables.Objects_Basket + "", row);
            int toReturn = this.session.deleteOperation(Tables.Objects + "", row);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int removeSession(String userName) throws Exception {
        try {
            log.debug("Removing user " + userName);
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field("userid", userName, FieldType.STRING));
            int count = this.session.deleteOperation(Tables.Objects_Basket + "", row);
            count += this.session.deleteOperation(Tables.Objects + "", row);
            this.session.commit();
            return count += this.session.deleteOperation(Tables.Basket + "", row);
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int updateObject(String userName, String oldTitle, String title, ClientObjectType type, String bbox, float threshold, boolean gis) throws Exception {
        try {
            ArrayList rows = new ArrayList();
            ArrayList<Field> value = new ArrayList<Field>();
            value.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
            value.add(new Field(LocalObjectFields.type + "", type + "", FieldType.STRING));
            value.add(new Field(LocalObjectFields.bbox + "", bbox, FieldType.STRING));
            value.add(new Field(LocalObjectFields.threshold + "", threshold + "", FieldType.DOUBLE));
            value.add(new Field(LocalObjectFields.gis + "", (gis ? 1 : 0) + "", FieldType.INTEGER));
            rows.add(value);
            ArrayList keys = new ArrayList();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(LocalObjectFields.title + "", oldTitle, FieldType.STRING));
            keys.add(key);
            int toReturn = this.session.updateOperation(Tables.Objects + "", keys, rows);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public List<ClientObject> getObjects(String userName) throws Exception {
        ResultSet rs = null;
        try {
            log.debug("Retrieving objects for user : " + userName);
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field("userid", userName, FieldType.STRING));
            rs = this.session.executeFilteredQuery(filter, Tables.Objects + "", "userid", "ASC");
            List list = DBUtil.loadObjects((ResultSet)rs);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void retrieveSpeciesFields() throws SQLException {
    }

    public int clearBasket(String userName) throws Exception {
        try {
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            this.session.deleteOperation(Tables.Objects_Basket + "", key);
            this.session.deleteOperation(Tables.Objects + "", key);
            int toReturn = this.session.deleteOperation(Tables.Basket + "", key);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int clearObjectBasket(String userName, String title) throws Exception {
        try {
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
            int toReturn = this.session.deleteOperation(Tables.Objects_Basket + "", key);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public String getSpecies() throws Exception {
        ResultSet rs = null;
        try {
            rs = this.session.executeQuery("SELECT * FROM " + Tables.Species);
            String string = DBUtil.toJSon((ResultSet)rs);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public int fetchGeneratedObjRelatedSpecies(int objId, List<String> speciesIds) throws Exception {
        try {
            this.deleteFetched(objId + "");
            log.debug("Fetching " + speciesIds.size() + " species for " + objId + " object basket");
            ArrayList rows = new ArrayList();
            for (String id : speciesIds) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(new Field("objectid", objId + "", FieldType.INTEGER));
                row.add(new Field(SpeciesFields.speciesid + "", id, FieldType.STRING));
                rows.add(row);
            }
            int toReturn = this.session.insertOperation(Tables.fetchedBasket + "", rows).size();
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public String getFetchedJSONBasket(int objId, int start, int limit, String sortColumn, String sortDirection) throws Exception {
        ResultSet rs = null;
        Statement ps = null;
        try {
            log.debug("Getting fetched species for objBasket : " + objId);
            ps = this.session.preparedStatement("Select " + Tables.Species + ".* from " + Tables.Species + "," + Tables.fetchedBasket + " where " + Tables.fetchedBasket + "." + SpeciesFields.speciesid + " = " + Tables.Species + "." + SpeciesFields.speciesid + " AND " + Tables.fetchedBasket + "." + "objectid" + " = ? ORDER BY " + Tables.Species + "." + sortColumn + " " + sortDirection);
            ps.setInt(1, objId);
            rs = ps.executeQuery();
            String string = DBUtil.toJSon((ResultSet)rs, (int)start, (int)(start + limit));
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public int deleteFetched(String objId) throws Exception {
        try {
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field("objectid", objId + "", FieldType.INTEGER));
            int toReturn = this.session.deleteOperation(Tables.fetchedBasket + "", row);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public long getBasketCount(String userName) throws Exception {
        ArrayList<Field> key = new ArrayList<Field>();
        key.add(new Field("userid", userName, FieldType.STRING));
        return this.session.getCount(Tables.Basket + "", key);
    }

    public long getObjectBasketCount(String userName, String title) throws Exception {
        ArrayList<Field> key = new ArrayList<Field>();
        key.add(new Field("userid", userName, FieldType.STRING));
        key.add(new Field(LocalObjectFields.title + "", title, FieldType.STRING));
        return this.session.getCount(Tables.Objects_Basket + "", key);
    }

    public long getObjectCount(String userName) throws Exception {
        ArrayList<Field> key = new ArrayList<Field>();
        key.add(new Field("userid", userName, FieldType.STRING));
        return this.session.getCount(Tables.Objects + "", key);
    }

    public long getObjectCountByType(String userName, ClientObjectType type) throws Exception {
        ArrayList<Field> key = new ArrayList<Field>();
        key.add(new Field("userid", userName, FieldType.STRING));
        key.add(new Field(LocalObjectFields.type + "", type + "", FieldType.STRING));
        return this.session.getCount(Tables.Objects + "", key);
    }

    public String getJSONObjectsByType(String userName, ClientObjectType type, int start, int limit, String sortColumn, String sortDirection) throws Exception {
        ResultSet rs = null;
        try {
            log.debug("Getting objects by Type (" + type + ") per user " + userName);
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(LocalObjectFields.type + "", type + "", FieldType.STRING));
            rs = this.session.executeFilteredQuery(key, Tables.Objects + "", sortColumn, sortDirection);
            String string = DBUtil.toJSon((ResultSet)rs, (int)start, (int)(start + limit));
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String getPerturbation(String speciesId, String userName) throws Exception {
        ResultSet rs = null;
        try {
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(SpeciesFields.speciesid + "", speciesId, FieldType.STRING));
            rs = this.session.executeFilteredQuery(key, Tables.Basket + "", "userid", "ASC");
            if (rs.next()) {
                for (Field f : Field.loadRow((ResultSet)rs)) {
                    if (!f.name().equalsIgnoreCase("perturbations")) continue;
                    String string = f.value();
                    return string;
                }
                String string = null;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public void setPerturbation(String speciesIds, String userName, String jsonString) throws Exception {
        try {
            ArrayList keys = new ArrayList();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(SpeciesFields.speciesid + "", speciesIds, FieldType.STRING));
            keys.add(key);
            ArrayList values = new ArrayList();
            ArrayList<Field> value = new ArrayList<Field>();
            value.add(new Field("perturbations", jsonString, FieldType.STRING));
            value.add(new Field(SpeciesFields.customized + "", "1", FieldType.INTEGER));
            values.add(value);
            this.session.updateOperation(Tables.Basket + "", keys, values);
            this.session.commit();
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int removeObjectByType(String userName, ClientObjectType type) throws Exception {
        try {
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(LocalObjectFields.type + "", type + "", FieldType.STRING));
            int toReturn = this.session.deleteOperation(Tables.Objects + "", key);
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int changeGis(String userName, List<String> titles) throws Exception {
        try {
            ArrayList<Field> gisFields = new ArrayList<Field>();
            gisFields.add(new Field(LocalObjectFields.gis + "", "", FieldType.INTEGER));
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(LocalObjectFields.title + "", userName, FieldType.STRING));
            PreparedStatement psUpdate = this.session.getPreparedStatementForUpdate(gisFields, key, Tables.Objects + "");
            PreparedStatement psGet = this.session.getPreparedStatementForQuery(key, Tables.Objects + "", "userid", "ASC");
            psUpdate.setString(2, userName);
            psGet.setString(1, userName);
            int count = 0;
            for (String t : titles) {
                psUpdate.setString(3, t);
                psGet.setString(2, t);
                ResultSet rs = psGet.executeQuery();
                rs.next();
                int gis = rs.getInt(LocalObjectFields.gis + "");
                psUpdate.setInt(1, gis == 0 ? 1 : 0);
                count += psUpdate.executeUpdate();
            }
            this.session.commit();
            return count;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int addToAreaSelection(String user, List<Area> selection) throws Exception {
        try {
            PreparedStatement ps = null;
            int toReturn = 0;
            for (Area a : selection) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(new Field("userid", user, FieldType.STRING));
                row.add(new Field(AreaFields.code + "", a.getCode(), FieldType.STRING));
                row.add(new Field(AreaFields.type + "", a.getType() + "", FieldType.STRING));
                row.add(new Field(AreaFields.name + "", a.getName(), FieldType.STRING));
                if (ps == null) {
                    ps = this.session.getPreparedStatementForInsert(row, Tables.AreaSelections + "");
                }
                try {
                    toReturn += this.session.fillParameters(row, 0, ps).executeUpdate();
                }
                catch (Exception e) {}
            }
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public String getJSONAreaSelection(String user, PagedRequestSettings settings) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("userid", user, FieldType.STRING));
        return DBUtil.toJSon((ResultSet)this.session.executeFilteredQuery(filter, Tables.AreaSelections + "", settings.orderField(), settings.orderDirection() + ""), (int)settings.offset(), (int)(settings.limit() + settings.offset()));
    }

    public List<Area> getAreaSelection(String user) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("userid", user, FieldType.STRING));
        ResultSet rs = this.session.executeFilteredQuery(filter, Tables.AreaSelections + "", "userid", "ASC");
        return DBUtil.loadAreas((ResultSet)rs);
    }

    public int removeFromAreaSelection(String user, List<Area> toRemove) throws Exception {
        try {
            if (toRemove == null || toRemove.size() == 0) {
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field("userid", user, FieldType.STRING));
                int toReturn = this.session.deleteOperation(Tables.AreaSelections + "", filter);
                this.session.commit();
                return toReturn;
            }
            PreparedStatement ps = null;
            int toReturn = 0;
            for (Area a : toRemove) {
                ArrayList<Field> row = new ArrayList<Field>();
                row.add(new Field("userid", user, FieldType.STRING));
                row.add(new Field(AreaFields.code + "", a.getCode(), FieldType.STRING));
                row.add(new Field(AreaFields.type + "", a.getType() + "", FieldType.STRING));
                row.add(new Field(AreaFields.name + "", a.getName(), FieldType.STRING));
                if (ps == null) {
                    ps = this.session.getPreparedStatementForDelete(row, Tables.AreaSelections + "");
                }
                toReturn += this.session.fillParameters(row, 0, ps).executeUpdate();
            }
            this.session.commit();
            return toReturn;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    public int createObjectsBySelection(List<String> ids, String title, ClientObjectType type, float threshold, String bbox, String username) throws Exception {
        Statement loadSpecies = null;
        ResultSet rsSpec = null;
        try {
            switch (1.$SwitchMap$org$gcube$application$aquamaps$aquamapsportlet$client$constants$types$ClientObjectType[type.ordinal()]) {
                case 1: {
                    int toReturn;
                    this.addObject(username, title, type, bbox, (double)threshold, "", true);
                    int n = toReturn = this.addToObjectBasket(ids, username, title);
                    return n;
                }
            }
            if (ids == null) {
                ids = this.getUserBasketIds(username);
            }
            ArrayList<Field> speciesRow = null;
            int count = 0;
            for (String specId : ids) {
                speciesRow = new ArrayList<Field>();
                speciesRow.add(new Field(SpeciesFields.speciesid + "", specId, FieldType.STRING));
                if (loadSpecies == null) {
                    loadSpecies = this.session.getPreparedStatementForQuery(speciesRow, Tables.Species + "", SpeciesFields.speciesid + "", "ASC");
                }
                if ((rsSpec = this.session.fillParameters(speciesRow, 0, (PreparedStatement)loadSpecies).executeQuery()).next()) {
                    String currentTitle = rsSpec.getString(SpeciesFields.scientific_name + "");
                    if (currentTitle == null || currentTitle.equalsIgnoreCase("")) {
                        currentTitle = rsSpec.getString(SpeciesFields.genus + "") + "_" + rsSpec.getString(SpeciesFields.species + "");
                    }
                    try {
                        this.addObject(username, currentTitle, type, bbox, (double)threshold, specId, true);
                        ArrayList<String> id = new ArrayList<String>();
                        id.add(specId);
                        this.addToObjectBasket(id, username, currentTitle, false);
                        ++count;
                    }
                    catch (Exception ex) {}
                    continue;
                }
                log.warn("Cannot find informations for species " + specId + ", skipped");
            }
            this.session.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
        finally {
            if (rsSpec != null) {
                rsSpec.close();
            }
            if (loadSpecies != null) {
                loadSpecies.close();
            }
        }
    }

    public void clearPerturbation(String speciesId, String userName) throws Exception {
        try {
            ArrayList keys = new ArrayList();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("userid", userName, FieldType.STRING));
            key.add(new Field(SpeciesFields.speciesid + "", speciesId, FieldType.STRING));
            keys.add(key);
            ArrayList values = new ArrayList();
            ArrayList<Field> value = new ArrayList<Field>();
            value.add(new Field("perturbations", "{\"data\":[],\"totalcount\":0}", FieldType.STRING));
            value.add(new Field(SpeciesFields.customized + "", "0", FieldType.INTEGER));
            values.add(value);
            this.session.updateOperation(Tables.Basket + "", keys, values);
            this.session.commit();
        }
        catch (Exception e) {
            this.session.connection.rollback();
            throw e;
        }
    }

    private int importSpeciesOccursumCSV(File csvFile) throws Exception {
        SpeciesCSVProcessor lineProcessor = null;
        try {
            CSVReaderProcessor processor = new CSVReaderProcessor();
            processor.setDelimiter(',');
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(csvFile), Charset.defaultCharset());
            lineProcessor = new SpeciesCSVProcessor(this.session);
            log.debug("Starting csv file processing, path is " + csvFile.getAbsolutePath());
            processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
            log.debug("CSV PROCESSED : " + lineProcessor.status);
            if (lineProcessor.status.equals((Object)ResourceStatus.Completed)) {
                log.debug("Complete processing");
                this.session.commit();
                int n = this.session.getCount(Tables.Species + "", new ArrayList());
                return n;
            }
            try {
                throw new Exception("Processor Was Unable to completely import csv");
            }
            catch (Exception e) {
                this.session.getConnection().rollback();
                throw e;
            }
        }
        finally {
            if (lineProcessor != null) {
                lineProcessor.close();
            }
        }
    }
}

