/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client.details;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.NameValuePair;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.ToolTip;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.grid.PropertyGridPanel;
import com.gwtext.client.widgets.grid.event.PropertyGridPanelListener;
import com.gwtext.client.widgets.layout.AnchorLayout;
import com.gwtext.client.widgets.layout.AnchorLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import com.gwtext.client.widgets.layout.TableLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientObjectType;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientObject;

public class AquaMapsDetailsPanel
extends Panel {
    private ClientObject current = null;
    public PropertyGridPanel properties = new PropertyGridPanel();
    Panel imagesContainer = new Panel();
    Map<String, Image> imageMap = new HashMap();
    ToolbarButton showPerturbation = new ToolbarButton("Show Customizations");
    AquaMapsDetailsPanel instance = this;
    ToolbarButton GIS = new ToolbarButton("GIS Viewer");
    ToolbarButton publish = new ToolbarButton("Publish Map");

    public AquaMapsDetailsPanel() {
        try {
            this.setId("AmDetailsPanelID");
            this.setLayout((ContainerLayout)new AnchorLayout(300, 800));
            Toolbar toolBar = new Toolbar();
            toolBar.addButton(this.showPerturbation);
            this.properties.setTitle("Map Details");
            this.properties.setCollapsible(true);
            this.properties.setAutoHeight(true);
            this.properties.setFrame(true);
            this.properties.setHeight(300);
            this.properties.setSource(new NameValuePair[0]);
            this.properties.addPropertyGridPanelListener((PropertyGridPanelListener)new /* Unavailable Anonymous Inner Class!! */);
            this.add((Component)this.properties, (LayoutData)new AnchorLayoutData("100% 45%"));
            this.imageMap.put("Earth", new Image());
            this.imageMap.put("Continent View : Africa", new Image());
            this.imageMap.put("Continent View : Asia", new Image());
            this.imageMap.put("Continent View : Australia", new Image());
            this.imageMap.put("Continent View : Europa", new Image());
            this.imageMap.put("Continent View : North America", new Image());
            this.imageMap.put("Continent View : South America", new Image());
            this.imageMap.put("Ocean View : Atlantic", new Image());
            this.imageMap.put("Ocean View : Indian", new Image());
            this.imageMap.put("Pole View : Artic", new Image());
            this.imageMap.put("Ocean View : North Atlantic", new Image());
            this.imageMap.put("Ocean View : Pacific", new Image());
            this.imageMap.put("Pole View : Antarctic", new Image());
            this.imageMap.put("Ocean View : South Atlantic", new Image());
            this.imagesContainer.setTitle("Generated Images");
            this.imagesContainer.setLayout((ContainerLayout)new TableLayout(4));
            this.imagesContainer.setFrame(true);
            this.imagesContainer.setSize(300, 300);
            for (String name : this.imageMap.keySet()) {
                Image img = (Image)this.imageMap.get(name);
                img.setPixelSize(93, 93);
                Panel panel = new Panel();
                panel.setLayout((ContainerLayout)new FitLayout());
                panel.add((Widget)img);
                panel.setPaddings(5);
                img.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                ToolTip tt = new ToolTip();
                tt.setHtml(name);
                tt.applyTo((Component)panel);
                this.imagesContainer.add((Component)panel);
            }
            this.imagesContainer.setAutoScroll(true);
            this.GIS.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            ToolbarButton details = new ToolbarButton("Additional Details");
            details.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.publish.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.imagesContainer.setBottomToolbar(new Button[]{details, this.GIS, this.publish});
            this.imagesContainer.setId("IMAGESContainer");
            this.add((Component)this.imagesContainer, (LayoutData)new AnchorLayoutData("100% 55%"));
        }
        catch (Throwable t) {
            Log.debug((String)"Unable to create detail panel", (Throwable)t);
        }
    }

    public void loadObject(ClientObject obj) {
        try {
            this.current = obj;
            Log.debug((String)"Loading AquaMapsObject...");
            Log.debug((String)("Title " + obj.getName()));
            Log.debug((String)("Type " + obj.getType()));
            Log.debug((String)("Author " + obj.getAuthor()));
            Log.debug((String)("Id " + obj.getId()));
            Log.debug((String)("spec count " + obj.getSelectedSpecies()));
            Log.debug((String)("BB " + obj.getBoundingBox()));
            Log.debug((String)("threshold " + obj.getThreshold()));
            Log.debug((String)("number of imgs " + obj.getImages().size()));
            Log.debug((String)("gis " + obj.getGis()));
            ArrayList<NameValuePair> source = new ArrayList<NameValuePair>();
            source.add(new NameValuePair("Name of Map", obj.getName()));
            source.add(new NameValuePair("Type of Map", obj.getType().toString()));
            source.add(new NameValuePair("Algorithm", obj.getAlgorithmType()));
            source.add(new NameValuePair("Author", obj.getAuthor()));
            source.add(new NameValuePair("Id", obj.getId()));
            source.add(new NameValuePair(obj.getType().equals((Object)ClientObjectType.Biodiversity) ? "Number of species" : "Selected Species", obj.getSelectedSpecies().getValue()));
            source.add(new NameValuePair("Bounding Box (N,S,E,W)", obj.getBoundingBox().toString()));
            if (obj.getType().equals((Object)ClientObjectType.Biodiversity)) {
                source.add(new NameValuePair("PSO threshold", String.valueOf(obj.getThreshold())));
            }
            source.add(new NameValuePair("Number of generated image(s)", obj.getImages().size()));
            source.add(new NameValuePair("GIS enabled ", String.valueOf(obj.getGis())));
            if (obj.getGis().booleanValue()) {
                source.add(new NameValuePair("Layer Title", obj.getLayerName()));
                source.add(new NameValuePair("Layer Url", obj.getLayerUrl()));
            }
            if (obj.getImages().size() > 0) {
                source.add(new NameValuePair("Images base path", obj.getLocalBasePath()));
            }
            this.properties.setSource(source.toArray(new NameValuePair[source.size()]));
            Log.debug((String)"loaded Properties");
            if (obj.getImages().size() > 0) {
                block2: for (String name : this.imageMap.keySet()) {
                    ((Image)this.imageMap.get(name)).setUrl("");
                    ((Image)this.imageMap.get(name)).setVisible(false);
                    for (String fName : obj.getImages().keySet()) {
                        if (!fName.matches("(.)*" + name)) continue;
                        ((Image)this.imageMap.get(name)).setUrl((String)obj.getImages().get(fName));
                        ((Image)this.imageMap.get(name)).setVisible(true);
                        continue block2;
                    }
                }
            } else {
                for (Image img : this.imageMap.values()) {
                    img.setUrl("");
                    img.setVisible(false);
                }
            }
            Log.debug((String)"Object Loaded into details panel");
            if (obj.getGis().booleanValue()) {
                this.GIS.enable();
            } else {
                this.GIS.disable();
            }
        }
        catch (Exception e) {
            MessageBox.alert((String)"Sorry,some information may not be available");
            Log.error((String)"Exception while loading object in detail panel ", (Throwable)e);
        }
    }

    public void resize(int width, int height) {
        Log.debug((String)("Resizing details w: " + width + " h: " + height));
        this.properties.setSize(width, height);
        this.imagesContainer.setSize(width, height / 2);
    }

    static /* synthetic */ ClientObject access$000(AquaMapsDetailsPanel x0) {
        return x0.current;
    }
}

