/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.AquaMapsPortletRemoteService;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientEnvelope;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientObject;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.GISViewerParameters;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.Msg;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.SettingsDescriptor;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.ModelTranslation;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.log.AquaMapsObjectGenerationLogEntry;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.log.SavedAquaMapsItemLogEntry;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BoundingBox;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Envelope;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AreaType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FileType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AquaMapsPortletRemoteImpl
extends RemoteServiceServlet
implements AquaMapsPortletRemoteService {
    private static final long serialVersionUID = 8119786173899305965L;
    private static final Logger logger = LoggerFactory.getLogger(AquaMapsPortletRemoteImpl.class);
    private static final String layersPath = File.separator + "config" + File.separator + "layers.xml";

    public ClientEnvelope getEnvelope(String speciesId, boolean loadCustomizations) throws Exception {
        logger.debug("getEnvelop : " + speciesId);
        ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
        int hspenId = (Integer)session.getAttribute(ResourceType.HSPEN + "");
        try {
            Envelope toReturn = ((Maps)AbstractPlugin.maps().build()).loadEnvelope(speciesId, hspenId).extractEnvelope();
            logger.debug("loading customizations for species " + speciesId);
            if (loadCustomizations) {
                toReturn = Utils.loadCustomizations((Envelope)toReturn, (String)speciesId, (ASLSession)session);
            }
            return ModelTranslation.toClient((Envelope)toReturn, (String)speciesId);
        }
        catch (Exception e) {
            logger.error("Exception occurred while retrieving envelope", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public Msg submitJob(String title) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            Job job = Utils.loadSettings((ASLSession)session, (boolean)true, (boolean)true);
            job.setName(title);
            SettingsDescriptor desc = Utils.getStats((Job)job);
            if (desc.getSubmittable().getStatus()) {
                ((Maps)AbstractPlugin.maps().withTimeout(2, TimeUnit.MINUTES).build()).submitJob(job);
                AccessLogger aLogger = AccessLogger.getAccessLogger();
                for (AquaMapsObject obj : job.getAquaMapsObjectList()) {
                    aLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)new AquaMapsObjectGenerationLogEntry(obj, job.getSourceHSPEC()));
                }
                return new Msg(true, "Submitted job " + title);
            }
            return desc.getSubmittable();
        }
        catch (Exception e) {
            logger.error("Error while submitting job :", (Throwable)e);
            throw new Exception("Unable to contact service, please retry leter or contact support.");
        }
    }

    public ClientObject getAquaMapsObject(int id, boolean onlineDBMode) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            AquaMapsObject loaded = ((Maps)AbstractPlugin.maps().build()).loadObject(id);
            String layerName = null;
            String layerUrl = null;
            String basePath = null;
            if (loaded.getGis().booleanValue() && loaded.getLayers().size() > 0) {
                layerName = ((LayerInfo)loaded.getLayers().get(0)).getTitle();
                layerUrl = ((LayerInfo)loaded.getLayers().get(0)).getUrl();
            }
            if (loaded.getImages().size() > 0) {
                String uri = ((org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File)loaded.getImages().get(0)).getUuri();
                basePath = uri.substring(0, uri.lastIndexOf(47));
            }
            if (onlineDBMode) {
                ArrayList<String> specIds = new ArrayList<String>();
                for (Species sp : loaded.getSelectedSpecies()) {
                    specIds.add(sp.getId());
                }
                DBManager.getInstance((String)session.getScope()).fetchGeneratedObjRelatedSpecies(loaded.getId(), specIds);
                Utils.addFetchedBasketId((ASLSession)session, (int)id);
            }
            ClientObject toReturn = ModelTranslation.toClient((AquaMapsObject)loaded);
            toReturn.setLayerName(layerName);
            toReturn.setLayerUrl(layerUrl);
            toReturn.setLocalBasePath(basePath);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public Integer saveAquaMapsItem(List<Integer> objectId, String name, String destinationBasketId) throws Exception {
        int count = 0;
        ArrayList<Integer> toMark = new ArrayList<Integer>();
        for (int i = 0; i < objectId.size(); ++i) {
            try {
                this.saveAquaMapsItem(((Maps)AbstractPlugin.maps().build()).loadObject(objectId.get(i).intValue()), name + i, destinationBasketId);
                ++count;
                toMark.add(objectId.get(i));
                continue;
            }
            catch (Exception e) {
                logger.error("Unable to save " + objectId.get(i) + " with name " + name + i + " into " + destinationBasketId, (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        try {
            ((Maps)AbstractPlugin.maps().build()).markSaved(toMark);
        }
        catch (Exception e) {
            logger.error("Service was unable to mark saved objs", (Throwable)e);
            throw new Exception(e.getMessage());
        }
        return new Integer(count);
    }

    private void saveAquaMapsItem(AquaMapsObject obj, String name, String destinationBasketId) throws Exception {
        logger.debug("saveAquaMapsItem objectId: " + obj.getId() + " name: " + name + " destinationBasketId: " + destinationBasketId);
        File metaFile = File.createTempFile("AQ_" + obj.getId(), ".xml");
        AquaMapsXStream.serialize((String)metaFile.getAbsolutePath(), (Object)obj);
        ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
        Map files = this.retrieveFiles(obj.getImages());
        try {
            Workspace wa = HomeLibrary.getUserWorkspace((String)session.getUsername());
            WorkspaceFolder objFolder = wa.createFolder(obj.getName(), "AquaMaps object files", destinationBasketId);
            for (Map.Entry entry : files.entrySet()) {
                objFolder.createExternalImageItem((String)entry.getKey(), (String)entry.getKey(), null, (File)entry.getValue());
            }
            AccessLogger.getAccessLogger().logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)new SavedAquaMapsItemLogEntry(obj));
            for (File file : files.values()) {
                file.delete();
            }
            metaFile.delete();
        }
        catch (Exception e) {
            logger.error("error during aquamaps creation", (Throwable)e);
        }
    }

    protected Map<String, File> retrieveFiles(List<org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File> urls) {
        LinkedHashMap<String, File> files = new LinkedHashMap<String, File>();
        for (org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File f : urls) {
            if (f.getType().equals((Object)FileType.XML) || f.getType().equals((Object)FileType.ExternalMeta)) continue;
            String fileName = f.getName();
            String fileUrl = f.getUuri();
            logger.debug("*** processing fileName: " + fileName + " fileUrl: " + fileUrl);
            try {
                File file = this.retrieveFile(fileUrl);
                files.put(fileName, file);
            }
            catch (IOException e) {
                logger.error("error processing fileUrl: " + fileUrl, (Throwable)e);
            }
        }
        return files;
    }

    protected File retrieveFile(String urlValue) throws IOException {
        File tmp = File.createTempFile("aquamaps", "tmp");
        URL url = new URL(urlValue);
        URLConnection connection = url.openConnection();
        connection.connect();
        IOUtils.copy((InputStream)connection.getInputStream(), (OutputStream)new FileOutputStream(tmp));
        return tmp;
    }

    public ClientEnvelope reCalculateEnvelopeFromCellIds(List<String> cellsId, String speciesId) throws Exception {
        try {
            return ModelTranslation.toClient((Envelope)((Maps)AbstractPlugin.maps().build()).calculateEnvelopeFromCellSelection(cellsId, speciesId), (String)speciesId);
        }
        catch (Exception e) {
            logger.error("Set Species Filter exception", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public ClientEnvelope reCalculateGoodCells(String bb, String faoSelection, String speciesId, boolean useBottom, boolean useBounding, boolean useFAO) throws Exception {
        try {
            BoundingBox bounds = new BoundingBox();
            bounds.parse(bb);
            String[] areasString = faoSelection.split(",");
            ArrayList<Area> areas = new ArrayList<Area>();
            for (String code : areasString) {
                areas.add(new Area(AreaType.FAO, code.trim()));
            }
            return ModelTranslation.toClient((Envelope)((Maps)AbstractPlugin.maps().build()).calculateEnvelope(bounds, areas, speciesId, useBottom, useBounding, useFAO), (String)speciesId);
        }
        catch (Exception e) {
            logger.error("Set Species Filter exception", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public Integer deleteSubmittedById(List<Integer> submittedId) throws Exception {
        try {
            int count = 0;
            try {
                count += ((Maps)AbstractPlugin.maps().build()).deleteSubmitted(submittedId);
            }
            catch (Exception e) {
                logger.error("Unable to delete all ids size = " + submittedId.size(), (Throwable)e);
            }
            return new Integer(count);
        }
        catch (Exception e) {
            logger.error("Set Species Filter exception", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public GISViewerParameters checkGIS(int objectId) throws Exception {
        try {
            Submitted obj = ((Maps)AbstractPlugin.maps().build()).loadSubmittedById(objectId);
            List defaultLayers = (List)AquaMapsXStream.deSerialize((String)(this.getServletContext().getRealPath("") + layersPath));
            if (!obj.getGisEnabled().booleanValue()) {
                return new GISViewerParameters(defaultLayers, false, "Object was not GIS enabled.");
            }
            if (!obj.getStatus().equals((Object)SubmittedStatus.Error) && !obj.getStatus().equals((Object)SubmittedStatus.Completed)) {
                return new GISViewerParameters(defaultLayers, false, "Please wait for object to complete.");
            }
            defaultLayers.add(obj.getGisPublishedId());
            return new GISViewerParameters(defaultLayers, true, "retrieved list");
        }
        catch (Exception e) {
            logger.error("Check Gis Exception", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public Msg saveLayerItem(String url, String mimeType, String name, String destinationBasketId) throws Exception {
        try {
            ASLSession session = Utils.getSession((HttpSession)this.getThreadLocalRequest().getSession());
            Workspace wa = HomeLibrary.getUserWorkspace((String)session.getUsername());
            WorkspaceFolder basket = (WorkspaceFolder)wa.getItem(destinationBasketId);
            URL urlObject = new URL(url);
            URLConnection connection = urlObject.openConnection();
            connection.connect();
            WorkspaceUtil.createExternalFile((WorkspaceFolder)basket, (String)name, (String)"", (String)mimeType, (InputStream)connection.getInputStream());
            return new Msg(true, " Layer Saved correctly ");
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
            return new Msg(false, "Sorry, unable to retrieve layer data");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return new Msg(false, "Sorry, unable to load layer data");
        }
        catch (InsufficientPrivilegesException e) {
            logger.error("", (Throwable)e);
            return new Msg(false, "Sorry, unable to save layer data. Please check your privileges");
        }
        catch (ItemAlreadyExistException e) {
            logger.error("", (Throwable)e);
            return new Msg(false, "Sorry, unable to save layer data : an Item with the chosen name already exists.");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new Msg(false, "Sorry, unable to save layer. Unexpected Exception occurred. Try again or notify to administrator.");
        }
    }
}

