/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis;

import java.net.URISyntaxException;
import java.util.Date;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ObjectType;
import org.gcube.spatial.data.geonetwork.iso.GcubeISOMetadata;
import org.gcube.spatial.data.geonetwork.iso.MissingInformationException;
import org.gcube.spatial.data.geonetwork.utils.StringValidator;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.lineage.DefaultLineage;
import org.geotoolkit.metadata.iso.lineage.DefaultNominalResolution;
import org.geotoolkit.metadata.iso.lineage.DefaultProcessStep;
import org.geotoolkit.metadata.iso.lineage.DefaultSource;
import org.geotoolkit.metadata.iso.quality.DefaultDataQuality;
import org.geotoolkit.metadata.iso.quality.DefaultScope;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.Scope;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.util.InternationalString;

public class AquaMapsIsoMetadata
extends GcubeISOMetadata {
    private static final String aquamapsAlgorithmCitation = "Kaschner, K., J. S. Ready, E. Agbayani, J. Rius, K. Kesner-Reyes, P. D. Eastwood, A. B. South, S. O. Kullander, T. Rees, C. H. Close, R. Watson, D. Pauly, and R. Froese. 2008 AquaMaps: Predicted range maps for aquatic species. World wide web electronic publication, www.aquamaps.org, Version 10/2008.";
    private ObjectType type = null;
    private AlgorithmType algorithm = null;
    private String sourceTitle = null;
    private Date sourceGenerationTime = null;
    private String sourceTableName = null;

    public AquaMapsIsoMetadata() throws Exception {
        this.setPresentationForm(PresentationForm.MAP_DIGITAL);
        this.addTopicCategory(TopicCategory.BIOTA);
        this.setGeometricObjectType(GeometricObjectType.SURFACE);
        this.setTopologyLevel(TopologyLevel.GEOMETRY_ONLY);
        this.setResolution(0.5);
        this.addCredits(aquamapsAlgorithmCitation);
    }

    public String getAbstractField() {
        return "This " + this.getTitle() + " " + (this.getType().equals((Object)ObjectType.SpeciesDistribution) ? "Species Distribution" : "Biodiversity") + " Map has been generated with the AquaMaps methodology " + "by exploiting the technology and the computational resources provided by iMarine. " + "In particular, this map has been produced using the " + this.sourceTitle + " dataset, generated using AquaMaps " + this.getAlgorithm() + " algorithm.";
    }

    public String getPurpose() {
        return "The aim of this " + (this.getType().equals((Object)ObjectType.SpeciesDistribution) ? "Species Distribution" : "Biodiversity") + " map is to provide its users with a model-based map displaying prediction of species distributions based on occurrence records.";
    }

    protected void checkConstraints() throws MissingInformationException {
        super.checkConstraints();
        if (this.getType() == null) {
            throw new MissingInformationException("Field type is mandatory");
        }
        if (this.getAlgorithm() == null) {
            throw new MissingInformationException("Field algorithm is mandatory");
        }
        if (!StringValidator.isValidateString((String)this.getSourceTitle())) {
            throw new MissingInformationException("Field sourceTitle is mandatory");
        }
        if (!StringValidator.isValidateString((String)this.getSourceTableName())) {
            throw new MissingInformationException("Field sourceTableName is mandatory");
        }
        if (this.getSourceGenerationTime() == null) {
            throw new MissingInformationException("Field sourceGenerationTime is mandatory");
        }
    }

    public Metadata getMetadata() throws URISyntaxException, MissingInformationException {
        DefaultMetadata meta = (DefaultMetadata)super.getMetadata();
        meta.getDataQualityInfo().add(AquaMapsIsoMetadata.getDataQuality(this));
        return meta;
    }

    public ObjectType getType() {
        return this.type;
    }

    public void setType(ObjectType type) {
        this.type = type;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public String getSourceTitle() {
        return this.sourceTitle;
    }

    public void setSourceTitle(String sourceTitle) {
        this.sourceTitle = sourceTitle;
    }

    public Date getSourceGenerationTime() {
        return this.sourceGenerationTime;
    }

    public void setSourceGenerationTime(Date sourceGenerationTime) {
        this.sourceGenerationTime = sourceGenerationTime;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    private static DefaultDataQuality getDataQuality(AquaMapsIsoMetadata params) {
        DefaultDataQuality processQuality = new DefaultDataQuality();
        DefaultLineage processLineage = new DefaultLineage();
        DefaultSource source = new DefaultSource();
        DefaultNominalResolution sourceResolution = new DefaultNominalResolution();
        sourceResolution.setGroundResolution(Double.valueOf(0.5));
        sourceResolution.setScanningResolution(Double.valueOf(0.5));
        source.getSourceExtents().add(DefaultExtent.WORLD);
        DefaultCitation sourceCitation = new DefaultCitation();
        sourceCitation.setTitle((InternationalString)new DefaultInternationalString(params.getSourceTitle()));
        sourceCitation.getDates().add(new DefaultCitationDate(params.getSourceGenerationTime(), DateType.CREATION));
        sourceCitation.getIdentifiers().add(new DefaultIdentifier(params.getSourceTableName()));
        source.setSourceCitation((Citation)sourceCitation);
        DefaultProcessStep processStep = new DefaultProcessStep();
        processStep.setDescription((InternationalString)new DefaultInternationalString("AquaMaps Ecological Niche Modelling"));
        processLineage.setStatement((InternationalString)new DefaultInternationalString(aquamapsAlgorithmCitation));
        processLineage.getProcessSteps().add(processStep);
        processLineage.getSources().add(source);
        processQuality.setLineage((Lineage)processLineage);
        processQuality.setScope((Scope)new DefaultScope(ScopeCode.DATASET));
        return processQuality;
    }
}

