/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.HSPECGroupWorker;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;

public abstract class TableGenerationConfiguration {
    private LogicType logic;
    private AlgorithmType algorithm;
    private HashMap<ResourceType, List<Resource>> sources = new HashMap();
    private String maxMinHspenTable;
    private String submissionBackend;
    private String executionEnvironment;
    private String backendUrl;
    private HashMap<String, String> configuration;
    private int partitionsNumber;
    private String author;
    private ArrayList<Field> additionalParameters;
    private HSPECGroupWorker worker;

    public TableGenerationConfiguration(LogicType logic, AlgorithmType algorithm, List<Resource> sources, String submissionBackend, String executionEnvironment, String backendUrl, HashMap<String, String> configuration, int partitionsNumber, String author, ArrayList<Field> additionalParams, HSPECGroupWorker worker) throws Exception {
        this.logic = logic;
        this.algorithm = algorithm;
        for (Resource r : sources) {
            if (!this.sources.containsKey(r.getType())) {
                this.sources.put(r.getType(), new ArrayList());
            }
            this.sources.get(r.getType()).add(r);
        }
        this.submissionBackend = submissionBackend;
        this.executionEnvironment = executionEnvironment;
        this.backendUrl = backendUrl;
        this.configuration = configuration;
        this.partitionsNumber = partitionsNumber;
        this.author = author;
        if (this.sources.containsKey(ResourceType.HSPEN)) {
            this.maxMinHspenTable = SourceManager.getMaxMinTable(this.sources.get(ResourceType.HSPEN).get(0));
        }
        this.additionalParameters = additionalParams;
        this.worker = worker;
    }

    public ArrayList<Field> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public LogicType getLogic() {
        return this.logic;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public HashMap<ResourceType, List<Resource>> getSources() {
        return this.sources;
    }

    public String getSubmissionBackend() {
        return this.submissionBackend;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public String getBackendUrl() {
        return this.backendUrl;
    }

    public HashMap<String, String> getConfiguration() {
        return this.configuration;
    }

    public int getPartitionsNumber() {
        return this.partitionsNumber;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMaxMinHspenTable() {
        return this.maxMinHspenTable;
    }

    public String toString() {
        return "TableGenerationConfiguration [logic=" + this.logic + ", algorithm=" + this.algorithm + ", sources=" + this.sources + ", maxMinHspenTable=" + this.maxMinHspenTable + ", submissionBackend=" + this.submissionBackend + ", executionEnvironment=" + this.executionEnvironment + ", backendUrl=" + this.backendUrl + ", configuration=" + this.configuration + ", partitionsNumber=" + this.partitionsNumber + ", author=" + this.author + ", additionalParameters=" + this.additionalParameters + "]";
    }

    public abstract void registerGeneratedSourcesCallback(List<String> var1) throws Exception;

    public abstract void notifyError(Exception var1);

    public abstract void release(BatchGeneratorI var1);
}

