package org.gcube.application.aquamaps.enabling;

import java.util.List;
import java.util.Set;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherInterface;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.common.core.scope.GCUBEScope;

public interface Configuration {

	public DataManagementInterface getDMInterface(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException,Exception;
	public AquaMapsServiceInterface getAMInterface(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException,Exception;
	public PublisherInterface getPublisherInterface(GCUBEScope scope) throws ParameterNotFoundException,ScopeNotFoundException,Exception;
	public List<GeoServerDescriptor> getGeoServers(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException;
	public String getServiceConfigurationParameter(GCUBEScope scope,String parameter)throws ParameterNotFoundException,ScopeNotFoundException;
	public String getBackendUrl(GCUBEScope scope,String backend)throws ParameterNotFoundException,ScopeNotFoundException;
	public List<ComputationalInfrastructure> getAvailableInfrastructures(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException;
	public Set<GCUBEScope> getAvailableScopes() throws Exception;
	public DBDescriptor getGeoServerDb(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException;
	public DBDescriptor getInternalDB(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException;
	public DataSourceDescriptor getGeoNetwork(GCUBEScope scope) throws ParameterNotFoundException,ScopeNotFoundException;
	public GeoServerDescriptor getGeoServerByEntryPoint(GCUBEScope scope,String entryPoint)throws ParameterNotFoundException,ScopeNotFoundException;
	public DBDescriptor getPublisherDataBase(GCUBEScope scope)throws ParameterNotFoundException,ScopeNotFoundException;
}
