package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.Constant;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor.DBType;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.application.aquamaps.enabling.model.VODescriptor;
import org.gcube.application.aquamaps.enabling.util.Constants;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class ISCrawler {

	
	protected static ISClient isClient;
	
	protected static GCUBELog logger= new GCUBELog(ISCrawler.class);
	
	protected GCUBEScope scope=null;

	protected Thread updater;	
	
	
	static{
		try {
			isClient = GHNContext.getImplementation(ISClient.class);
		} catch (Exception e) {
			logger.error("Unable to get ISImplementation : "+e);
		}
	}
	
	private GCUBEScope infrastructureScope=null; 
	private ConcurrentHashMap<GCUBEScope,VODescriptor> infrastructureMap=new ConcurrentHashMap<GCUBEScope, VODescriptor>();
	
//	public static void main(String[] args) throws Exception{
//		ISCrawler crawler=get(3,CrawlerMode.SERVICE,null);
//		for(Entry<GCUBEScope, VODescription> entry:crawler.getInfrastructureMap().entrySet()){
//			System.out.println("***************** Scope "+entry.getKey().getName());
//			System.out.println(entry.getValue());
//		}
//	}
	
	private static ISCrawler instance=null;
	
	
	public static synchronized ISCrawler get(int minutes, CrawlerMode mode, GCUBEScope startScope) throws Exception{
		if(instance==null){
			switch(mode){
			case PORTAL : instance=new PortalCrawler(minutes);
						break;
			case SERVICE : instance = new ServiceCrawler(minutes);
						break;
			case SINGLESCOPE : instance=new SingleScopeCrawler(minutes,startScope);
			break;
			}			
		}
		return instance;
	}
	
	public static ISCrawler get(int minutes, CrawlerMode mode) throws Exception{
		return get(minutes,mode,getInfrastructure());
	}
	
	private static GCUBEScope getInfrastructure()throws Exception{		
		GCUBEScope infrastructureScope=GHNContext.getContext().getStartScopes()[0].getInfrastructure();
		return infrastructureScope;			
	}
	

	protected abstract ArrayList<GCUBEScope> findAvailableScopes(GCUBEScope Infrastructure)throws Exception;
	
	protected VODescriptor getScopeInformation(GCUBEScope scope)throws Exception{		
		try{
			logger.debug("Checking scope : "+scope);
			

			
			// check computational Infrastructures
			List<ComputationalInfrastructure> infrastructures=getEnvironments(scope);
			
			HashSet<String> registeredBackends= new HashSet<String>();
			
			for(ComputationalInfrastructure c: infrastructures) registeredBackends.add(c.getSubmissionBackend());
			
			
			//************************** Backends & AQ Service Running Instances 
			HashMap<String,String> backendsURL=new HashMap<String, String>();
			HashMap<String,String> serverConfiguration=new HashMap<String, String>();
			GCUBERunningInstance RI=null;			
			
			
			for(GCUBERunningInstance ri:getRIs(scope)){
				if(registeredBackends.contains(ri.getServiceName())) 
						backendsURL.put(ri.getServiceName(), ri.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue());
				if(ri.getServiceClass().equals(Constant.SERVICE_CLASS)&&(ri.getServiceName().equals(Constant.SERVICE_NAME)))
					if(RI!=null) throw new Exception ("Multiple AquaMaps RI found on this scope, previous was "+
							RI.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue()+" , previous was "+
							ri.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue());
					else RI=ri;
			}
			if(isCheckRunningInstance()){
				if(RI!=null) {
					DataManagementInterface dmInterface=DataManagementCall.getCall(scope, RI.getAccessPoint().getEndpoint(Constant.DATAMANAGEMENT_PT_NAME).getAddress().toString(),false);
					for(Field f:dmInterface.getDefaultSources())
						serverConfiguration.put(f.getName(), f.getValue());
				}else throw new Exception ("NO VALID RI FOUND");
			}
			
			//************************** GeoServers - Runtime Resources
			List<GeoServerDescriptor> geoServers=getGeoServers(scope);
			List<DataSourceDescriptor> geoNetworks=getGeoNetwork(scope);
			List<DBDescriptor> gisDBs=getGISDataBase(scope);
			List<DBDescriptor> internalDBs=getInternalDB(scope);
			List<DBDescriptor> publisherDBs=getPublisherDB(scope);
			
			
			//************************** Checks
			
			if(geoNetworks.size()>1) throw new Exception("Multiple GeoNetworks found");
			if(isCheckGisDatabase()&&geoServers.size()>0&&gisDBs.isEmpty()) throw new Exception("No gis databases found");
			if(isCheckGisDatabase()&&gisDBs.size()>1) throw new Exception ("Found "+gisDBs.size()+" gis DBs");
			if(isCheckInternalDB()&&internalDBs.size()!=1) throw new Exception ("Found "+internalDBs.size()+" internal DBs");
			if(isCheckPublisherDatabase()&&publisherDBs.size()!=1) throw new Exception ("Found "+publisherDBs.size()+" publisher DBs");
						
			DataSourceDescriptor geoNetwork=geoNetworks.isEmpty()?null:geoNetworks.get(0);
			DBDescriptor internal=internalDBs.isEmpty()?null:internalDBs.get(0);
			DBDescriptor publisher=publisherDBs.isEmpty()?null:publisherDBs.get(0);
			DBDescriptor gisDb=gisDBs.isEmpty()?null:gisDBs.get(0);
			
			return new VODescriptor(scope, RI, geoServers, geoNetwork, internal, gisDb,publisher, infrastructures, serverConfiguration, backendsURL);
		}catch(Exception e){
			logger.error("Unexpected Error while crawling scope "+scope+", error message : "+e.getMessage());
			logger.debug("Instance : "+checks());
			logger.debug("StackTrace  ",e);
			throw e;
		}
		
	}
	
	
	protected ISCrawler(final int minutes)throws Exception{		
		updater=new Thread(){
			@Override
			public void run() {
				while(true)
					try{
						forceUpdate();
					}catch(Throwable t){
						logger.error("Unexpected Exception while updateing",t);					
					}
					finally{
						logger.trace("Update routine completed, available scopes are "+infrastructureMap.keySet());
						try{
						Thread.sleep(minutes*60*1000);
						}catch(InterruptedException e){}
					}
			}
		};		
	}
	
	public void forceUpdate()throws Exception{
		infrastructureScope=getInfrastructure();		
		for(GCUBEScope scope:findAvailableScopes(infrastructureScope)){
			try{
				if(scope!=null)infrastructureMap.put(scope, getScopeInformation(scope));
			}catch(Exception e){
				logger.warn("Unable to crawl through scope "+scope.getName(),e);
			}
		}
	}
	
	public ConcurrentHashMap<GCUBEScope, VODescriptor> getInfrastructureMap() {
		return infrastructureMap;
	}
	
	//******************************************** QUERIES
	
	protected static List<GCUBERunningInstance> getRIs(GCUBEScope scope)throws Exception{
		GCUBERIQuery backendsQuery=isClient.getQuery(GCUBERIQuery.class);
		return isClient.execute(backendsQuery, scope);
	}
	
	protected static List<ComputationalInfrastructure> getEnvironments(GCUBEScope scope)throws Exception{
		List<ComputationalInfrastructure> toReturn=new ArrayList<ComputationalInfrastructure>();
		GCUBEGenericResourceQuery infrastructureQuery=isClient.getQuery(GCUBEGenericResourceQuery.class);
		infrastructureQuery.addAtomicConditions(new AtomicCondition("//Profile/SecondaryType", "ComputationalInfrastructure"));
		for(GCUBEGenericResource resource : isClient.execute(infrastructureQuery, scope)){
			try{
			String body=resource.getBody();
			ComputationalInfrastructure infrastructure=(ComputationalInfrastructure) AquaMapsXStream.getXMLInstance().fromXML(body);
			toReturn.add(infrastructure);
			}catch(Exception e){
				logger.warn("Unable to parse resource [ID :"+resource.getID()+"]",e);
			}
		}
		return toReturn;
	}
	
	protected static List<GeoServerDescriptor> getGeoServers(GCUBEScope scope)throws Exception{
		logger.debug("Checking geoServers..");
		List<GeoServerDescriptor> toReturn=new ArrayList<GeoServerDescriptor>();
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", Constants.get().getGeoServerCategoryName()));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerPlatformName()));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);
		for(GCUBERuntimeResource rr:list){
			try{
				for(AccessPoint access:rr.getAccessPoints()){
					if(access.getEntryname().equals(Constants.get().getGeoServerEntryName())){
						logger.debug("Found Access point "+access.getEntryname()+" in "+rr.getName()+" [ ID : "+rr.getID()+"]");
						toReturn.add(new GeoServerDescriptor(
								access.getEndpoint(), 
								access.getUsername(), 
								access.getPassword(), 
								access.getProperty(Constants.get().getGeoServerAquaMapsWorkspace()), 
								access.getProperty(Constants.get().getGeoServerAquaMapsDataStore()), 
								access.getProperty(Constants.get().getGeoServerAquaMapsDefaultDistributionStyle())));
					}
				}
			}catch(Exception e){
				logger.warn("Unable to parse resource [ID :"+rr.getID()+"]",e);
			}
		}
		return toReturn;
	}
	
	protected static List<DataSourceDescriptor> getGeoNetwork(GCUBEScope scope)throws Exception{
		logger.debug("Checking geoNetwork..");
		ArrayList<DataSourceDescriptor> toReturn=new ArrayList<DataSourceDescriptor>();
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", Constants.get().getGeoNetworkCategoryName()));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoNetworkPlatformName()));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);
		for(GCUBERuntimeResource rr:list){
			try{
				for(AccessPoint access:rr.getAccessPoints())
					if(access.getEntryname().equals(Constants.get().getGeoNetworkEntryName())){	
						logger.debug("Found Access point "+access.getEntryname()+" in "+rr.getName()+" [ ID : "+rr.getID()+"]");
						toReturn.add(new DataSourceDescriptor(
								access.getEndpoint(), 
								access.getUsername(),
								access.getPassword()));
					}
			}catch(Exception e){logger.warn("Unable to parse resource [ID :"+rr.getID()+"]",e);}
		}
		return toReturn;
	}
	
	
	protected static ArrayList<DBDescriptor> getGISDataBase(GCUBEScope scope)throws Exception{
		logger.debug("Checking gis DBs");		
		ArrayList<DBDescriptor> toReturn=new ArrayList<DBDescriptor>();
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", Constants.get().getGeoServerDBCategory()));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerDBPlatformName()));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);
		for(GCUBERuntimeResource rr:list){
			try{
				for(AccessPoint access: rr.getAccessPoints()){			
					if(access.getEntryname().equals(Constants.get().getGeoServerDBEntryName())&&
							access.getAllPropertyNames().contains(Constants.get().getGeoServerDBAquaMapsDataStore())&&
							Boolean.parseBoolean(access.getProperty(Constants.get().getGeoServerDBAquaMapsDataStore()))){
						logger.debug("Found Access point "+access.getEntryname()+" in "+rr.getName()+" [ ID : "+rr.getID()+"]");
						DBDescriptor toAdd=new DBDescriptor(
								access.getEndpoint(), 
								access.getUsername(), 
								access.getPassword(), 
								DBType.postgres,
								Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));
						toAdd.setProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE, access.getProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE));
						toReturn.add(toAdd);
					}
				}
			}catch(Exception e){logger.warn("Unable to parse resource [ID :"+rr.getID()+"]",e);}

		}
		return toReturn;
	}
	protected static ArrayList<DBDescriptor> getInternalDB(GCUBEScope scope)throws Exception{
		logger.debug("Checking internal DBs");
		ArrayList<DBDescriptor> toReturn=new ArrayList<DBDescriptor>();
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", Constants.get().getInternalDBCategoryName()));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", Constants.get().getInternalDBPlatformName()));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);
		for(GCUBERuntimeResource rr:list){
			try{
				for(AccessPoint access:rr.getAccessPoints()){
					if(access.getEntryname().equals(Constants.get().getInternalDBEntryName())&&
							access.getAllPropertyNames().contains(Constants.get().getInternalDBSchemaName())&&
							access.getProperty(Constants.get().getInternalDBSchemaName()).equals(Constants.get().getInternalDBSchemaValue())){
						logger.debug("Found Access point "+access.getEntryname()+" in "+rr.getName()+" [ ID : "+rr.getID()+"]");
						DBDescriptor toAdd=new DBDescriptor(
								access.getEndpoint(), 
								access.getUsername(), 
								access.getPassword(), 
								DBType.postgres,
								Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));

						toAdd.setProperty(DBDescriptor.TABLESPACE_PREFIX, access.getProperty(DBDescriptor.TABLESPACE_PREFIX));
						toAdd.setProperty(DBDescriptor.TABLESPACE_COUNT, access.getProperty(DBDescriptor.TABLESPACE_COUNT));
						toReturn.add(toAdd);
					}
				}
			}catch(Exception e){logger.warn("Unable to parse resource [ID :"+rr.getID()+"]",e);}
		}
		return toReturn;
	}
	
	protected static ArrayList<DBDescriptor> getPublisherDB(GCUBEScope scope)throws Exception{
		logger.debug("Checking internal DBs");
		ArrayList<DBDescriptor> toReturn=new ArrayList<DBDescriptor>();
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", Constants.get().getPublisherDBCategoryName()));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", Constants.get().getPublisherDBPlatformName()));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);
		for(GCUBERuntimeResource rr:list){
			try{
				for(AccessPoint access:rr.getAccessPoints()){
					if(access.getEntryname().equals(Constants.get().getPublisherDBEntryName())&&
							access.getAllPropertyNames().contains(Constants.get().getPublisherDBSchemaName())&&
							access.getProperty(Constants.get().getPublisherDBSchemaName()).equals(Constants.get().getPublisherDBSchemaValue())){
						logger.debug("Found Access point "+access.getEntryname()+" in "+rr.getName()+" [ ID : "+rr.getID()+"]");
						DBDescriptor toAdd=new DBDescriptor(
								access.getEndpoint(), 
								access.getUsername(), 
								access.getPassword(), 
								DBType.postgres,
								Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));

						toReturn.add(toAdd);
					}
				}
			}catch(Exception e){logger.warn("Unable to parse resource [ID :"+rr.getID()+"]",e);}
		}
		return toReturn;
	}
	
	
	// VO CHECKS
	
	protected abstract boolean isCheckInternalDB();
	protected abstract boolean isCheckGisDatabase();
	protected abstract boolean isCheckPublisherDatabase();
	protected abstract boolean isCheckRunningInstance();

	
	public String checks() {
		StringBuilder builder = new StringBuilder();
		builder.append("INSTANCE : "+hashCode());
		builder.append(" [isCheckInternalDB()=");
		builder.append(isCheckInternalDB());
		builder.append(", isCheckGisDatabase()=");
		builder.append(isCheckGisDatabase());
		builder.append(", isCheckPublisherDatabase()=");
		builder.append(isCheckPublisherDatabase());
		builder.append(", isCheckRunningInstance()=");
		builder.append(isCheckRunningInstance());
		builder.append("]");
		return builder.toString();
	}
	
	
}