package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.scope.GCUBEScope;

import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;

public class PortalCrawler extends ISCrawler {

	public PortalCrawler(int minutes) throws Exception {
		super(minutes);
		forceUpdate();
		updater.start();
	}
	
	@Override
	protected ArrayList<GCUBEScope> findAvailableScopes(
			GCUBEScope Infrastructure) throws Exception {
				
				ArrayList<GCUBEScope> toReturn=new ArrayList<GCUBEScope>();
				
				//************* PORTAL MODE, Checking organizations
				logger.trace("CHECKING SCOPES, PORTAL MODE IS ON");
				toReturn.add(Infrastructure);
				
				
				///************* GET ROOT ORGANIZATION
				List<Organization> organizations = OrganizationLocalServiceUtil.getOrganizations(0, OrganizationLocalServiceUtil.getOrganizationsCount());
				Organization rootOrganization = null;				
				for (Organization organization : organizations) {
					if (organization.getName().equals(Infrastructure.getName()) ) {
						rootOrganization = organization;
						break;
					}
				}
				if(rootOrganization==null) throw new Exception("Unable to find infrastructure scope "+Infrastructure.getName()+" among organizations");
				//************** GET VO
				for (Organization vOrg : rootOrganization.getSuborganizations()){
					String VOScopeString="/"+vOrg.getParentOrganization().getName()+"/"+vOrg.getName();
					try{
						toReturn.add(GCUBEScope.getScope(VOScopeString));
						for (Organization vre : vOrg.getSuborganizations()){
							String VREScopeString=VOScopeString+"/"+vre.getName();
							try{
								toReturn.add(GCUBEScope.getScope(VREScopeString));
							}catch(Exception e){
								logger.error("Unable to Find a scope for the organization "+VREScopeString);
							}
						}
					}catch(Exception e){
						logger.error("Unable to Find a scope for the organization "+VOScopeString);
					}
					//************* GET VRE
				}
				
				return toReturn;
				
			}

	@Override
	protected boolean isCheckInternalDB() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected boolean isCheckGisDatabase() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected boolean isCheckPublisherDatabase() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected boolean isCheckRunningInstance() {
		// TODO Auto-generated method stub
		return true;
	}
}
