package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.Constant;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.application.aquamaps.enabling.model.VODescriptor;
import org.gcube.application.aquamaps.enabling.util.ParserXPath;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.Type;

public class ServiceCrawler extends ISCrawler {

	
	public ServiceCrawler(int minutes) throws Exception {
		super(minutes);
		forceUpdate();
		updater.start();
	}
	
//	@Override
//	protected VODescriptor getScopeInformation(GCUBEScope scope)throws Exception{		
//		try{
//			logger.debug("Checking scope : "+scope);
//			
//
//			
//			// check computational Infrastructures
//			List<ComputationalInfrastructure> infrastructures=getEnvironments(scope);
//			
//			HashSet<String> registeredBackends= new HashSet<String>();
//			
//			for(ComputationalInfrastructure c: infrastructures) registeredBackends.add(c.getSubmissionBackend());
//			
//			
//			//************************** Backends & AQ Service Running Instances 
//			HashMap<String,String> backendsURL=new HashMap<String, String>();
//			HashMap<String,String> serverConfiguration=new HashMap<String, String>();
//			GCUBERunningInstance RI=null;			
//			
//			
//			for(GCUBERunningInstance ri:getRIs(scope)){
//				if(registeredBackends.contains(ri.getServiceName())) 
//						backendsURL.put(ri.getServiceName(), ri.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue());
//				if(ri.getServiceClass().equals(Constant.SERVICE_CLASS)&&(ri.getServiceName().equals(Constant.SERVICE_NAME)))
//					if(RI!=null) throw new Exception ("Multiple AquaMaps RI found on this scope, previous was "+
//							RI.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue()+" , previous was "+
//							ri.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0).getValue());
//					else RI=ri;
//			}
//			
//			
//			
//			
//			//************************** GeoServers - Runtime Resources
//			List<GeoServerDescriptor> geoServers=getGeoServers(scope);
//			List<DataSourceDescriptor> geoNetworks=getGeoNetwork(scope);
//			List<DBDescriptor> gisDBs=getGISDataBase(scope);
//			List<DBDescriptor> internalDBs=getInternalDB(scope);
//			List<DBDescriptor> publisherDBs=getPublisherDB(scope);
//			
//			
//			//************************** Checks
//			
//			if(geoNetworks.size()>1) throw new Exception("Multiple GeoNetworks found");
//			if(geoServers.size()>0&&gisDBs.isEmpty()) throw new Exception("No gis databases found");
//			if(gisDBs.size()>1) throw new Exception ("Found "+gisDBs.size()+" gis DBs");
//			if(internalDBs.size()!=1) throw new Exception ("Found "+internalDBs.size()+" internal DBs");
//			if(publisherDBs.size()!=1) throw new Exception ("Found "+publisherDBs.size()+" publisher DBs");
//						
//			DataSourceDescriptor geoNetwork=geoNetworks.isEmpty()?null:geoNetworks.get(0);
//			DBDescriptor internal=internalDBs.get(0);
//			DBDescriptor publisher=publisherDBs.get(0);
//			DBDescriptor gisDb=gisDBs.isEmpty()?null:gisDBs.get(0);
//			
//			return new VODescriptor(scope, RI, geoServers, geoNetwork, internal, gisDb,publisher, infrastructures, serverConfiguration, backendsURL);
//		}catch(Exception e){
//			logger.error("Unexpected Error while crawling scope "+scope+", error message : "+e.getMessage());
//			logger.debug("StackTrace  ",e);
//			throw e;
//		}
//		
//	}
	
	
	
	
	
	@Override
	protected ArrayList<GCUBEScope> findAvailableScopes(
			GCUBEScope Infrastructure) throws Exception {
		HashSet<GCUBEScope> toReturn=new HashSet<GCUBEScope>();
		for(GCUBEScope scope : GHNContext.getContext().getStartScopes()){
			toReturn.add(scope);
			toReturn.addAll(getChildren(scope));
		}
		for(GCUBEScope scope :GHNContext.getContext().getStartScopes()){
			toReturn.add(scope);
			toReturn.addAll(getChildren(scope));
		}
		toReturn.add(Infrastructure);
		return new ArrayList<GCUBEScope>(toReturn);
	}

	
	protected ArrayList<GCUBEScope> getChildren(GCUBEScope scope)throws Exception{
		ArrayList<GCUBEScope> toReturn=new ArrayList<GCUBEScope>();
		if(!scope.getType().equals(Type.VRE)){
			logger.debug("Retrieving children of scope "+scope+", ("+scope.getType()+")");
			GCUBEGenericResourceQuery scopeQuery=isClient.getQuery(GCUBEGenericResourceQuery.class);
			String secondaryType=scope.getType().equals(Type.VO)?"VRE":"VO";		
			scopeQuery.addAtomicConditions(new AtomicCondition("//Profile/SecondaryType", secondaryType));
			for(GCUBEGenericResource res:isClient.execute(scopeQuery, scope)){
				try{
					String foundScope=ParserXPath.getTextFromXPathExpression("<rootNode>"+res.getBody()+"</rootNode>", "//Scope").get(0);
					toReturn.add(GCUBEScope.getScope(foundScope));
				}catch(Exception e){
					logger.warn("Unable to detect scope from generic resource [ID : "+res.getID()+"] under scope "+scope,e);
				}
			}
		}
		return toReturn;
	}

	@Override
	protected boolean isCheckInternalDB() {
		return true;
	}

	@Override
	protected boolean isCheckGisDatabase() {
		return true;
	}

	@Override
	protected boolean isCheckPublisherDatabase() {
		return true;
	}

	@Override
	protected boolean isCheckRunningInstance() {
		return false;
	}
}
