package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;

import org.gcube.common.core.scope.GCUBEScope;

public class SingleScopeCrawler extends ISCrawler {

	private boolean checkInternalDb=true;
	private boolean checkPublisherDb=true;
	private boolean checkGisDb=true;
	private boolean checkRunningInstance=true;
	
	private GCUBEScope scope=null; 
	
	public SingleScopeCrawler(int minutes,GCUBEScope defaultScope) throws Exception {
		super(minutes);
		scope=defaultScope;
		forceUpdate();
		updater.start();		
	}
	
	
	@Override
	protected ArrayList<GCUBEScope> findAvailableScopes(
			GCUBEScope Infrastructure) throws Exception {
		ArrayList<GCUBEScope> toReturn=new ArrayList<GCUBEScope>();
		toReturn.add(scope);
		return toReturn;
	}
	@Override
	protected boolean isCheckInternalDB() {
		return checkInternalDb;
	}
	@Override
	protected boolean isCheckGisDatabase() {
		return checkGisDb;
	}
	@Override
	protected boolean isCheckPublisherDatabase() {
		return checkPublisherDb;
	}
	@Override
	protected boolean isCheckRunningInstance() {
		return checkRunningInstance;
	}	
}
