package org.gcube.application.aquamaps.enabling.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.enabling.ParameterNotFoundException;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;

public class VODescriptor {

	private GCUBEScope scope;
	private GCUBERunningInstance runningInstance;
	private List<GeoServerDescriptor> geoServers=new ArrayList<GeoServerDescriptor>();
	private DataSourceDescriptor geoNetwork;
	
	private DBDescriptor internalDB;
	private DBDescriptor geoDb;
	private DBDescriptor publisherDB;
	
	private List<ComputationalInfrastructure> infrastructures=new ArrayList<ComputationalInfrastructure>();

	private HashMap<String,String> serviceConfiguration=new HashMap<String, String>();

	private HashMap<String,String> backendsUrl=new HashMap<String, String>();
	
	
	
	
	public VODescriptor(GCUBEScope scope, GCUBERunningInstance runningInstance,
			List<GeoServerDescriptor> geoServers,
			DataSourceDescriptor geoNetwork, DBDescriptor internalDB,
			DBDescriptor geoDb,DBDescriptor publisherDB,
			List<ComputationalInfrastructure> infrastructures,
			HashMap<String, String> serviceConfiguration,
			HashMap<String, String> backendsUrl) {
		super();
		this.scope = scope;
		this.runningInstance = runningInstance;
		this.geoServers = geoServers;
		this.geoNetwork = geoNetwork;
		this.internalDB = internalDB;
		this.geoDb = geoDb;
		this.infrastructures = infrastructures;
		this.serviceConfiguration = serviceConfiguration;
		this.backendsUrl = backendsUrl;
		this.publisherDB=publisherDB;
	}




	public String getServiceParam(String paramName){
		return serviceConfiguration.get(paramName);
	}




	public GCUBEScope getScope() {
		return scope;
	}




	public GCUBERunningInstance getRunningInstance() {
		return runningInstance;
	}




	public List<GeoServerDescriptor> getGeoServers() {
		return geoServers;
	}




	public DataSourceDescriptor getGeoNetwork() {
		return geoNetwork;
	}




	public DBDescriptor getInternalDB() {
		return internalDB;
	}




	public DBDescriptor getGeoDb() {
		return geoDb;
	}




	public List<ComputationalInfrastructure> getInfrastructures() {
		return infrastructures;
	}




	public HashMap<String, String> getServiceConfiguration() {
		return serviceConfiguration;
	}




	public HashMap<String, String> getBackendsUrl() {
		return backendsUrl;
	}

	public DBDescriptor getPublisherDB() {
		return publisherDB;
	}


	




	public GeoServerDescriptor getGeoServerByEntryPoint(String entryPoint) throws ParameterNotFoundException{
		for(GeoServerDescriptor desc:geoServers)
			if(desc.getEntryPoint().equals(entryPoint))return desc;
		throw new ParameterNotFoundException();
	}




	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((backendsUrl == null) ? 0 : backendsUrl.hashCode());
		result = prime * result + ((geoDb == null) ? 0 : geoDb.hashCode());
		result = prime * result
				+ ((geoNetwork == null) ? 0 : geoNetwork.hashCode());
		result = prime * result
				+ ((geoServers == null) ? 0 : geoServers.hashCode());
		result = prime * result
				+ ((infrastructures == null) ? 0 : infrastructures.hashCode());
		result = prime * result
				+ ((internalDB == null) ? 0 : internalDB.hashCode());
		result = prime * result
				+ ((publisherDB == null) ? 0 : publisherDB.hashCode());
		result = prime * result
				+ ((runningInstance == null) ? 0 : runningInstance.hashCode());
		result = prime * result + ((scope == null) ? 0 : scope.hashCode());
		result = prime
				* result
				+ ((serviceConfiguration == null) ? 0 : serviceConfiguration
						.hashCode());
		return result;
	}




	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		VODescriptor other = (VODescriptor) obj;
		if (backendsUrl == null) {
			if (other.backendsUrl != null)
				return false;
		} else if (!backendsUrl.equals(other.backendsUrl))
			return false;
		if (geoDb == null) {
			if (other.geoDb != null)
				return false;
		} else if (!geoDb.equals(other.geoDb))
			return false;
		if (geoNetwork == null) {
			if (other.geoNetwork != null)
				return false;
		} else if (!geoNetwork.equals(other.geoNetwork))
			return false;
		if (geoServers == null) {
			if (other.geoServers != null)
				return false;
		} else if (!geoServers.equals(other.geoServers))
			return false;
		if (infrastructures == null) {
			if (other.infrastructures != null)
				return false;
		} else if (!infrastructures.equals(other.infrastructures))
			return false;
		if (internalDB == null) {
			if (other.internalDB != null)
				return false;
		} else if (!internalDB.equals(other.internalDB))
			return false;
		if (publisherDB == null) {
			if (other.publisherDB != null)
				return false;
		} else if (!publisherDB.equals(other.publisherDB))
			return false;
		if (runningInstance == null) {
			if (other.runningInstance != null)
				return false;
		} else if (!runningInstance.equals(other.runningInstance))
			return false;
		if (scope == null) {
			if (other.scope != null)
				return false;
		} else if (!scope.equals(other.scope))
			return false;
		if (serviceConfiguration == null) {
			if (other.serviceConfiguration != null)
				return false;
		} else if (!serviceConfiguration.equals(other.serviceConfiguration))
			return false;
		return true;
	}




	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("VODescriptor [scope=");
		builder.append(scope);
		builder.append(", runningInstance=");
		builder.append(runningInstance);
		builder.append(", geoServers=");
		builder.append(geoServers);
		builder.append(", geoNetwork=");
		builder.append(geoNetwork);
		builder.append(", internalDB=");
		builder.append(internalDB);
		builder.append(", geoDb=");
		builder.append(geoDb);
		builder.append(", publisherDB=");
		builder.append(publisherDB);
		builder.append(", infrastructures=");
		builder.append(infrastructures);
		builder.append(", serviceConfiguration=");
		builder.append(serviceConfiguration);
		builder.append(", backendsUrl=");
		builder.append(backendsUrl);
		builder.append("]");
		return builder.toString();
	}




	


	
}