/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.enabling.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.enabling.ParameterNotFoundException;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;

public class VODescriptor {
    private String scope;
    private String dmEndpoint = null;
    private String amEndpoint = null;
    private String pubEndpoint = null;
    private List<GeoServerDescriptor> geoServers = new ArrayList<GeoServerDescriptor>();
    private DataSourceDescriptor geoNetwork;
    private DBDescriptor internalDB;
    private DBDescriptor geoDb;
    private DBDescriptor publisherDB;
    private List<ComputationalInfrastructure> infrastructures = new ArrayList<ComputationalInfrastructure>();
    private HashMap<String, String> serviceConfiguration = new HashMap();
    private HashMap<String, String> backendsUrl = new HashMap();

    public VODescriptor(GCUBEScope scope, GCUBERunningInstance runningInstance, List<GeoServerDescriptor> geoServers, DataSourceDescriptor geoNetwork, DBDescriptor internalDB, DBDescriptor geoDb, DBDescriptor publisherDB, List<ComputationalInfrastructure> infrastructures, HashMap<String, String> serviceConfiguration, HashMap<String, String> backendsUrl) {
        this.scope = scope.toString();
        if (runningInstance != null && runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/DataManagement") != null) {
            this.dmEndpoint = runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/DataManagement").getAddress().toString();
        }
        if (runningInstance != null && runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/AquaMapsService") != null) {
            this.amEndpoint = runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/AquaMapsService").getAddress().toString();
        }
        if (runningInstance != null && runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/PublisherService") != null) {
            this.pubEndpoint = runningInstance.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/PublisherService").getAddress().toString();
        }
        this.geoServers = geoServers;
        this.geoNetwork = geoNetwork;
        this.internalDB = internalDB;
        this.geoDb = geoDb;
        this.infrastructures = infrastructures;
        this.serviceConfiguration = serviceConfiguration;
        this.backendsUrl = backendsUrl;
        this.publisherDB = publisherDB;
    }

    public String getServiceParam(String paramName) {
        return this.serviceConfiguration.get(paramName);
    }

    public String getScope() {
        return this.scope;
    }

    public String getDmEndpoint() {
        return this.dmEndpoint;
    }

    public String getAmEndpoint() {
        return this.amEndpoint;
    }

    public List<GeoServerDescriptor> getGeoServers() {
        return this.geoServers;
    }

    public DataSourceDescriptor getGeoNetwork() {
        return this.geoNetwork;
    }

    public DBDescriptor getInternalDB() {
        return this.internalDB;
    }

    public DBDescriptor getGeoDb() {
        return this.geoDb;
    }

    public DBDescriptor getPublisherDB() {
        return this.publisherDB;
    }

    public List<ComputationalInfrastructure> getInfrastructures() {
        return this.infrastructures;
    }

    public HashMap<String, String> getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public HashMap<String, String> getBackendsUrl() {
        return this.backendsUrl;
    }

    public String getPubEndpoint() {
        return this.pubEndpoint;
    }

    public GeoServerDescriptor getGeoServerByEntryPoint(String entryPoint) throws ParameterNotFoundException {
        for (GeoServerDescriptor desc : this.geoServers) {
            if (!desc.getEntryPoint().equals(entryPoint)) continue;
            return desc;
        }
        throw new ParameterNotFoundException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amEndpoint == null ? 0 : this.amEndpoint.hashCode());
        result = 31 * result + (this.backendsUrl == null ? 0 : this.backendsUrl.hashCode());
        result = 31 * result + (this.dmEndpoint == null ? 0 : this.dmEndpoint.hashCode());
        result = 31 * result + (this.geoDb == null ? 0 : this.geoDb.hashCode());
        result = 31 * result + (this.geoNetwork == null ? 0 : this.geoNetwork.hashCode());
        result = 31 * result + (this.geoServers == null ? 0 : ((Object)this.geoServers).hashCode());
        result = 31 * result + (this.infrastructures == null ? 0 : ((Object)this.infrastructures).hashCode());
        result = 31 * result + (this.internalDB == null ? 0 : this.internalDB.hashCode());
        result = 31 * result + (this.publisherDB == null ? 0 : this.publisherDB.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.serviceConfiguration == null ? 0 : this.serviceConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VODescriptor other = (VODescriptor)obj;
        if (this.amEndpoint == null ? other.amEndpoint != null : !this.amEndpoint.equals(other.amEndpoint)) {
            return false;
        }
        if (this.backendsUrl == null ? other.backendsUrl != null : !this.backendsUrl.equals(other.backendsUrl)) {
            return false;
        }
        if (this.dmEndpoint == null ? other.dmEndpoint != null : !this.dmEndpoint.equals(other.dmEndpoint)) {
            return false;
        }
        if (this.geoDb == null ? other.geoDb != null : !this.geoDb.equals(other.geoDb)) {
            return false;
        }
        if (this.geoNetwork == null ? other.geoNetwork != null : !this.geoNetwork.equals(other.geoNetwork)) {
            return false;
        }
        if (this.geoServers == null ? other.geoServers != null : !((Object)this.geoServers).equals(other.geoServers)) {
            return false;
        }
        if (this.infrastructures == null ? other.infrastructures != null : !((Object)this.infrastructures).equals(other.infrastructures)) {
            return false;
        }
        if (this.internalDB == null ? other.internalDB != null : !this.internalDB.equals(other.internalDB)) {
            return false;
        }
        if (this.publisherDB == null ? other.publisherDB != null : !this.publisherDB.equals(other.publisherDB)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.serviceConfiguration == null ? other.serviceConfiguration != null : !this.serviceConfiguration.equals(other.serviceConfiguration));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VODescriptor [scope=");
        builder.append(this.scope);
        builder.append(", dmEndpoint=");
        builder.append(this.dmEndpoint);
        builder.append(", amEndpoint=");
        builder.append(this.amEndpoint);
        builder.append(", geoServers=");
        builder.append(this.geoServers);
        builder.append(", geoNetwork=");
        builder.append(this.geoNetwork);
        builder.append(", internalDB=");
        builder.append(this.internalDB);
        builder.append(", geoDb=");
        builder.append(this.geoDb);
        builder.append(", publisherDB=");
        builder.append(this.publisherDB);
        builder.append(", infrastructures=");
        builder.append(this.infrastructures);
        builder.append(", serviceConfiguration=");
        builder.append(this.serviceConfiguration);
        builder.append(", backendsUrl=");
        builder.append(this.backendsUrl);
        builder.append("]");
        return builder.toString();
    }
}

