/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.model.importer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.application.perform.service.engine.model.DBField;

public class CSVRecordConverter {
    private Map<String, DBField> labels;
    private Map<String, Map<String, String>> mappings = new HashMap();
    private String conditionField = null;
    private Set<String> conditionValues = new HashSet();
    private boolean isAlwaysMap = false;
    private ResultSetMetaData rsMeta = null;

    public CSVRecordConverter(Map<String, DBField> labels) {
        this.labels = labels;
    }

    public Object[] convert(ResultSet rs) throws SQLException {
        if (this.rsMeta == null) {
            this.rsMeta = rs.getMetaData();
        }
        Object[] toReturn = new Object[this.rsMeta.getColumnCount()];
        if (this.mappingCondition(rs)) {
            return this.map(rs, toReturn);
        }
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = rs.getObject(i + 1);
            ++i;
        }
        return toReturn;
    }

    public void setMapping(String field, Map<String, String> mapping) {
        String actualFieldName = ((DBField)this.labels.get(field)).getFieldName();
        actualFieldName = actualFieldName.substring(1, actualFieldName.length() - 1);
        this.mappings.put(actualFieldName, mapping);
    }

    public void setCondition(String field, Set<String> values) {
        this.conditionField = ((DBField)this.labels.get(field)).getFieldName();
        this.conditionField = this.conditionField.substring(1, this.conditionField.length() - 1);
        this.conditionValues = values;
    }

    public void setAlwaysMap(boolean isAlwaysMap) {
        this.isAlwaysMap = isAlwaysMap;
    }

    public void reset() {
        this.rsMeta = null;
    }

    private boolean mappingCondition(ResultSet rs) throws SQLException {
        if (this.isAlwaysMap) {
            return true;
        }
        if (this.conditionField == null) {
            return false;
        }
        String currentValue = rs.getString(this.conditionField);
        return this.conditionValues.contains(currentValue);
    }

    private Object[] map(ResultSet rs, Object[] toReturn) throws SQLException {
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = rs.getObject(i + 1);
            String field = this.rsMeta.getColumnName(i + 1);
            if (this.mappings.containsKey(field)) {
                Map fieldMapping = (Map)this.mappings.get(field);
                String value = rs.getString(i + 1);
                if (value != null && fieldMapping.containsKey(value)) {
                    toReturn[i] = fieldMapping.get(value);
                }
            }
            ++i;
        }
        return toReturn;
    }
}

