/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.login;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.ASLGroupModel;
import org.gcube.application.framework.http.anonymousaccess.management.UsersManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginScope
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(LoginScope.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        logger.debug("Session id" + session.getId());
        String username = (String)session.getAttribute("logon.isDone");
        if (username == null) {
            response.sendError(401);
            return;
        }
        String env = request.getParameter("scope");
        if (env == null) {
            response.sendError(400, "No scope selected");
            return;
        }
        ArrayList userScopes = this.getUserScopes(username);
        if (!userScopes.contains(env)) {
            response.sendError(401, "User access denied in the selected scope");
            return;
        }
        session.setAttribute("logonScope.isDone", (Object)env);
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        mysession.setScope(env);
        response.setStatus(200);
    }

    private ArrayList<String> getUserScopes(String username) {
        ArrayList<String> userScopes = new ArrayList<String>();
        UsersManagementUtils um = new UsersManagementUtils();
        String userId = null;
        userId = um.getUserId(username);
        List groupModels = um.listGroupsByUser(userId);
        for (int i = 0; i < groupModels.size(); ++i) {
            userScopes.add(um.getScope(Long.toString(((ASLGroupModel)groupModels.get(i)).getGroupId())));
        }
        return userScopes;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

