/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.oaipmh;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.http.oaipmh.Data.Pair;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateCustom;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateDC;
import org.gcube.application.framework.oaipmh.objectmappers.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeRepository {
    private static final Logger logger = LoggerFactory.getLogger(GCubeRepository.class);

    public static Repository createRepository(String host, String email, HashMap<String, String> collections, HashMap<String, ArrayList<Pair>> browsableFields, HashMap<String, ArrayList<Pair>> presentableFields) throws MalformedURLException {
        ArrayList<String> emails = new ArrayList<String>();
        emails.add(email);
        Properties sets = new Properties();
        for (String collectionName : collections.values()) {
            sets.put(collectionName, collectionName);
        }
        RecordTemplateCustom recordTemplateCustom = new RecordTemplateCustom("gCubeRecord");
        recordTemplateCustom.addNameType("id", "0", "1", "string");
        recordTemplateCustom.addNameType("datestamp", "0", "1", "string");
        RecordTemplateDC recordTemplateDC = null;
        try {
            recordTemplateDC = new RecordTemplateDC("gcube2dc.properties");
            for (ArrayList<Pair> pList : presentableFields.values()) {
                for (Pair pair : pList) {
                    recordTemplateCustom.addNameType(pair.getName(), "0", "1", "string");
                    recordTemplateDC.addNameType(pair.getName(), "0", "1", "string");
                }
            }
        }
        catch (IOException e) {
            logger.debug("Could not find the .properties file for the DC mappings, so it will not support DC output." + e);
        }
        Repository rep = new Repository("gCube", host, emails, Calendar.getInstance().getTime(), recordTemplateDC, recordTemplateCustom, sets);
        try {
            rep.materializeXSDonFilesystem();
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
        return rep;
    }
}

