/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.sf.csv4j.CSVFieldMapProcessor;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReader;
import net.sf.csv4j.CSVSortedFieldMapProcessor;
import net.sf.csv4j.LineToFieldMapAdapter;
import net.sf.csv4j.LineToSortedFieldMapAdapter;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;

public class CSVReaderProcessor {
    private char comment = (char)35;
    private char delimiter = (char)44;
    private boolean hasHeader = true;

    public char getComment() {
        return this.comment;
    }

    public void setComment(char comment) {
        this.comment = comment;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processStream(Reader filereader, CSVLineProcessor processor) throws IOException, ProcessingException, ParseException {
        CSVReader reader = new CSVReader(filereader, this.delimiter, this.comment);
        try {
            List<String> fields;
            int lineCnt = 0;
            while (processor.continueProcessing() && (fields = reader.readLine()) != null) {
                try {
                    if (this.hasHeader && lineCnt == 0) {
                        processor.processHeaderLine(reader.getLineNumber(), fields);
                    } else {
                        processor.processDataLine(reader.getLineNumber(), fields);
                    }
                }
                catch (Exception e) {
                    throw new ProcessingException(e, reader.getLineNumber());
                }
                ++lineCnt;
            }
            int n = lineCnt;
            return n;
        }
        finally {
            reader.close();
        }
    }

    public int processStream(Reader filereader, CSVFieldMapProcessor processor) throws IOException, ProcessingException, ParseException {
        this.hasHeader = true;
        return this.processStream(filereader, new LineToFieldMapAdapter(processor));
    }

    public int processStream(Reader filereader, CSVSortedFieldMapProcessor processor) throws IOException, ProcessingException, ParseException {
        this.hasHeader = true;
        return this.processStream(filereader, new LineToSortedFieldMapAdapter(processor));
    }
}

