/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.eolusclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import net.java.dev.jaxb.array.StringArray;
import org.apache.axis.client.Stub;
import org.gcube.common.eolusclient.DirectoryException;
import org.gcube.common.eolusclient.Eolus;
import org.gcube.common.eolusclient.EolusServiceLocator;
import org.gcube.common.eolusclient.InternalErrorException;
import org.gcube.common.eolusclient.MultipleTemplatesException;
import org.gcube.common.eolusclient.ReservedUserException;
import org.gcube.common.eolusclient.TemplateNotReadyException;
import org.gcube.common.eolusclient.UnknownScriptException;
import org.gcube.common.eolusclient.UnknownTemplateException;
import org.gcube.common.eolusclient.UnknownUserException;
import org.gcube.common.eolusclient.UnknownVMException;
import org.gcube.common.eolusclient.UnknownVNException;
import org.gcube.common.eolusclient.VMContactErrorException;
import org.gcube.common.eolusclient.VMExistsException;
import org.gcube.common.eolusclient.VNExistsException;

public class CLIClient {
    public static void main(String[] stringArray) throws MalformedURLException, ServiceException {
        String string = "http://n18.di.uoa.gr:8080/Madgik/Eolus?wsdl";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        URL uRL = new URL(string);
        EolusServiceLocator eolusServiceLocator = new EolusServiceLocator();
        Eolus eolus = eolusServiceLocator.getEolusPort();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = "";
            System.out.print("Username: ");
            String string3 = bufferedReader.readLine();
            System.out.print("Password: ");
            String string4 = bufferedReader.readLine();
            ((Stub)eolus)._setProperty("javax.xml.rpc.security.auth.username", (Object)string3);
            ((Stub)eolus)._setProperty("javax.xml.rpc.security.auth.password", (Object)string4);
            while (!string2.equalsIgnoreCase("q")) {
                System.out.print("\nQ) Quit\nUSER MANAGEMENT\n1) Read users\t2) Create user\t3) Remove user\nTEMPLATE MANAGEMENT\n4) List my templates\t5) List public templates\n6) Copy my template\t7) Move my template\n8) Remove my template\t9) Remove any user template (acting as admin)\n10) Make my template public\t11) Remove public template (acting as admin)\n12) Sync my templates with repository \nSCRIPT MANAGEMENT\n13) List my scripts\t14) Add script\t15) Get script description\n16) Remove script\t17) Remove any user script (acting as admin)\t18) Sync my scripts with repository\nVM MANAGEMENT\n19) Create new VM\t20) Shutdown VM\t21) Pause VM\t22) Resume VM\n23) Get VM IP\t24) Get VM Status\t25) Get VM Info\t26) List my VMs\n27) Shutdown any user VM (as admin)\t28) Pause any user VM (as admin)\t29) Resume any user VM (as admin)\n30) Get any user VM IP (as admin)\t31) Get any user VM Status (as admin)\t32) Get any user VM Info (as admin)\n33) List all VMs (as admin)\t34) List stray VMs\t35) Assign VM to user (as admin)\n36) Make template from VM\t37) Run cmd on VM\t38) Run script on VM\nHOST MANAGEMENT\n39) List hosts\t40) Get host info\t41) Enable host\n42) Disable host\t43) Delete host\t44) Create host\n45) VM migrate\nNETWORK MANAGEMENT\n46) List all Networks (as admin)\t47) List user Networks (as admin)\t48) List my Networks\n49) Create Network\t50) Create public Network (as admin)\n51) Assign Network to User\n52) Remove Network\t53) Remove Network (as admin)\n54) Info of Network\t55) Info of Network (as admin)\nCONFIGURATION\n56) Change config parameter\n");
                string2 = bufferedReader.readLine();
                CLIClient.process(eolus, bufferedReader, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void process(Eolus eolus, BufferedReader bufferedReader, String string) throws IOException {
        String[] stringArray;
        int n;
        Object object;
        if (string.equalsIgnoreCase("1")) {
            object = eolus.getUsers().getItem();
            System.out.println("Total users: " + ((String[])object).length);
            for (n = 0; n < ((String[])object).length; ++n) {
                System.out.println(object[n]);
            }
        }
        if (string.equalsIgnoreCase("2")) {
            System.out.print("New username: ");
            object = bufferedReader.readLine();
            try {
                eolus.addUser((String)object);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (ReservedUserException reservedUserException) {
                reservedUserException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("3")) {
            System.out.print("Username of user to delete: ");
            object = bufferedReader.readLine();
            try {
                eolus.deleteUser((String)object);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (ReservedUserException reservedUserException) {
                reservedUserException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("4")) {
            object = eolus.getTemplates().getItem();
            System.out.println("Total number of templates: " + ((String[])object).length);
            for (n = 0; n < ((String[])object).length; ++n) {
                stringArray = "";
                try {
                    stringArray = eolus.getTemplateStatus(object[n]);
                }
                catch (MultipleTemplatesException multipleTemplatesException) {
                    multipleTemplatesException.printStackTrace();
                }
                catch (UnknownTemplateException unknownTemplateException) {
                    unknownTemplateException.printStackTrace();
                }
                System.out.println(object[n] + "(" + (String)stringArray + ")");
            }
        }
        if (string.equalsIgnoreCase("5")) {
            object = eolus.getPublicTemplates().getItem();
            System.out.println("Total number of public templates: " + ((String[])object).length);
            for (n = 0; n < ((String[])object).length; ++n) {
                System.out.println(object[n]);
            }
        }
        if (string.equalsIgnoreCase("6")) {
            System.out.print("Template to copy: ");
            object = bufferedReader.readLine();
            System.out.print("New template name: ");
            String string2 = bufferedReader.readLine();
            try {
                eolus.transferTemplate((String)object, string2, false);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("7")) {
            System.out.print("Template to move: ");
            object = bufferedReader.readLine();
            System.out.print("New template name: ");
            String string3 = bufferedReader.readLine();
            try {
                eolus.transferTemplate((String)object, string3, true);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("8")) {
            System.out.print("Template to remove: ");
            object = bufferedReader.readLine();
            try {
                eolus.removeTemplate((String)object);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (MultipleTemplatesException multipleTemplatesException) {
                multipleTemplatesException.printStackTrace();
            }
            catch (TemplateNotReadyException templateNotReadyException) {
                templateNotReadyException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("9")) {
            System.out.print("Username of user who owns the template: ");
            object = bufferedReader.readLine();
            System.out.print("Template to remove: ");
            String string4 = bufferedReader.readLine();
            try {
                eolus.adminRemoveTemplate((String)object, string4);
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
                System.out.println("OK");
            }
            catch (MultipleTemplatesException multipleTemplatesException) {
                multipleTemplatesException.printStackTrace();
            }
            catch (TemplateNotReadyException templateNotReadyException) {
                templateNotReadyException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("10")) {
            System.out.print("Template to publish: ");
            object = bufferedReader.readLine();
            System.out.print("New template name: ");
            String string5 = bufferedReader.readLine();
            try {
                eolus.makeTemplatePublic((String)object, string5);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (MultipleTemplatesException multipleTemplatesException) {
                multipleTemplatesException.printStackTrace();
            }
            catch (TemplateNotReadyException templateNotReadyException) {
                templateNotReadyException.printStackTrace();
            }
            catch (UnknownTemplateException unknownTemplateException) {
                unknownTemplateException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("11")) {
            System.out.print("Template to publish: ");
            object = bufferedReader.readLine();
            System.out.print("New template name: ");
            try {
                eolus.adminRemovePublicTemplate((String)object);
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
                System.out.println("OK");
            }
            catch (MultipleTemplatesException multipleTemplatesException) {
                multipleTemplatesException.printStackTrace();
            }
            catch (TemplateNotReadyException templateNotReadyException) {
                templateNotReadyException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("12")) {
            try {
                eolus.syncTemplates();
                System.out.println("OK");
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("13")) {
            object = eolus.getScriptList().getItem();
            System.out.println("Total number of scripts: " + ((String[])object).length);
            for (int i = 0; i < ((String[])object).length; ++i) {
                System.out.println(object[i]);
            }
        }
        if (string.equalsIgnoreCase("14")) {
            System.out.print("Name of script: ");
            object = bufferedReader.readLine();
            System.out.print("Script content: ");
            String string6 = bufferedReader.readLine();
            System.out.print("Script description: ");
            stringArray = bufferedReader.readLine();
            try {
                eolus.addScript((String)object, string6, (String)stringArray);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("15")) {
            System.out.print("Name of script: ");
            object = bufferedReader.readLine();
            String string7 = "";
            try {
                string7 = eolus.getDescription((String)object);
            }
            catch (UnknownScriptException unknownScriptException) {
                unknownScriptException.printStackTrace();
            }
            System.out.println("Description: " + string7);
        }
        if (string.equalsIgnoreCase("16")) {
            System.out.print("Name of script: ");
            object = bufferedReader.readLine();
            try {
                eolus.removeScript((String)object);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (UnknownScriptException unknownScriptException) {
                unknownScriptException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("17")) {
            System.out.print("Username of user who owns the script: ");
            object = bufferedReader.readLine();
            System.out.print("Name of script: ");
            String string8 = bufferedReader.readLine();
            try {
                eolus.adminRemoveScript((String)object, string8);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (UnknownScriptException unknownScriptException) {
                unknownScriptException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("18")) {
            try {
                eolus.syncScripts();
                System.out.println("OK");
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("19")) {
            System.out.print("Template of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Name of VM: ");
            String string9 = bufferedReader.readLine();
            stringArray = new String[]{"public"};
            StringArray stringArray2 = new StringArray();
            stringArray2.setItem(stringArray);
            try {
                eolus.createVM((String)object, string9, 2, 512, stringArray2);
                System.out.println("OK");
            }
            catch (DirectoryException directoryException) {
                directoryException.printStackTrace();
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (TemplateNotReadyException templateNotReadyException) {
                templateNotReadyException.printStackTrace();
            }
            catch (UnknownTemplateException unknownTemplateException) {
                unknownTemplateException.printStackTrace();
            }
            catch (VMExistsException vMExistsException) {
                vMExistsException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("20")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Force shutdown (Y/N): ");
            String string10 = bufferedReader.readLine();
            if (string10.equalsIgnoreCase("Y")) {
                try {
                    eolus.shutdownVM((String)object, true);
                    System.out.println("OK");
                }
                catch (InternalErrorException internalErrorException) {
                    internalErrorException.printStackTrace();
                }
                catch (UnknownUserException unknownUserException) {
                    unknownUserException.printStackTrace();
                }
                catch (UnknownVMException unknownVMException) {
                    unknownVMException.printStackTrace();
                }
            } else {
                try {
                    eolus.shutdownVM((String)object, false);
                    System.out.println("OK");
                }
                catch (InternalErrorException internalErrorException) {
                    internalErrorException.printStackTrace();
                }
                catch (UnknownUserException unknownUserException) {
                    unknownUserException.printStackTrace();
                }
                catch (UnknownVMException unknownVMException) {
                    unknownVMException.printStackTrace();
                }
            }
        }
        if (string.equalsIgnoreCase("21")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                eolus.suspendVM((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("22")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                eolus.resumeVM((String)object);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
                System.out.println("OK");
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("23")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string11 = eolus.getVMIP((String)object);
                System.out.println(string11);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("24")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string12 = eolus.getVMStatus((String)object);
                System.out.println(string12);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("25")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string13 = eolus.getVMInfo((String)object);
                System.out.println(string13);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("26")) {
            try {
                object = eolus.getVMlist().getItem();
                System.out.println("Total number of VMs: " + ((String[])object).length);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("27")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Force shutdown (Y/N): ");
            String string14 = bufferedReader.readLine();
            if (string14.equalsIgnoreCase("Y")) {
                try {
                    eolus.adminShutdownVM((String)object, true);
                    System.out.println("OK");
                }
                catch (InternalErrorException internalErrorException) {
                    internalErrorException.printStackTrace();
                }
                catch (UnknownVMException unknownVMException) {
                    unknownVMException.printStackTrace();
                }
            } else {
                try {
                    eolus.adminShutdownVM((String)object, false);
                    System.out.println("OK");
                }
                catch (InternalErrorException internalErrorException) {
                    internalErrorException.printStackTrace();
                }
                catch (UnknownVMException unknownVMException) {
                    unknownVMException.printStackTrace();
                }
            }
        }
        if (string.equalsIgnoreCase("28")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                eolus.adminSuspendVM((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("29")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                eolus.adminResumeVM((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("30")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string15 = eolus.adminGetVMIP((String)object);
                System.out.println(string15);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("31")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string16 = eolus.adminGetVMStatus((String)object);
                System.out.println(string16);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("32")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            try {
                String string17 = eolus.adminGetVMInfo((String)object);
                System.out.println(string17);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("33")) {
            try {
                object = eolus.adminGetVMlist().getItem();
                System.out.println("Total number of VMs: " + ((String[])object).length);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("34")) {
            try {
                object = eolus.adminGetStrayVMlist().getItem();
                System.out.println("Total number of VMs: " + ((String[])object).length);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("35")) {
            System.out.print("Username of user who owns the VM: ");
            object = bufferedReader.readLine();
            System.out.print("Name of VM: ");
            String string18 = bufferedReader.readLine();
            try {
                eolus.adminAssignVMtoUser((String)object, string18);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("36")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Name of template: ");
            String string19 = bufferedReader.readLine();
            boolean bl = eolus.VMtoTemplate((String)object, string19);
            if (bl) {
                System.out.println("OK");
            } else {
                System.out.println("VM templetize failed");
            }
        }
        if (string.equalsIgnoreCase("37")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Command: ");
            String string20 = bufferedReader.readLine();
            try {
                String[] stringArray3 = eolus.execCMD(string20, (String)object).getItem();
                if (stringArray3.length > 1) {
                    System.out.println("Stdout: " + stringArray3[0]);
                }
                if (stringArray3.length > 2) {
                    System.out.println("Stderr: " + stringArray3[1]);
                }
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
            catch (VMContactErrorException vMContactErrorException) {
                vMContactErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("38")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Script name: ");
            String string21 = bufferedReader.readLine();
            try {
                eolus.applyScript(string21, (String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
            catch (VMContactErrorException vMContactErrorException) {
                vMContactErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("39")) {
            try {
                object = eolus.getHostList().getItem();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("40")) {
            System.out.print("Name of host: ");
            object = bufferedReader.readLine();
            try {
                String string22 = eolus.getHostInfo((String)object);
                System.out.println(string22);
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("41")) {
            System.out.print("Name of host: ");
            object = bufferedReader.readLine();
            try {
                eolus.enableHost((String)object, true);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("42")) {
            System.out.print("Name of host: ");
            object = bufferedReader.readLine();
            try {
                eolus.enableHost((String)object, false);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("43")) {
            System.out.print("Name of host: ");
            object = bufferedReader.readLine();
            try {
                eolus.deleteHost((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("44")) {
            System.out.print("Name of host: ");
            object = bufferedReader.readLine();
            try {
                eolus.createHost((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("45")) {
            System.out.print("Name of VM: ");
            object = bufferedReader.readLine();
            System.out.print("Name of host: ");
            String string23 = bufferedReader.readLine();
            try {
                eolus.migrateVM((String)object, string23);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVMException unknownVMException) {
                unknownVMException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("46")) {
            try {
                object = eolus.adminGetAllVNetList().getItem();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("47")) {
            System.out.print("Name of user: ");
            object = bufferedReader.readLine();
            try {
                String[] stringArray4 = eolus.adminGetVNetList((String)object).getItem();
                for (int i = 0; i < stringArray4.length; ++i) {
                    System.out.println(stringArray4[i]);
                }
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("48")) {
            try {
                object = eolus.getVNetList().getItem();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    System.out.println(object[i]);
                }
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("49")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            System.out.print("Subnet: ");
            String string24 = bufferedReader.readLine();
            try {
                eolus.createVNet((String)object, Integer.parseInt(string24));
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (VNExistsException vNExistsException) {
                vNExistsException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("50")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            System.out.print("Subnet: ");
            String string25 = bufferedReader.readLine();
            try {
                eolus.adminCreateVNet((String)object, Integer.parseInt(string25));
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (VNExistsException vNExistsException) {
                vNExistsException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("51")) {
            System.out.print("Name of user: ");
            object = bufferedReader.readLine();
            System.out.print("Name of VNet: ");
            String string26 = bufferedReader.readLine();
            try {
                eolus.adminAssignVNettoUser((String)object, string26);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVNException unknownVNException) {
                unknownVNException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("52")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            try {
                eolus.removeVNet((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
            catch (UnknownVNException unknownVNException) {
                unknownVNException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("53")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            try {
                eolus.adminRemoveVNet((String)object);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVNException unknownVNException) {
                unknownVNException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("54")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            try {
                String string27 = eolus.getVNetInfo((String)object);
                System.out.println(string27);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVNException unknownVNException) {
                unknownVNException.printStackTrace();
            }
            catch (UnknownUserException unknownUserException) {
                unknownUserException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("55")) {
            System.out.print("Name of VNet: ");
            object = bufferedReader.readLine();
            try {
                String string28 = eolus.adminGetVNetInfo((String)object);
                System.out.println(string28);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
            catch (UnknownVNException unknownVNException) {
                unknownVNException.printStackTrace();
            }
        }
        if (string.equalsIgnoreCase("56")) {
            System.out.print("Parameter key: ");
            object = bufferedReader.readLine();
            System.out.print("Parameter value: ");
            String string29 = bufferedReader.readLine();
            try {
                eolus.setConfigurationParameter((String)object, string29);
                System.out.println("OK");
            }
            catch (InternalErrorException internalErrorException) {
                internalErrorException.printStackTrace();
            }
        }
    }
}

