/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.collections;

import org.exist.xmldb.XQueryService;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.common.xml.databases.existlibrary.MOStringHelper;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.CollectionImpl;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;

public class ExecuteXQueryRSThread {
    static GCUBELog logger = new GCUBELog(ExecuteXQueryRSThread.class);
    private RSXMLWriter writer;
    private String XQuery;
    private CollectionImpl collection;

    public ExecuteXQueryRSThread(RSXMLWriter writer, String XQuery, CollectionImpl collection) {
        this.writer = writer;
        this.XQuery = XQuery;
        this.collection = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.executeXPath(this.collection, this.XQuery);
        }
        catch (Exception dbe) {
            logger.error((Object)"Error Retreiving documents", (Throwable)dbe);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                logger.error((Object)"Error Closing ResultSet Writer", (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        logger.debug((Object)("XQuery Execution keeped: " + (end - start) + " ms"));
    }

    private void executeXPath(Collection col, String xPath) throws Exception {
        CollectionImpl tmpCollection = (CollectionImpl)col;
        if (col.getChildCollectionCount() == 0) {
            XQueryService service = (XQueryService)tmpCollection.getService("XQueryService", "1.0");
            ResourceSet resources = service.query(this.XQuery);
            if (resources.getSize() > 0L) {
                ResourceIterator res = resources.getIterator();
                while (res.hasMoreResources()) {
                    XMLResource r = (XMLResource)res.nextResource();
                    MOStringHelper moHelper = new MOStringHelper((String)r.getResource().getContent());
                    this.writer.addResults((ResultElementBase)new ResultElementGeneric(moHelper.getTargetID(), moHelper.getCollectionID(), moHelper.getMetadata()));
                }
            }
            tmpCollection.close();
        } else {
            CollectionImpl po = tmpCollection;
            for (String singleCol : po.getChildsCollection()) {
                if (singleCol.compareTo("system") == 0 || singleCol.compareTo("config") == 0) continue;
                this.executeXPath(po.getChildCollection(singleCol), xPath);
            }
        }
    }
}

