/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary;

import java.io.File;
import org.exist.xmldb.DatabaseInstanceManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.xml.databases.existlibrary.PooledConnection;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.CollectionImpl;
import org.gcube.common.xml.databases.existlibrary.collections.SimpleCollection;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class PooledConnectionImpl
implements PooledConnection {
    GCUBELog logger = new GCUBELog(PooledConnectionImpl.class);
    protected static String URI = "xmldb:exist://";
    protected static String driverDB = "org.exist.xmldb.DatabaseImpl";
    protected static String exist_home = System.getenv("EXIST_HOME");
    protected CollectionImpl rootCollection = null;

    public PooledConnectionImpl() throws PooledConnection.NoConnectionAvailableException {
        this.connect();
    }

    protected boolean connect() throws PooledConnection.NoConnectionAvailableException {
        Database database = null;
        try {
            Class<?> cl = Class.forName(driverDB);
            database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            this.logger.trace((Object)exist_home);
            database.setProperty("configuration", exist_home + File.separator + "conf.xml");
            DatabaseManager.registerDatabase((Database)database);
            this.logger.trace((Object)(URI + "/db"));
            this.rootCollection = new SimpleCollection("/db", DatabaseManager.getCollection((String)(URI + "/db"), (String)"admin", (String)"admin"));
            if (this.rootCollection == null) {
                this.logger.debug((Object)"the root collection is null");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new PooledConnection.NoConnectionAvailableException();
        }
        return true;
    }

    protected void shutDown() {
        try {
            DatabaseInstanceManager manager = (DatabaseInstanceManager)DatabaseManager.getCollection((String)(URI + "/db"), (String)"admin", (String)"admin").getService("DatabaseInstanceManager", "1.0");
            manager.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Collection getRootCollection() throws Collection.CollectionException {
        return this.rootCollection;
    }

    protected void release() throws PooledConnection.NoConnectionAvailableException {
        try {
            this.rootCollection.close();
            this.shutDown();
            this.connect();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new PooledConnection.NoConnectionAvailableException();
        }
    }

    @Override
    public void repairConnection() throws PooledConnection.NoConnectionAvailableException {
        this.release();
    }

    @Override
    public XMLResource createXMLResource(String name, Object content) throws Collection.CollectionException {
        XMLResource res;
        try {
            res = this.rootCollection.createResource(name, content, "XMLResource");
        }
        catch (XMLDBException e) {
            throw new Collection.CollectionException();
        }
        return res;
    }
}

