/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRProperties
implements Properties {
    private static Logger logger = LoggerFactory.getLogger(JCRProperties.class);
    private Map<String, String> map;
    private ItemDelegate itemDelegate;
    private String portalLogin;

    public JCRProperties(ItemDelegate itemDelegate, String portalLogin) throws RepositoryException, InternalErrorException {
        this.portalLogin = portalLogin;
        this.itemDelegate = itemDelegate;
        this.map = itemDelegate.getMetadata();
        if (this.map == null) {
            this.map = new HashMap<String, String>();
        }
    }

    public String getId() throws InternalErrorException {
        return this.itemDelegate.getId();
    }

    public String getPropertyValue(String propertyName) throws InternalErrorException {
        return this.map.get(propertyName);
    }

    public Map<String, String> getProperties() throws InternalErrorException {
        return this.map;
    }

    public void addProperty(String name, String value) throws InternalErrorException {
        Validate.notNull((Object)name, (String)"Name property must be not null");
        Validate.notNull((Object)value, (String)"Value property must be not null");
        try {
            String escapeName = Text.escapeIllegalJcrChars((String)name);
            this.map.put(escapeName, value);
            this.update();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.portalLogin);
            this.itemDelegate.setMetadata(this.map);
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            logger.error("Error updating properties ", (Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }
}

