/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.File;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFile
implements File {
    private static Logger logger = LoggerFactory.getLogger(JCRFile.class);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    public static final String STORAGE_PATH = "hl:storagePath";
    public MetaInfo info;
    String portalLogin;
    ItemDelegate itemDelegate;
    GCUBEStorage storage;
    MetaInfo meta;

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException {
        this.itemDelegate = itemDelegate;
        this.storage = workspace.getStorage();
        this.portalLogin = workspace.getOwner().getPortalLogin();
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, InputStream is) throws InternalErrorException, IOException, RemoteBackendException {
        String remotePath = (String)itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
        MetaInfo info = WorkspaceItemUtil.getMetadataInfo(is, this.storage, remotePath, itemDelegate.getTitle());
        this.setMeta(workspace, itemDelegate, remotePath, info);
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String remotePath, MetaInfo info) throws InternalErrorException {
        this.setMeta(workspace, itemDelegate, remotePath, info);
    }

    private void setMeta(JCRWorkspace workspace, ItemDelegate itemDelegate, String remotePath, MetaInfo info) {
        this.itemDelegate = itemDelegate;
        this.storage = workspace.getStorage();
        this.portalLogin = workspace.getOwner().getPortalLogin();
        this.meta = info;
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.PORTAL_LOGIN, workspace.getOwner().getPortalLogin());
        content.put(NodeProperty.MIME_TYPE, info.getMimeType());
        Long l = Long.valueOf(String.valueOf(info.getSize()));
        content.put(NodeProperty.SIZE, new XStream().toXML((Object)l));
        content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
        itemDelegate.setContent(content);
        logger.trace("GCUBEStorage ID : " + info.getStorageId());
    }

    public String getName() throws InternalErrorException {
        return this.itemDelegate.getTitle();
    }

    public String getMimeType() {
        String mimeType = null;
        try {
            mimeType = (String)this.itemDelegate.getContent().get(NodeProperty.MIME_TYPE);
        }
        catch (Exception e) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        String remotePath = null;
        InputStream stream = null;
        try {
            try {
                remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            }
            catch (Exception e) {
                logger.trace("Remote Path not found");
            }
            if (remotePath != null) {
                logger.trace("Retrieving streaming from Storage...");
                try {
                    stream = this.getStorage().getRemoteFile(remotePath);
                }
                catch (Exception e) {
                    logger.error("no payload for " + this.getName());
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return stream;
    }

    public long getLength() throws InternalErrorException {
        long size = 0L;
        try {
            size = (Long)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.SIZE));
        }
        catch (Exception e) {
            logger.error(this.itemDelegate.getTitle() + " has not size property");
            size = this.storage.getRemoteFileSize(this.getRemotePath());
            this.setLenght(size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLenght(long size) {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.portalLogin);
            this.itemDelegate.getContent().put(NodeProperty.SIZE, new XStream().toXML((Object)size));
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            logger.error("Impossible to set lenght for " + this.itemDelegate.getPath());
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public String getPublicLink() throws InternalErrorException {
        try {
            String remotePath = this.getRemotePath();
            return this.getStorage().getPublicLink(remotePath);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private String getRemotePath() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return remotePath;
    }

    public void getHardLink(String destPath) throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            logger.trace("No public link for file: " + this.itemDelegate.getTitle());
            this.getStorage().createHardLink(remotePath, destPath);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected GCUBEStorage getStorage() {
        return this.storage;
    }

    public void updateInfo(JCRServlets servlets, MetaInfo info) throws InternalErrorException {
        String mimeType = info.getMimeType();
        long size = info.getSize();
        try {
            this.itemDelegate.getContent().put(NodeProperty.MIME_TYPE, mimeType);
            this.itemDelegate.getContent().put(NodeProperty.SIZE, new XStream().toXML((Object)size));
            servlets.saveItem(this.itemDelegate);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

