/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRLockManager {
    private String urlRepository;
    private Logger logger = LoggerFactory.getLogger(JCRLockManager.class);
    private String login;
    private String sessionId;

    public JCRLockManager(String login, String sessionId) {
        this.urlRepository = JCRRepository.url;
        this.login = login;
        this.sessionId = sessionId;
    }

    public void lockItem(String id) throws InternalErrorException {
        this.logger.info("Calling Servlet Lock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/get/LockSession?" + JCRRepository.getCredentials() + "&login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public void unlockItem(String id) throws InternalErrorException {
        this.logger.info("Calling Servlet UnLock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.urlRepository + "/get/UnlockSession?" + JCRRepository.getCredentials() + "&login=" + this.login + "&id=" + id + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public boolean isLocked(String id) throws InternalErrorException {
        this.logger.info("Calling Servlet isLock Node with id " + id + " by " + this.login);
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        boolean isLocked = false;
        try {
            getMethod = new GetMethod(this.urlRepository + "/get/IsLocked?" + JCRRepository.getCredentials() + "&login=" + this.login + "&id=" + id);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            isLocked = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.toString());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return isLocked;
    }
}

