/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.PathNotFoundException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.GenericItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceInternalLink;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceVREFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItemByOperator;
import org.gcube.common.homelibrary.home.workspace.search.util.SearchQuery;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceInternalLink;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSmartFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceVREFolder;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRGCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashFolder;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.Util;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspace
extends AbstractWorkspaceEventSource
implements Workspace {
    public static final String HOME_FOLDER = "Home";
    private static final String WORKSPACE_ROOT_FOLDER = "Workspace";
    private static final String APPLICATION_FOLDER = ".applications";
    private static final String TRASH = "Trash";
    private static final String SPECIAL_FOLDER = "MySpecialFolders";
    private static final String PREFIX_SHARE = "/Share/";
    private static final String PREFIX = "home/org.gcube.portlets.user/";
    private final Home home;
    public final JCRRepository repository;
    private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;
    private JCRWorkspaceMessageManager sendRequestManager;
    public String userWorkspace;
    private String userHome;
    public String trashPath;
    public String applicationFolderPath;
    public String mySpecialFoldersPath;
    private String portalLogin;
    private Logger logger;
    private GCUBEStorage storage = null;
    private JCRWorkspaceFolder root;

    public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {
        this.home = home;
        this.portalLogin = this.getOwner().getPortalLogin();
        this.userHome = "/Home/" + this.portalLogin;
        this.userWorkspace = this.userHome + "/" + WORKSPACE_ROOT_FOLDER + "/";
        this.applicationFolderPath = this.userWorkspace + APPLICATION_FOLDER;
        this.trashPath = this.userWorkspace + TRASH;
        this.mySpecialFoldersPath = this.userWorkspace + SPECIAL_FOLDER;
        this.repository = repository;
        this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);
        this.logger = LoggerFactory.getLogger(JCRWorkspace.class);
        try {
            this.init(this.portalLogin);
        }
        catch (RepositoryException e1) {
            this.logger.error("Error init ", (Throwable)e1);
        }
        catch (ItemNotFoundException e) {
            this.logger.error("Error init workspace ", (Throwable)e);
        }
        catch (PathNotFoundException e) {
            this.logger.error("Error init ", (Throwable)e);
        }
    }

    public GCUBEStorage getStorage() {
        if (this.storage == null) {
            try {
                this.storage = new GCUBEStorage(this.portalLogin);
            }
            catch (Exception e) {
                this.logger.error("Error getting Storage ", (Throwable)e);
            }
        }
        return this.storage;
    }

    public JCRWorkspace(JCRHome home) {
        this.home = home;
        this.repository = null;
        this.folderBulkCreatorsManager = null;
    }

    private ItemDelegate addChildNode(String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error("The name  " + nodeName + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate parent = session.getItemById(parentId);
            JCRWorkspaceItem item = this.getWorkspaceItem(parent);
            if (item.isShared() && !JCRPrivilegesInfo.canAddChildren(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
            }
            if (!(parent.getPrimaryType().equals("nthl:workspaceItem") || parent.getPrimaryType().equals("nthl:workspaceSharedItem") || parent.getPrimaryType().equals("nt:folder"))) {
                throw new WrongDestinationException("Not is a folder");
            }
            try {
                ItemDelegate node;
                DelegateManager wrap = new DelegateManager(parent, this.getOwner().getPortalLogin());
                ItemDelegate itemDelegate = node = wrap.addNode(nodeName, nodeType);
                return itemDelegate;
            }
            catch (Exception e) {
                try {
                    this.logger.error("Error ", (Throwable)e);
                    throw new InternalErrorException((Throwable)e);
                }
                catch (ItemNotFoundException | RepositoryException e2) {
                    this.logger.error("Destination folder not found");
                    throw new WorkspaceFolderNotFoundException(e2.getMessage());
                }
            }
        }
        finally {
            session.releaseSession();
        }
    }

    private ItemDelegate createItemDelegate(JCRSession session, ItemDelegate parent, String name, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        if (!this.isValidName(name)) {
            this.logger.error("The name  " + name + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        if (parent.isShared() && !JCRPrivilegesInfo.canAddChildren(parent.getOwner(), this.getOwner().getPortalLogin(), parent.getPath())) {
            throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
        }
        if (!(parent.getPrimaryType().equals("nthl:workspaceItem") || parent.getPrimaryType().equals("nthl:workspaceSharedItem") || parent.getPrimaryType().equals("nt:folder"))) {
            throw new WrongDestinationException("Not is a folder");
        }
        try {
            DelegateManager wrap = new DelegateManager(parent, this.getOwner().getPortalLogin());
            ItemDelegate delegate = wrap.addNode(name, nodeType);
            delegate.setPath(parent.getPath() + "/" + name);
            return delegate;
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
    }

    private ItemDelegate createItemDelegate(JCRSession session, String parentId, String name, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        ItemDelegate parent = null;
        try {
            parent = session.getItemById(parentId);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(e.getMessage());
        }
        return this.createItemDelegate(session, parent, name, nodeType);
    }

    public String getPathSeparator() {
        return "/";
    }

    public Home getHome() {
        return this.home;
    }

    public JCRRepository getRepository() {
        return this.repository;
    }

    public User getOwner() {
        return this.home.getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceFolder getRoot() {
        this.logger.info("Getting Workspace of user: " + this.getOwner().getPortalLogin());
        if (this.root != null) {
            return this.root;
        }
        ItemDelegate wsNode = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            wsNode = session.getItemByPath(this.userWorkspace);
            this.root = new JCRWorkspaceFolder(this, wsNode);
        }
        catch (Exception e) {
            this.logger.info("Root WorkspaceFolder not found. It will be created");
            try {
                ItemDelegate userHome = session.getItemByPath("/Home/" + this.portalLogin);
                DelegateManager userHomeManager = new DelegateManager(userHome, this.getOwner().getPortalLogin());
                wsNode = userHomeManager.addNode(WORKSPACE_ROOT_FOLDER, "nthl:workspaceItem");
                this.root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
                wsNode = this.root.save();
                this.logger.info(wsNode.getPath() + " created");
            }
            catch (ItemNotFoundException | RepositoryException e1) {
                this.logger.error("Root WorkspaceFolder not found, " + e);
            }
        }
        finally {
            session.releaseSession();
        }
        return this.root;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        return this.createFolder(name, description, destinationFolderId, null);
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        return this.createExternalImage(name, description, mimeType, imageData, destinationFolderId, null);
    }

    public ExternalImage createExternalImage(String name, String description, MetaInfo info, ItemDelegate parent, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external image");
        JCRExternalImage item = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate delegate = this.createItemDelegate(session, parent, name, "nthl:externalImage");
            item = new JCRExternalImage(this, delegate, name, description, info, properties);
            item.save();
            this.setAccountingOnParent(session, delegate, item);
            this.fireItemCreatedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return item;
    }

    public ExternalFile createExternalFile(String name, String description, MetaInfo info, ItemDelegate parent, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external file");
        JCRExternalFile item = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate delegate = this.createItemDelegate(session, parent, name, "nthl:externalFile");
            item = new JCRExternalFile(this, delegate, name, description, info, properties);
            item.save();
            this.setAccountingOnParent(session, delegate, item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return item;
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        return this.createExternalFile(name, description, mimeType, fileData, destinationFolderId, null);
    }

    private void setAccountingOnParent(JCRSession session, ItemDelegate delegate, JCRExternalFile file) throws InternalErrorException, RepositoryException {
        try {
            this.logger.debug("Save accounting on parent of " + delegate.getPath());
            JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(delegate.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), file.getType(), file.getType() == WorkspaceItemType.FOLDER_ITEM ? file.getFolderItemType() : null, file.getName(), file.getType() == WorkspaceItemType.FOLDER_ITEM ? file.getMimeType() : null);
            entry.save(session);
        }
        catch (Exception e) {
            this.logger.info("Error setting add accounting entry for " + delegate.getPath() + " to parent folder");
        }
        this.fireItemCreatedEvent(file);
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream pdfData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        return this.createExternalPDFFile(name, description, mimeType, pdfData, destinationFolderId, null);
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, MetaInfo info, ItemDelegate parent, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external pdf file");
        JCRExternalPDFFile item = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate node = this.createItemDelegate(session, parent, name, "nthl:externalPdf");
            item = new JCRExternalPDFFile(this, node, name, description, info, properties);
            item.save();
            this.setAccountingOnParent(session, node, item);
            this.fireItemCreatedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return item;
    }

    public ExternalUrl createExternalUrl(String name, String description, String url, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external url");
        JCRExternalUrl item = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate parent = session.getItemById(destinationFolderId);
            ItemDelegate node = this.createItemDelegate(session, parent, name, "nthl:externalUrl");
            item = new JCRExternalUrl(this, node, name, description, url);
            item.save();
            this.fireItemCreatedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return item;
    }

    public ExternalUrl createExternalUrl(String name, String description, InputStream url, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String urlString;
        try {
            urlString = Util.readStreamAsString((InputStream)url);
        }
        catch (IOException e) {
            throw new InternalErrorException("Error converting url from input stream to string.");
        }
        return this.createExternalUrl(name, description, urlString, destinationFolderId);
    }

    public void removeItem(String itemId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        ItemDelegate itemDelegate = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            itemDelegate = session.getItemById(itemId);
            this.logger.trace("Remove node " + itemDelegate.getPath());
            JCRWorkspaceItem item = this.getWorkspaceItem(itemDelegate);
            item.remove();
            this.fireItemRemovedEvent(item);
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public Map<String, String> removeItems(String ... ids) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)ids, (String)"Item id must be not null");
        ArrayList<String> list = new ArrayList<String>();
        ItemDelegate itemDelegate = null;
        JCRSession session = null;
        Map<String, String> error = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            WorkspaceTrashFolder trash = this.getTrash();
            for (String itemId : ids) {
                list.add(itemId);
                itemDelegate = session.getItemById(itemId);
                this.logger.trace("Move to trash node " + itemDelegate.getPath());
                JCRWorkspaceItem workItem = this.getWorkspaceItem(itemDelegate);
                if (workItem.isFolder()) {
                    this.getStorage().moveRemoteFolder(itemDelegate.getPath(), trash.getPath() + "/" + itemDelegate.getId());
                    continue;
                }
                if (workItem.getRemotePath() == null) continue;
                this.getStorage().moveRemoteFile(workItem.getRemotePath(), trash.getPath() + "/" + itemDelegate.getId());
            }
            error = session.moveToTrashIds(list, trash.getId());
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return error;
    }

    public void moveToTrash(JCRSession session, JCRWorkspaceItem item) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, RepositoryException {
        long length = 0L;
        String mimeType = null;
        boolean isFolder = false;
        String originalPath = null;
        String description = "move to trash " + item.getDelegate().getName();
        String parentId = item.getDelegate().getParentId();
        WorkspaceItemType type = null;
        try {
            type = item.getType();
            String name = item.getName();
            if (!type.equals((Object)WorkspaceItemType.SHARED_FOLDER)) {
                try {
                    originalPath = item.getPath().substring(0, item.getPath().lastIndexOf("/"));
                }
                catch (Exception e) {
                    this.logger.error("cannot retrieve orginal path of " + item.getName());
                }
            } else {
                JCRWorkspaceSharedFolder sharedFolder = (JCRWorkspaceSharedFolder)item;
                originalPath = sharedFolder.getUserNode(this.getOwner().getPortalLogin()).getPath();
            }
            if (type.equals((Object)WorkspaceItemType.FOLDER) || type.equals((Object)WorkspaceItemType.SHARED_FOLDER)) {
                isFolder = true;
            } else {
                this.logger.info("Try to get mimetype from file");
                try {
                    mimeType = ((FolderItem)item).getMimeType();
                }
                catch (Exception e) {
                    this.logger.error("mime type not present");
                }
            }
            try {
                String trashId = this.getTrash().getId();
                ItemDelegate trashNode = this.createItemDelegate(session, trashId, item.getDelegate().getId(), "nthl:trashItem");
                JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this, trashNode, name, description, Calendar.getInstance(), this.getOwner().getPortalLogin(), parentId, mimeType, length, isFolder, originalPath);
                ItemDelegate savedNode = trashItem.save();
                this.moveNodeTo(session, item, savedNode);
            }
            catch (InsufficientPrivilegesException | ItemAlreadyExistException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void checkDestination(ItemDelegate node, ItemDelegate destinationNode) throws WrongDestinationException, InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException {
        try {
            if (destinationNode.getPath().equals(this.trashPath)) {
                return;
            }
            if (!(destinationNode.getPrimaryType().equals("nthl:workspaceItem") || destinationNode.getPrimaryType().equals("nthl:workspaceSharedItem") || destinationNode.getPrimaryType().equals("nthl:trashItem"))) {
                this.logger.error("Destination is not a folder");
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (destinationNode.getPath().equals(this.mySpecialFoldersPath)) {
                throw new WrongDestinationException("Not allowed to move files or folders in Special Folders");
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            String query = "/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)node.getPath()) + "//element(*,nthl:workspaceSharedItem)";
            List<SearchItemDelegate> result = null;
            JCRSession session = null;
            try {
                session = new JCRSession(this.getOwner().getPortalLogin(), false);
                result = session.executeQuery(query, "xpath", 0);
            }
            catch (HttpException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (IOException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                session.releaseSession();
            }
            if (destinationNode.isShared() && !node.isShared() && result.size() > 0 || destinationNode.isShared() && item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                throw new WrongDestinationException("Not allowed to move in an other destination folder already shared");
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem moveItem(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        JCRWorkspaceItem item;
        block23: {
            this.logger.debug("Move item with id " + itemId + " to destination with id " + destinationFolderId);
            Validate.notNull((Object)itemId, (String)"Item id must be not null");
            Validate.notNull((Object)destinationFolderId, (String)"Destination folder id must be not null");
            ItemDelegate nodeItem = null;
            item = null;
            ItemDelegate nodeDestination = null;
            JCRSession session = null;
            JCRLockManager lm = null;
            try {
                session = new JCRSession(this.getOwner().getPortalLogin(), true);
                lm = session.getLockManager();
                if (!lm.isLocked(itemId) && !lm.isLocked(destinationFolderId)) {
                    lm.lockItem(itemId);
                    lm.lockItem(destinationFolderId);
                    this.logger.trace("LOCK on Node ids: " + itemId + ", " + destinationFolderId);
                    try {
                        nodeItem = session.getItemById(itemId);
                        item = this.getWorkspaceItem(nodeItem);
                    }
                    catch (ItemNotFoundException e) {
                        this.logger.error("Item with id " + itemId + " not found");
                        throw new ItemNotFoundException(e.getMessage());
                    }
                    catch (RepositoryException e) {
                        this.logger.error("Fatal error retrieving item with id " + itemId);
                        throw new InternalErrorException((Throwable)e);
                    }
                    try {
                        nodeDestination = session.getItemById(destinationFolderId);
                    }
                    catch (Exception e) {
                        this.logger.error("Destination not found");
                        throw new WorkspaceFolderNotFoundException(e.getMessage());
                    }
                    if (this.exists(nodeItem.getName(), destinationFolderId)) {
                        this.logger.error("Item with name " + nodeItem.getName() + " exists in folder " + nodeDestination.getPath());
                        throw new ItemAlreadyExistException("Item " + nodeItem.getName() + " already exists in folder " + nodeDestination.getPath());
                    }
                    try {
                        this.logger.trace("nodeDestination: " + nodeDestination.getPath());
                        this.checkDestination(nodeItem, nodeDestination);
                        String idSharedFolder = item.getIdSharedFolder();
                        if (idSharedFolder != item.getId() && idSharedFolder != null) {
                            this.logger.debug("Item: " + nodeItem.getPath() + " is shared");
                            if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeItem.getPath(), false)) {
                                throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                            }
                        }
                        JCRAbstractWorkspaceFolder parentItem = item.getParent();
                        JCRWorkspaceItem destinationItem = this.getWorkspaceItem(nodeDestination);
                        if (destinationItem.isShared() && !JCRPrivilegesInfo.canAddChildren(destinationItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeDestination.getPath())) {
                            throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
                        }
                        this.logger.debug("Adding accounting entry on item " + nodeItem.getPath());
                        try {
                            JCRAccountingFolderEntryCut entry = new JCRAccountingFolderEntryCut(parentItem.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                            entry.save(session);
                        }
                        catch (Exception e) {
                            this.logger.error("Error Set cut accounting entry to folder parent item ");
                        }
                        this.logger.debug("Adding accounting entry on parent " + nodeDestination.getPath());
                        JCRAccountingFolderEntryAdd entryAdd = new JCRAccountingFolderEntryAdd(destinationItem.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null);
                        entryAdd.save(session);
                        try {
                            JCRAccountingEntryPaste entryPaste = new JCRAccountingEntryPaste(item.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName());
                            entryPaste.save(session);
                        }
                        catch (Exception e) {
                            this.logger.error("Error Set PASTE accounting entry to item ");
                        }
                        String newRemotePath = nodeDestination.getPath();
                        this.logger.debug("Move item " + item.getPath() + " to " + newRemotePath);
                        try {
                            this.moveInStorage(session, item, newRemotePath, true);
                        }
                        catch (RemoteBackendException e) {
                            this.logger.error("Error setting remotePath to " + item.getPath());
                        }
                        item.internalMove(session, nodeDestination, newRemotePath);
                        break block23;
                    }
                    catch (RepositoryException e) {
                        this.logger.error("Fatal error moving item with id " + itemId + " to WorkspaceFolder with id " + destinationFolderId);
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                throw new InternalErrorException("LockException: Node locked.");
            }
            catch (WrongItemTypeException | RepositoryException e) {
                throw new InternalErrorException(e);
            }
            finally {
                lm.unlockItem(itemId);
                lm.unlockItem(destinationFolderId);
                session.releaseSession();
                this.logger.trace("Release LOCK on Node ids : " + itemId + ", " + destinationFolderId);
            }
        }
        return item;
    }

    private void moveInStorage(JCRSession servlet, WorkspaceItem item, String destinationPath, Boolean first) throws RemoteBackendException, InternalErrorException {
        String path = destinationPath + this.getPathSeparator() + item.getName();
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            String remotePath = null;
            try {
                remotePath = item.getRemotePath();
            }
            catch (InternalErrorException e) {
                this.logger.warn("No remotePath for item " + item.getName());
            }
            if (remotePath != null) {
                try {
                    this.getStorage().moveRemoteFile(remotePath, path);
                    this.logger.trace("Moved from " + remotePath + " to " + path);
                    JCRWorkspaceItem jcrItem = (JCRWorkspaceItem)item;
                    jcrItem.setRemotePath(servlet, path);
                    this.logger.trace("Set Remote Path property to node: " + path + " - value: " + path);
                }
                catch (RemoteBackendException e) {
                    this.logger.warn("Error moving " + item.getName() + " in storage");
                }
                catch (Exception e) {
                    this.logger.warn("Error setting new remotePath to " + item.getName());
                    throw new InternalErrorException((Throwable)e);
                }
            }
        } else if (item.getType() != WorkspaceItemType.SHARED_FOLDER) {
            for (WorkspaceItem child : item.getChildren()) {
                this.moveInStorage(servlet, child, path, false);
            }
        }
    }

    public void moveNodeTo(JCRSession session, JCRWorkspaceItem item, ItemDelegate destinationNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)item, (String)"Node must be not null");
        Validate.notNull((Object)destinationNode, (String)"Destination folder Node must be not null");
        try {
            String newRemotePath = null;
            if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                newRemotePath = destinationNode.getPath() + "/" + item.getDelegate().getName();
                try {
                    this.getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath);
                }
                catch (Exception e) {
                    this.logger.error("Error setting remotePath to " + item.getDelegate().getPath());
                }
            } else if (item.getType() == WorkspaceItemType.FOLDER) {
                newRemotePath = destinationNode.getPath();
                this.moveInStorage(session, item, newRemotePath, true);
            }
            item.internalMove(session, destinationNode, newRemotePath);
        }
        catch (RepositoryException e) {
            this.logger.error("Fatal error moving item " + item.getDelegate().getPath() + " to WorkspaceFolder " + destinationNode.getPath());
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveSharedItem(JCRSession servlet, ItemDelegate sharedNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, RepositoryException {
        Validate.notNull((Object)sharedNode, (String)"Item id must be not null");
        this.logger.debug("sharedFolder: " + sharedNode.getPath());
        try {
            JCRWorkspaceItem item = this.getWorkspaceItem(sharedNode);
            if (item.isShared()) {
                this.logger.debug("the item " + item.getPath() + " is shared");
                if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), item.getPath(), false)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                }
            }
            String newRemotePath = null;
            this.logger.debug("item.getType() " + item.getType());
            if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                newRemotePath = sharedNode.getPath();
                this.logger.debug("base Path " + newRemotePath);
                this.moveRemoteContent(servlet, item, newRemotePath);
                this.logger.debug("moveToShare finished");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Fatal error moving item with id " + sharedNode);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveRemoteContent(JCRSession servlet, WorkspaceItem item, String destinationPath) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        this.logger.debug("WorkspaceItem " + item + " - destinationPath " + destinationPath);
        for (WorkspaceItem child : item.getChildren()) {
            String newRemotePath = destinationPath + "/" + child.getName();
            this.logger.debug("path " + newRemotePath);
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
                    String remotePath = child.getRemotePath();
                    this.logger.trace("Calling GCUBEStorage: update remotePath: " + remotePath + " to: " + newRemotePath);
                    this.getStorage().moveRemoteFile(remotePath, newRemotePath);
                    this.logger.debug("moved from " + remotePath + " to " + newRemotePath);
                    JCRWorkspaceItem JCRchild = (JCRWorkspaceItem)child;
                    JCRchild.setRemotePath(servlet, newRemotePath);
                    this.logger.debug("property to node: " + child.getRemotePath() + " has been set");
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.moveRemoteContent(servlet, child, newRemotePath);
        }
    }

    public void renameItem(String itemId, String newName) throws ItemNotFoundException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        block25: {
            Validate.notNull((Object)itemId, (String)"Item id must be not null");
            JCRSession session = null;
            JCRLockManager lm = null;
            try {
                session = new JCRSession(this.getOwner().getPortalLogin(), true);
                lm = session.getLockManager();
                if (!lm.isLocked(itemId)) {
                    this.logger.trace("Node id: " + itemId + " not locked. Try to lock it.");
                    lm.lockItem(itemId);
                    this.logger.trace("LOCK on Node id: " + itemId);
                    if (!this.isValidName(newName)) {
                        throw new IllegalArgumentException("Invalid item name");
                    }
                    try {
                        ItemDelegate parentNode;
                        ItemDelegate itemDelegate;
                        try {
                            itemDelegate = session.getItemById(itemId);
                            parentNode = session.getItemById(itemDelegate.getParentId());
                        }
                        catch (Exception e) {
                            throw new ItemNotFoundException(e.getMessage());
                        }
                        JCRWorkspaceItem item = this.getWorkspaceItem(itemDelegate);
                        String oldName = item.getName();
                        if (item.isShared()) {
                            this.logger.debug("the item is shared: " + itemDelegate.getPath());
                            if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), itemDelegate.getPath(), false)) {
                                throw new InsufficientPrivilegesException("Insufficient Privileges to rename the node");
                            }
                        }
                        if (!oldName.equals(newName)) {
                            if (this.exists(newName, itemDelegate.getParentId())) {
                                this.logger.error("Item with name " + newName + " exists in folder " + itemDelegate.getPath());
                                throw new ItemAlreadyExistException("Item " + newName + " already exists");
                            }
                            String newRemotePath = parentNode.getPath() + this.getPathSeparator() + newName;
                            if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                                this.getStorage().moveRemoteFile(item.getRemotePath(), newRemotePath);
                            } else if (item.getType() == WorkspaceItemType.FOLDER) {
                                this.moveInStorage(session, item, newRemotePath, true);
                            }
                            item.internalRename(session, newName, newRemotePath);
                            JCRAccountingEntryRenaming entryRenaming = new JCRAccountingEntryRenaming(item.getId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), oldName, item.getName());
                            entryRenaming.save(session);
                            try {
                                JCRAccountingEntryRenaming entryParent = new JCRAccountingEntryRenaming(itemDelegate.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), oldName, item.getName());
                                entryParent.save(session);
                            }
                            catch (Exception e) {
                                this.logger.error("Impossible to set rename operation to parent of node " + itemDelegate.getPath());
                            }
                        }
                        this.fireItemRenamedEvent(item);
                        break block25;
                    }
                    catch (Exception e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                throw new InternalErrorException("LockException: Node locked.");
            }
            catch (RepositoryException e1) {
                throw new InternalErrorException((Throwable)e1);
            }
            finally {
                try {
                    lm.unlockItem(itemId);
                    this.logger.trace("Release LOCK on Node id : " + itemId);
                }
                catch (Exception e) {
                    this.logger.error("Node id : " + itemId + " not locked");
                }
                if (session != null) {
                    session.releaseSession();
                }
            }
        }
    }

    public void changeDescription(String itemId, String newDescription) throws ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate nodeItem = session.getItemById(itemId);
            this.getWorkspaceItem(nodeItem).internalDescription(newDescription);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceItem getItem(String itemId) throws ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        JCRSession session = null;
        ItemDelegate nodeItem = null;
        JCRWorkspaceItem item = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            nodeItem = session.getItemById(itemId);
            if (nodeItem.isTrashed()) {
                throw new ItemNotFoundException("Item Not Found");
            }
            item = this.getWorkspaceItem(nodeItem);
        }
        catch (InternalErrorException | ItemNotFoundException | RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            session.releaseSession();
        }
        return item;
    }

    public Capabilities getCapabilities(String itemId) throws ItemNotFoundException, InternalErrorException {
        return null;
    }

    public void removeChild(String childId, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        Validate.notNull((Object)childId, (String)"Child Id must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate parent = session.getItemById(folderId);
            if (!parent.getPrimaryType().equals("nthl:workspaceItem")) {
                throw new WrongParentTypeException("Item with id " + folderId + " isn't a folder item");
            }
            this.removeItem(childId);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public void remove(String itemName, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        Validate.notNull((Object)itemName, (String)"Item Name must be not null");
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        JCRSession session = null;
        ItemDelegate nodeFolder = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            nodeFolder = session.getItemById(folderId);
            DelegateManager wrap = new DelegateManager(nodeFolder, this.getOwner().getPortalLogin());
            ItemDelegate childNode = wrap.getNode(itemName);
            this.removeItem(childNode.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceItem copy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"ItemId must be not null");
        Validate.notNull((Object)newName, (String)"NewName must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        if (!this.isValidName(newName)) {
            this.logger.error("The name contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        return this.internalCopy(itemId, newName, destinationFolderId);
    }

    public WorkspaceItem copy(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder id must be not null");
        return this.internalCopy(itemId, null, destinationFolderId);
    }

    public void copyRemoteContent(JCRSession session, ItemDelegate node, ItemDelegate nodeDestinationFolder) throws RepositoryException, InternalErrorException, RemoteBackendException {
        try {
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            for (WorkspaceItem child : item.getChildren()) {
                ItemDelegate childDelegate = null;
                try {
                    childDelegate = session.getItemById(child.getId());
                }
                catch (ItemNotFoundException e) {
                    this.logger.error("item " + child.getId() + "not found");
                }
                this.copyRemoteContent(session, childDelegate, nodeDestinationFolder);
            }
            if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                ((JCRWorkspaceFolderItem)item).copyRemoteContent(session, node);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        JCRWorkspaceItem newItem;
        block20: {
            newItem = null;
            JCRSession session = null;
            JCRLockManager lm = null;
            ItemDelegate itemDelegate = null;
            ItemDelegate destinationDelegate = null;
            String commonPathId = "";
            try {
                session = new JCRSession(this.getOwner().getPortalLogin(), true);
                try {
                    itemDelegate = session.getItemById(itemId);
                }
                catch (Exception e) {
                    throw new ItemNotFoundException(e.getMessage());
                }
                if (destinationFolderId == null) {
                    destinationFolderId = itemDelegate.getParentId();
                }
                try {
                    destinationDelegate = session.getItemById(destinationFolderId);
                }
                catch (Exception e) {
                    throw new ItemNotFoundException(e.getMessage());
                }
                if (!destinationDelegate.getPrimaryType().equals("nthl:workspaceItem") && !destinationDelegate.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                    throw new WrongDestinationException("Destination is not a folder");
                }
                String path = itemDelegate.getPath();
                String destinpath = destinationDelegate.getPath();
                lm = session.getLockManager();
                if (!lm.isLocked(itemId) && !lm.isLocked(destinationFolderId)) {
                    if (lm.lockItem(itemId)) {
                        this.logger.info("item " + path + " has been locked");
                    } else {
                        this.logger.info("item " + path + " cannot be locked");
                    }
                    this.logger.trace("LOCK on Node id: " + path + ", " + destinpath);
                    JCRWorkspaceItem item = this.getWorkspaceItem(itemDelegate);
                    String query = ISO9075.encodePath((String)("/jcr:root/Home/" + this.getOwner().getPortalLogin() + item.getPath())) + "//element(*,nthl:workspaceSharedItem)";
                    List<SearchItemDelegate> itemDelegateList = null;
                    try {
                        itemDelegateList = session.executeQuery(query, "xpath", 0);
                    }
                    catch (HttpException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    if (!item.isShared() && itemDelegateList.size() > 0) {
                        throw new WrongDestinationException("Not allowed to copy a folder with some discendents item shared ");
                    }
                    if (newName == null) {
                        newName = item.getName();
                    }
                    ItemDelegate newNode = item.internalCopy(session, destinationDelegate, newName);
                    newItem = this.getWorkspaceItem(newNode);
                    this.copyRemoteContent(session, newNode, destinationDelegate);
                    Calendar now = Calendar.getInstance();
                    JCRAccountingEntryPaste entryPaste = new JCRAccountingEntryPaste(newItem.getId(), this.getOwner().getPortalLogin(), now, destinationDelegate.getTitle());
                    entryPaste.save(session);
                    if (destinationDelegate != null) {
                        this.logger.debug("Set ADD accounting entry to destination folder " + destinationDelegate.getPath());
                        JCRAccountingFolderEntryAdd entryAdd = new JCRAccountingFolderEntryAdd(destinationFolderId, this.getOwner().getPortalLogin(), now, newItem.getType(), newItem.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)newItem).getFolderItemType() : null, newItem.getName(), newItem.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)newItem).getMimeType() : null);
                        entryAdd.save(session);
                    }
                    break block20;
                }
                throw new InternalErrorException("LockException: Node locked. Impossible to copy itemID " + itemId);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                lm.unlockItem(itemId);
                this.logger.trace("Release LOCK on Node ids : " + itemId + ", " + destinationFolderId);
                session.releaseSession();
            }
        }
        return newItem;
    }

    public WorkspaceItem cloneItem(String itemId, String cloneName) throws ItemNotFoundException, ItemAlreadyExistException, InsufficientPrivilegesException, InternalErrorException, WrongDestinationException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"itemId must be not null");
        if (!this.isValidName(cloneName)) {
            throw new IllegalArgumentException("cloneName is a not valid name");
        }
        return this.internalCopy(itemId, cloneName, null);
    }

    public boolean exists(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        if (!this.isValidName(name)) {
            return false;
        }
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate folderNode = session.getItemById(folderId);
            DelegateManager wrap = new DelegateManager(folderNode, this.getOwner().getPortalLogin());
            try {
                ItemDelegate item = wrap.getNode(name);
                item.getPath();
            }
            catch (Exception e) {
                boolean bl = false;
                if (session != null) {
                    session.releaseSession();
                }
                return bl;
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String itemId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate myItem = session.getItemById(itemId);
            myItem.getId();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceItem find(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        Validate.notNull((Object)name, (String)"name must be not null");
        Validate.notNull((Object)folderId, (String)"folderId must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate nodeFolder = session.getItemById(folderId);
            DelegateManager wrap = new DelegateManager(nodeFolder, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.getNode(name);
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            WorkspaceItem workspaceItem = null;
            return workspaceItem;
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public WorkspaceItem find(String path) throws InternalErrorException {
        Validate.notNull((Object)path, (String)"path must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            String[] strings = path.split("/");
            String pathCleaned = "";
            for (String string : strings) {
                pathCleaned = pathCleaned + "/" + Text.escapeIllegalJcrChars((String)string);
            }
            ItemDelegate rootNode = session.getItemById(this.getRoot().getId());
            ItemDelegate node = session.getItemByPath(rootNode.getPath() + pathCleaned);
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (ItemNotFoundException e) {
            WorkspaceItem workspaceItem = null;
            return workspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !name.contains("/");
    }

    public FolderBulkCreator getNewFolderBulkCreator(String folderId) throws WorkspaceFolderNotFoundException, WrongItemTypeException, InternalErrorException {
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        JCRSession session = null;
        try {
            ItemDelegate folderNode;
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            try {
                folderNode = session.getItemById(folderId);
            }
            catch (Exception e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                if (!folderNode.getPrimaryType().equals("nthl:workspaceItem")) {
                    throw new WrongItemTypeException("A FolderBulkCreator can be created  only for a folder");
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);
            FolderBulkCreator folderBulkCreator = this.folderBulkCreatorsManager.getFolderBulk(folder);
            return folderBulkCreator;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public FolderBulkCreatorManager getFolderBulkCreatorManager() {
        return this.folderBulkCreatorsManager;
    }

    public WorkspaceMessageManager getWorkspaceMessageManager() {
        if (this.sendRequestManager == null) {
            this.sendRequestManager = new JCRWorkspaceMessageManager(this);
        }
        return this.sendRequestManager;
    }

    public WorkspaceFolder decomposeAquaMapsItem(String itemId, String folderName, String destinationWorkspaceId) throws WrongItemTypeException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException {
        return null;
    }

    public JCRWorkspaceItem getWorkspaceItem(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        String type;
        switch (type = delegate.getPrimaryType()) {
            case "nthl:workspaceItem": {
                return new JCRWorkspaceFolder(this, delegate);
            }
            case "nthl:workspaceReference": {
                return new JCRWorkspaceInternalLink(this, delegate);
            }
            case "nthl:workspaceSharedItem": {
                return new JCRWorkspaceSharedFolder(this, delegate);
            }
            case "nthl:workspaceVreItem": {
                return new JCRWorkspaceVREFolder(this, delegate);
            }
            case "nthl:externalFile": {
                return new JCRExternalFile(this, delegate);
            }
            case "nthl:externalImage": {
                return new JCRExternalImage(this, delegate);
            }
            case "nthl:externalPdf": {
                return new JCRExternalPDFFile(this, delegate);
            }
            case "nthl:externalUrl": {
                return new JCRExternalUrl(this, delegate);
            }
            case "nthl:gCubeItem": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:trashItem": {
                return new JCRWorkspaceTrashItem(this, delegate);
            }
            case "nthl:query": {
                return new JCRQuery(this, delegate);
            }
            case "nthl:timeSeriesItem": {
                return new JCRTimeSeries(this, delegate);
            }
            case "nthl:report": {
                return new JCRReport(this, delegate);
            }
            case "nthl:reportTemplate": {
                return new JCRReportTemplate(this, delegate);
            }
            case "nthl:gCubeMetadata": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeImageDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubePDFDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:gCubeURLDocument": {
                return new JCRGCubeItem(this, delegate);
            }
            case "nthl:workspaceSmartItem": {
                return new JCRWorkspaceSmartFolder(this, delegate);
            }
            case "nthl:workspaceLeafItem": {
                return new JCRWorkspaceFolder(this, delegate);
            }
            case "nthl:workflowReport": {
                return new JCRWorkflowReport(this, delegate);
            }
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public FolderItemType getFolderItemType(String nodeType) throws RepositoryException {
        if (nodeType.equals("nthl:externalFile")) {
            return FolderItemType.EXTERNAL_FILE;
        }
        if (nodeType.equals("nthl:externalImage")) {
            return FolderItemType.EXTERNAL_IMAGE;
        }
        if (nodeType.equals("nthl:externalPdf")) {
            return FolderItemType.EXTERNAL_PDF_FILE;
        }
        if (nodeType.equals("nthl:externalUrl")) {
            return FolderItemType.EXTERNAL_URL;
        }
        if (nodeType.equals("nthl:gCubeItem")) {
            return FolderItemType.GCUBE_ITEM;
        }
        if (nodeType.equals("nthl:trashItem")) {
            return FolderItemType.TRASH_ITEM;
        }
        if (nodeType.equals("nthl:report")) {
            return FolderItemType.REPORT;
        }
        if (nodeType.equals("nthl:reportTemplate")) {
            return FolderItemType.REPORT_TEMPLATE;
        }
        if (nodeType.equals("nthl:query")) {
            return FolderItemType.QUERY;
        }
        if (nodeType.equals("nthl:timeSeriesItem")) {
            return FolderItemType.TIME_SERIES;
        }
        if (nodeType.equals("nthl:gCubeDocument")) {
            return FolderItemType.DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeImageDocument")) {
            return FolderItemType.IMAGE_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubePDFDocument")) {
            return FolderItemType.PDF_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeURLDocument")) {
            return FolderItemType.URL_DOCUMENT;
        }
        if (nodeType.equals("nthl:gCubeMetadata")) {
            return FolderItemType.METADATA;
        }
        return null;
    }

    public FolderItemType getFolderItemType(ItemDelegate node) throws RepositoryException {
        String nodeType = node.getPrimaryType();
        return this.getFolderItemType(nodeType);
    }

    protected JCRAbstractWorkspaceFolder getParent(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        if (delegate.getId().equals(this.getRoot().getId())) {
            return null;
        }
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate parent = session.getItemById(delegate.getParentId());
            if (parent != null) {
                if (parent.getPrimaryType().equals("nthl:workspaceItem")) {
                    JCRWorkspaceFolder jCRWorkspaceFolder = new JCRWorkspaceFolder(this, parent);
                    return jCRWorkspaceFolder;
                }
                if (parent.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                    JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = new JCRWorkspaceSharedFolder(this, parent);
                    return jCRWorkspaceSharedFolder;
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return null;
    }

    public JCRFile getGCUBEDocumentContent(String oid, ContentType contentType) throws RepositoryException {
        JCRSession session = null;
        ItemDelegate node = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String path = this.getGCubeRoot() + Text.escapeIllegalJcrChars((String)oid);
            node = session.getItemByPath(path);
            switch (contentType) {
                case GENERAL: {
                    JCRFile jCRFile = new JCRFile(this, node);
                    return jCRFile;
                }
                case IMAGE: {
                    JCRImage jCRImage = new JCRImage(this, node);
                    return jCRImage;
                }
                case PDF: {
                    JCRPDFFile jCRPDFFile = new JCRPDFFile(this, node);
                    return jCRPDFFile;
                }
            }
            JCRFile jCRFile = null;
            return jCRFile;
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    private String getGCubeRoot() {
        return null;
    }

    public List<SearchItem> advancedSearch(String name, SearchItemByOperator date, SearchItemByOperator size) throws InternalErrorException {
        JCRSession session = null;
        List list = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            StringBuilder xpath = new StringBuilder("/jcr:root/Home/" + this.getOwner().getPortalLogin() + "/Workspace" + "//element(*,nthl:workspaceItem)[");
            xpath.append("jcr:contains(@jcr:title, '*" + name + "*')");
            if (date != null) {
                if (date.getMax() != null && date.getMin() != null) {
                    xpath.append(" and @jcr:created >= xs:dateTime('" + date.getMin() + "') and @jcr:created < xs:dateTime('" + date.getMax() + "')");
                } else {
                    xpath.append(" and @jcr:created " + date.getOperator() + " xs:dateTime('" + date.getValue().toString() + "')");
                }
            }
            xpath.append("]");
            List<SearchItemDelegate> itemDelegateList = session.executeQuery(xpath.toString(), "xpath", 0);
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        JCRSearchFolder searchFolder = new JCRSearchFolder(node);
                        if (list.contains(searchFolder)) continue;
                        list.add(searchFolder);
                        continue;
                    }
                    JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType()));
                    if (list.contains(searchFolderItem)) continue;
                    list.add(searchFolderItem);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public List<SearchItem> searchByName(String name, String folderId) throws InternalErrorException {
        Validate.notNull((Object)name, (String)"name must be not null");
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        LinkedList<SearchItem> list = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String path = session.getItemById(folderId).getPath();
            String trashPath = path + "/Trash/";
            String sql2 = "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" + " AND (UPPER([jcr:title]) LIKE '%" + name.toUpperCase() + "%')" + " AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))";
            List<SearchItemDelegate> itemDelegateList = session.executeQuery(sql2, "JCR-SQL2", 0);
            list = new LinkedList<SearchItem>();
            ArrayList<String> idList = new ArrayList<String>();
            for (SearchItemDelegate node : itemDelegateList) {
                String id = node.getId();
                if (idList.contains(id)) continue;
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        JCRSearchFolder searchFolder = new JCRSearchFolder(node);
                        list.add((SearchItem)searchFolder);
                    } else {
                        JCRSearchFolderItem searchFolderItem = new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType()));
                        list.add((SearchItem)searchFolderItem);
                    }
                    idList.add(id);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return list;
    }

    public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
        LinkedList<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
        listItems.addAll(item.getChildren());
        for (WorkspaceItem child : item.getChildren()) {
            listItems.addAll(this.getWorkspaceTree(child));
        }
        return listItems;
    }

    public WorkspaceSmartFolder createSmartFolder(String name, String description, String query, String folderId) throws ItemAlreadyExistException, InternalErrorException {
        Validate.notNull((Object)name, (String)"name must be not null");
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate node = new DelegateManager(this.repository.getRootSmartFolders(), this.getOwner().getPortalLogin()).addNode(name, "nthl:workspaceSmartItem");
            JCRWorkspaceSmartFolder folder = new JCRWorkspaceSmartFolder(this, node, name, description, query, folderId);
            folder.save();
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = folder;
            return jCRWorkspaceSmartFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {
        LinkedList<WorkspaceSmartFolder> folders = null;
        try {
            ItemDelegate rootSmartFolders = this.repository.getRootSmartFolders();
            DelegateManager manager = new DelegateManager(rootSmartFolders, this.getOwner().getPortalLogin());
            folders = new LinkedList<WorkspaceSmartFolder>();
            List<ItemDelegate> list = manager.getNodes();
            for (ItemDelegate node : list) {
                folders.add(new JCRWorkspaceSmartFolder(this, node));
            }
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException("Error retrieving Smart Folders for user " + this.getOwner().getPortalLogin(), e);
        }
        return folders;
    }

    public WorkspaceSmartFolder getSmartFolder(String folderId) throws ItemNotFoundException, InternalErrorException {
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = new JCRWorkspaceSmartFolder(this, session.getItemById(folderId));
            return jCRWorkspaceSmartFolder;
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public List<SearchItem> getFolderItems(GenericItemType ... types) throws InternalErrorException {
        LinkedList<SearchItem> list = new LinkedList<SearchItem>();
        for (GenericItemType folderItemType : types) {
            list.addAll(this.getFolderItems(folderItemType));
        }
        return list;
    }

    public List<SearchItem> getFolderItems(GenericItemType type) throws InternalErrorException {
        JCRSession session = null;
        LinkedList<SearchItem> list = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String query = null;
            if (type instanceof FolderItemType) {
                query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@hl:workspaceItemType = '" + type.toString() + "']";
            } else if (type instanceof WorkspaceItemType) {
                switch ((WorkspaceItemType)type) {
                    case FOLDER: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:workspaceItem" + "']";
                        break;
                    }
                    case SHARED_FOLDER: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:workspaceSharedItem" + "']";
                        break;
                    }
                    case TRASH_ITEM: {
                        query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:primaryType= '" + "nthl:trashItem" + "']";
                        break;
                    }
                }
            }
            this.logger.info(query);
            List<SearchItemDelegate> itemDelegateList = session.executeQuery(query, "xpath", 0);
            list = new LinkedList<SearchItem>();
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    if (node.getPrimaryType().equals("nthl:workspaceItem") || node.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                        list.add((SearchItem)new JCRSearchFolder(node));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public List<SearchFolderItem> searchByMimeType(String mimeType) throws InternalErrorException {
        Validate.notNull((Object)mimeType, (String)"mimeType must be not null");
        JCRSession session = null;
        LinkedList<SearchFolderItem> list = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String query = "/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:mimeType = '" + mimeType + "']";
            List<SearchItemDelegate> itemDelegateList = session.executeQuery(query, "xpath", 0);
            list = new LinkedList<SearchFolderItem>();
            for (SearchItemDelegate node : itemDelegateList) {
                try {
                    list.add(new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public String getUrlWebDav() throws InternalErrorException {
        return this.repository.getWebDavUrl(this.home.getOwner().getPortalLogin()) + this.getPathSeparator() + WORKSPACE_ROOT_FOLDER;
    }

    private void updateHomes(List<String> users) throws InternalErrorException {
        try {
            List<String> homes = this.repository.getHomeNames();
            for (String user : users) {
                if (homes.contains(user)) continue;
                this.home.getHomeManager().createUser(user);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, List<String> users, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        this.updateHomes(users);
        try {
            if (this.exists(name, destinationFolderId)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderId);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedRootFolder = this.repository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedRootFolder, this.getOwner().getPortalLogin());
            ItemDelegate sharedNode = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceSharedItem");
            this.logger.info("SHARED NODE: " + sharedNode.toString());
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, sharedNode, name, description, destinationFolderId, users, null, null);
            folder.save();
            folder.share();
            this.fireItemCreatedEvent(folder);
            return folder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder shareFolder(List<String> users, String itemId, String displayName, Boolean isVREFolder, List<String> admins) throws InternalErrorException, InsufficientPrivilegesException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        JCRSession session = null;
        ItemDelegate nodeToShare = null;
        JCRWorkspaceSharedFolder sharedFoldere = null;
        JCRLockManager lm = null;
        try {
            JCRWorkspaceItem itemToShare;
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            nodeToShare = session.getItemById(itemId);
            if (!nodeToShare.isLocked()) {
                lm = session.getLockManager();
                lm.lockItem(itemId);
                itemToShare = this.getWorkspaceItem(nodeToShare);
                if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    JCRWorkspaceSharedFolder sharedFolder = (JCRWorkspaceSharedFolder)itemToShare;
                    sharedFolder.share(users);
                    JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = sharedFolder;
                    return jCRWorkspaceSharedFolder;
                }
                if (itemToShare.getType() != WorkspaceItemType.FOLDER && !(itemToShare instanceof GCubeItem)) {
                    throw new WorkspaceFolderNotFoundException("The item to share is not a folder or a GCubeItem");
                }
                JCRAbstractWorkspaceFolder parentItem = itemToShare.getParent();
                if (parentItem == null) {
                    throw new WrongDestinationException("The root can't be shared");
                }
                String parentId = parentItem.getId();
                if (parentItem.isShared()) {
                    throw new WrongDestinationException("Destination folder is already shared");
                }
                this.logger.info("Check if Folder contains descendants already shared");
                List<SearchItemDelegate> result = null;
                try {
                    result = session.executeQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)itemToShare.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath", 0);
                }
                catch (HttpException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (IOException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (!result.isEmpty()) {
                    throw new WrongDestinationException("Folder contains descendants already shared");
                }
                String sharedFolderName = itemToShare.getName();
                String sharedFolderDescription = itemToShare.getDescription();
                ItemDelegate sharedRootFolder = this.repository.getSharedRoot();
                DelegateManager wrap = new DelegateManager(sharedRootFolder, this.getOwner().getPortalLogin());
                ItemDelegate sharedNode = wrap.addNode(itemId, "nthl:workspaceSharedItem");
                this.logger.info("SHARED NODE: " + sharedNode.toString());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    sharedFoldere = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, null, null, displayName, isVREFolder);
                    sharedFoldere.save();
                    DelegateManager wrap1 = new DelegateManager(nodeToShare, this.getOwner().getPortalLogin());
                    List<ItemDelegate> list = wrap1.getNodes();
                    for (ItemDelegate node : list) {
                        try {
                            this.logger.info("MOVE FROM: " + node.getPath() + " - TO: " + sharedNode.getPath() + this.getPathSeparator() + node.getName());
                            session.move(node.getPath(), sharedNode.getPath() + this.getPathSeparator() + node.getName());
                        }
                        catch (HttpException e) {
                            throw new InternalErrorException((Throwable)e);
                        }
                        catch (IOException e) {
                            throw new InternalErrorException((Throwable)e);
                        }
                    }
                }
                DelegateManager wrap2 = new DelegateManager(nodeToShare, this.getOwner().getPortalLogin());
                this.logger.info("Remove node " + nodeToShare.getPath());
                wrap2.remove();
                sharedFoldere.share();
                this.createVREManager(displayName, sharedFoldere);
                sharedFoldere.setACL(admins, ACLType.ADMINISTRATOR);
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    try {
                        this.moveSharedItem(session, sharedNode);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            } else {
                throw new InternalErrorException("LockException: Node locked.");
            }
            this.fireItemCreatedEvent(sharedFoldere);
            itemToShare = sharedFoldere;
            return itemToShare;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            lm.unlockItem(itemId);
            session.releaseSession();
            this.logger.trace("Release LOCK on Node id : " + itemId);
        }
    }

    public WorkspaceSharedFolder shareFolder(List<String> users, String itemId) throws InternalErrorException, InsufficientPrivilegesException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        JCRSession session = null;
        ItemDelegate nodeToShare = null;
        JCRWorkspaceSharedFolder sharedFoldere = null;
        JCRLockManager lm = null;
        try {
            JCRWorkspaceItem itemToShare;
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            nodeToShare = session.getItemById(itemId);
            if (!nodeToShare.isLocked()) {
                lm = session.getLockManager();
                lm.lockItem(itemId);
                itemToShare = this.getWorkspaceItem(nodeToShare);
                if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    JCRWorkspaceSharedFolder sharedFolder = (JCRWorkspaceSharedFolder)itemToShare;
                    sharedFolder.share(users);
                    JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = sharedFolder;
                    return jCRWorkspaceSharedFolder;
                }
                if (itemToShare.getType() != WorkspaceItemType.FOLDER && !(itemToShare instanceof GCubeItem)) {
                    throw new WorkspaceFolderNotFoundException("The item to share is not a folder or a GCubeItem");
                }
                JCRAbstractWorkspaceFolder parentItem = itemToShare.getParent();
                if (parentItem == null) {
                    throw new WrongDestinationException("The root can't be shared");
                }
                String parentId = parentItem.getId();
                if (parentItem.isShared()) {
                    throw new WrongDestinationException("Destination folder is already shared");
                }
                this.logger.info("Check if Folder contains descendants already shared");
                List<SearchItemDelegate> result = null;
                try {
                    result = session.executeQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)itemToShare.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath", 0);
                }
                catch (HttpException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (IOException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (!result.isEmpty()) {
                    throw new WrongDestinationException("Folder contains descendants already shared");
                }
                String sharedFolderName = itemToShare.getName();
                String sharedFolderDescription = itemToShare.getDescription();
                ItemDelegate sharedRootFolder = this.repository.getSharedRoot();
                DelegateManager wrap = new DelegateManager(sharedRootFolder, this.getOwner().getPortalLogin());
                ItemDelegate sharedNode = wrap.addNode(itemId, "nthl:workspaceSharedItem");
                this.logger.info("SHARED NODE: " + sharedNode.toString());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    WorkspaceFolder folderToShare = (WorkspaceFolder)itemToShare;
                    boolean isSystemFolder = folderToShare.isSystemFolder();
                    sharedFoldere = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users);
                    sharedFoldere.setSystemFolder(isSystemFolder);
                    sharedFoldere.save();
                    DelegateManager wrap1 = new DelegateManager(nodeToShare, this.getOwner().getPortalLogin());
                    List<ItemDelegate> list = wrap1.getNodes();
                    for (ItemDelegate node : list) {
                        try {
                            this.logger.info("MOVE FROM: " + node.getPath() + " - TO: " + sharedNode.getPath() + this.getPathSeparator() + node.getName());
                            session.move(node.getPath(), sharedNode.getPath() + this.getPathSeparator() + node.getName());
                        }
                        catch (HttpException e) {
                            throw new InternalErrorException((Throwable)e);
                        }
                        catch (IOException e) {
                            throw new InternalErrorException((Throwable)e);
                        }
                    }
                } else {
                    this.logger.trace("Sharing a GCubeItem");
                    ItemDelegate parent = session.getItemById(nodeToShare.getParentId());
                    String applicationName = parent.getName();
                    sharedFoldere = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, applicationName, nodeToShare.getName());
                    sharedFoldere.save();
                    try {
                        session.move(nodeToShare.getPath(), this.repository.getSharedRoot().getPath() + this.getPathSeparator() + itemId + this.getPathSeparator() + nodeToShare.getName());
                    }
                    catch (HttpException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    JCRGCubeItem gcubeItem = (JCRGCubeItem)itemToShare;
                    gcubeItem.setSharedRootId(sharedFoldere.getId());
                    gcubeItem.save();
                }
                try {
                    lm.unlockItem(itemId);
                }
                catch (Exception e) {
                    this.logger.error("Impossible to unlock item with id " + itemId);
                }
                DelegateManager wrap2 = new DelegateManager(nodeToShare, this.getOwner().getPortalLogin());
                this.logger.info("Remove node " + nodeToShare.getPath());
                wrap2.remove();
                sharedFoldere.share();
                sharedFoldere.setShareHistory(session, users, this.getOwner().getPortalLogin());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    try {
                        this.moveSharedItem(session, sharedNode);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            } else {
                throw new InternalErrorException("LockException: Node locked.");
            }
            this.fireItemCreatedEvent(sharedFoldere);
            itemToShare = sharedFoldere;
            return itemToShare;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            try {
                lm.unlockItem(itemId);
            }
            catch (Exception e) {
                this.logger.error("Impossible to unlock item with id " + itemId);
            }
            session.releaseSession();
            this.logger.trace("Release LOCK on Node id : " + itemId);
        }
    }

    @Deprecated
    public List<Object> getBookmarks(String bookmarkFolderId) throws InternalErrorException {
        return null;
    }

    @Deprecated
    public void addBookmark(String itemId, String destinationFolderId) throws ItemAlreadyExistException, InternalErrorException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
    }

    public void setHardLink(ItemDelegate node, String hardLinkRemotePath) throws RepositoryException, InternalErrorException {
        this.logger.info("set hard link: " + hardLinkRemotePath + " to node " + node.getPath());
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            for (WorkspaceItem child : item.getChildren()) {
                this.setHardLink(session.getItemById(child.getId()), hardLinkRemotePath);
            }
            if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                ((JCRWorkspaceFolderItem)item).setHardLink(node, hardLinkRemotePath);
            }
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            session.releaseSession();
        }
    }

    public void updateItem(String itemId, InputStream fileData) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        block12: {
            Validate.notNull((Object)itemId, (String)"item Id must be not null");
            Validate.notNull((Object)fileData, (String)"InputStream must be not null");
            JCRSession session = null;
            JCRLockManager lm = null;
            try {
                session = new JCRSession(this.getOwner().getPortalLogin(), true);
                ItemDelegate itemDelegate = session.getItemById(itemId);
                if (!itemDelegate.isLocked()) {
                    lm = session.getLockManager();
                    lm.lockItem(itemId);
                    this.logger.trace("Update file " + itemDelegate.getPath());
                    String remotePath = null;
                    MetaInfo info = null;
                    try {
                        Map contentNode = itemDelegate.getContent();
                        if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                            remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
                        }
                        info = WorkspaceItemUtil.getMetadataInfo(fileData, this.getStorage(), remotePath, itemDelegate.getTitle());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    JCRWorkspaceItem newItem = this.getWorkspaceItem(itemDelegate);
                    if (newItem.isShared()) {
                        this.logger.debug("the item is shared: " + itemDelegate.getPath());
                        if (!JCRPrivilegesInfo.canModifyProperties(newItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), itemDelegate.getPath(), false)) {
                            throw new InsufficientPrivilegesException("Insufficient Privileges to update the node");
                        }
                    }
                    Calendar lastupdate = Calendar.getInstance();
                    this.updateProperties(session, itemDelegate, lastupdate, info);
                    JCRAccountingEntryUpdate entryUpdate = new JCRAccountingEntryUpdate(newItem.getId(), this.getOwner().getPortalLogin(), lastupdate, itemDelegate.getTitle());
                    entryUpdate.save(session);
                    JCRAccountingEntryUpdate entryUpdateFolder = new JCRAccountingEntryUpdate(itemDelegate.getParentId(), this.getOwner().getPortalLogin(), lastupdate, itemDelegate.getTitle());
                    entryUpdateFolder.save(session);
                    this.fireItemUpdatedEvent(this.getItem(itemId));
                    break block12;
                }
                throw new InternalErrorException("LockException: Node locked.");
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                lm.unlockItem(itemId);
                session.releaseSession();
                this.logger.trace("Release LOCK on Node id : " + itemId);
            }
        }
    }

    private void updateProperties(JCRSession session, ItemDelegate delegate, Calendar lastupdate, MetaInfo info) throws RepositoryException, InternalErrorException {
        this.logger.trace("update Properies for node: " + delegate.getPath() + " - Last Modified by : " + this.getOwner().getPortalLogin() + " - Last Action : " + WorkspaceItemAction.UPDATED.toString());
        try {
            delegate.setLastModificationTime(lastupdate);
            delegate.setLastModifiedBy(this.getOwner().getPortalLogin());
            delegate.setLastAction(WorkspaceItemAction.UPDATED);
            session.saveItem(delegate);
            if (delegate.getPrimaryType().equals("nthl:externalFile")) {
                JCRExternalFile item = new JCRExternalFile(this, delegate);
                item.updateInfo(session, info);
            } else if (delegate.getPrimaryType().equals("nthl:externalImage")) {
                JCRExternalImage item = new JCRExternalImage(this, delegate);
                item.updateInfo(session, info);
            } else if (delegate.getPrimaryType().equals("nthl:externalPdf")) {
                JCRExternalPDFFile item = new JCRExternalPDFFile(this, delegate);
                item.updateInfo(session, info);
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public void overwriteContent(ItemDelegate itemDelegate, String oldRemotePath, String mimeType) throws RepositoryException, RemoteBackendException {
        try {
            Map contentNode = itemDelegate.getContent();
            if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                String remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
                this.getStorage().putStream(oldRemotePath, remotePath, mimeType);
            }
        }
        catch (Exception e) {
            this.logger.error("Content node not found", (Throwable)e);
        }
    }

    public JCRWorkspaceItem createGcubeItem(String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        this.logger.trace("Create gCube item " + name);
        try {
            ItemDelegate node = this.addChildNode(destinationFolderId, name, "nthl:gCubeItem");
            JCRGCubeItem item = new JCRGCubeItem(this, node, name, description, scopes, creator, itemType, properties);
            ((JCRWorkspaceItem)item).save();
            this.fireItemCreatedEvent(item);
            return item;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder getMySpecialFolders() throws InternalErrorException, ItemNotFoundException {
        JCRWorkspaceFolder mySpecialFolders;
        this.logger.info("getMySpecialFolders: " + this.mySpecialFoldersPath);
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            try {
                mySpecialFolders = new JCRWorkspaceFolder(this, session.getItemByPath(this.mySpecialFoldersPath));
            }
            catch (RepositoryException e) {
                ItemDelegate root = session.getItemByPath(this.userWorkspace);
                DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                ItemDelegate mySpecial = wrap.addNode(SPECIAL_FOLDER, "nthl:workspaceItem");
                mySpecialFolders = new JCRWorkspaceFolder(this, mySpecial, SPECIAL_FOLDER, "My Special Folders");
                mySpecialFolders.save();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return mySpecialFolders;
    }

    public WorkspaceFolder getApplicationArea() throws InternalErrorException {
        JCRWorkspaceFolder applicationFolder;
        this.logger.info("getApplicationArea: " + this.applicationFolderPath);
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            try {
                applicationFolder = new JCRWorkspaceFolder(this, session.getItemByPath(this.applicationFolderPath));
            }
            catch (RepositoryException e) {
                ItemDelegate root = session.getItemByPath(this.userWorkspace);
                DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                ItemDelegate application = wrap.addNode(APPLICATION_FOLDER, "nthl:workspaceItem");
                applicationFolder = new JCRWorkspaceFolder(this, application, APPLICATION_FOLDER, "Applications folder");
                applicationFolder.save();
                applicationFolder.setHidden(true);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return applicationFolder;
    }

    public WorkspaceItem unshare(String itemId) throws InternalErrorException, ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"item Id must be not null");
        WorkspaceFolder itemUnshared = null;
        try {
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(itemId);
            JCRWorkspaceSharedFolder sharedItem = (JCRWorkspaceSharedFolder)this.getItem(itemId);
            if (item.isShared()) {
                this.logger.trace("Unshare Folder: " + sharedItem.getPath());
                itemUnshared = sharedItem.unShare();
                return itemUnshared;
            }
            this.logger.trace(item.getPath() + " the item is not shared");
            return sharedItem;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem getItemByPath(String path) throws ItemNotFoundException {
        Validate.notNull((Object)path, (String)"path must be not null");
        try {
            String longPath = path.substring(path.indexOf(47) + 1);
            String shortPath = longPath.substring(longPath.indexOf(47) + 1);
            String absPath = shortPath.startsWith(PREFIX + JCRRepository.serviceName) ? shortPath.replaceAll(PREFIX + JCRRepository.serviceName, "") : (path.startsWith(PREFIX_SHARE) || path.startsWith("/Home/" + this.getOwner().getPortalLogin() + "/Workspace/") ? path : this.userHome + path);
            this.logger.trace("getItemByPath: " + absPath);
            return this.getItemByAbsPath(absPath);
        }
        catch (InternalErrorException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public WorkspaceItem getItemByAbsPath(String path) throws ItemNotFoundException, InternalErrorException, RepositoryException {
        ItemDelegate nodeItem = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            nodeItem = session.getItemByPath(path);
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.toString());
        }
        finally {
            session.releaseSession();
        }
        return this.getWorkspaceItem(nodeItem);
    }

    public WorkspaceTrashFolder getTrash() throws InternalErrorException, ItemNotFoundException {
        JCRSession session = null;
        try {
            JCRWorkspaceTrashFolder trashFolder;
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            try {
                trashFolder = new JCRWorkspaceTrashFolder(this, session.getItemByPath(this.trashPath));
            }
            catch (ItemNotFoundException e) {
                ItemDelegate root = null;
                try {
                    root = session.getItemByPath(this.userWorkspace);
                    DelegateManager wrap = new DelegateManager(root, this.getOwner().getPortalLogin());
                    ItemDelegate trash = wrap.addNode(TRASH, "nthl:workspaceItem");
                    trashFolder = new JCRWorkspaceTrashFolder(this, trash, TRASH, "Trash folder");
                    trashFolder.save();
                    this.logger.info("Trash folder: " + this.trashPath + " created.");
                }
                catch (ItemNotFoundException e1) {
                    throw new InternalErrorException((Throwable)e1);
                }
            }
            JCRWorkspaceTrashFolder jCRWorkspaceTrashFolder = trashFolder;
            return jCRWorkspaceTrashFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceSharedFolder convertToVREFolder(String scope, String destinationFolderId, String description, String displayName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)scope, (String)"scope must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        Validate.notNull((Object)displayName, (String)"Display Name must be not null");
        this.logger.trace("Create workspace shared folder");
        String newName = this.getVRENameByScope(scope);
        String newGroupId = this.getVRENameByScope(scope);
        List<String> users = this.resolveGroupId(newGroupId);
        this.updateHomes(users);
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String destinationFolderID = session.getItemByPath(this.mySpecialFoldersPath).getId();
            if (this.exists(newName, destinationFolderID)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderID);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedFolder = this.repository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedFolder, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceSharedItem");
            ArrayList<String> users1 = new ArrayList<String>();
            users1.add(newGroupId);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, newName, description, destinationFolderID, users1, null, null, displayName, true);
            folder.save();
            folder.share();
            this.fireItemCreatedEvent(folder);
            this.createVREManager(newName, folder);
            ArrayList<String> admins = new ArrayList<String>();
            admins.add(this.getOwner().getPortalLogin());
            folder.setACL(admins, ACLType.ADMINISTRATOR);
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = folder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, String groupId, String destinationFolderId, String displayName, boolean isVREFolder) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)name, (String)"Shared Folder Name must be not null");
        Validate.notNull((Object)groupId, (String)"Group id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        Validate.notNull((Object)displayName, (String)"Display Name must be not null");
        this.logger.trace("Create workspace shared folder");
        String newName = this.getVRENameByScope(name);
        String newGroupId = this.getVRENameByScope(groupId);
        List<String> users = this.resolveGroupId(newGroupId);
        this.updateHomes(users);
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String destinationFolderID = session.getItemByPath(this.mySpecialFoldersPath).getId();
            if (this.exists(newName, destinationFolderID)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderID);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedFolder = this.repository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedFolder, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceSharedItem");
            ArrayList<String> users1 = new ArrayList<String>();
            users1.add(newGroupId);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, newName, description, destinationFolderID, users1, null, null, displayName, isVREFolder);
            folder.save();
            folder.share();
            this.fireItemCreatedEvent(folder);
            if (isVREFolder) {
                this.createVREManager(newName, folder);
            }
            ArrayList<String> admins = new ArrayList<String>();
            admins.add(this.getOwner().getPortalLogin());
            folder.setACL(admins, ACLType.ADMINISTRATOR);
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = folder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceVREFolder createVREFolder(String scope, String description, String displayName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)scope, (String)"Scope must be not null");
        Validate.notNull((Object)displayName, (String)"Display Name must be not null");
        this.logger.trace("Create workspace VRE folder");
        JCRUserManager um = (JCRUserManager)HomeLibrary.getHomeManagerFactory().getUserManager();
        String VREname = this.getVRENameByScope(scope);
        GCubeGroup group = um.createGroup(scope);
        group.addMember(this.getOwner().getPortalLogin());
        String groupId = group.getName();
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            String destinationFolderID = session.getItemByPath(this.mySpecialFoldersPath).getId();
            if (this.exists(VREname, destinationFolderID)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(destinationFolderID);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            ItemDelegate sharedFolder = this.repository.getSharedRoot();
            DelegateManager wrap = new DelegateManager(sharedFolder, this.getOwner().getPortalLogin());
            ItemDelegate node = wrap.addNode(UUID.randomUUID().toString(), "nthl:workspaceVreItem");
            JCRWorkspaceVREFolder folder = new JCRWorkspaceVREFolder(this, node, VREname, description, groupId, displayName, scope);
            this.fireItemCreatedEvent(folder);
            ArrayList<String> admins = new ArrayList<String>();
            admins.add(this.getOwner().getPortalLogin());
            folder.setACL(admins, ACLType.ADMINISTRATOR);
            JCRWorkspaceVREFolder jCRWorkspaceVREFolder = folder;
            return jCRWorkspaceVREFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    private void createVREManager(String newName, JCRWorkspaceSharedFolder folder) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        String manager = newName + "-Manager";
        ArrayList<String> usersList = new ArrayList<String>();
        usersList.add(manager);
        folder.share(usersList);
    }

    public List<String> resolveGroupId(String groupId) throws InternalErrorException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup myGroup = gm.getGroup(groupId);
        List members = myGroup.getMembers();
        return members;
    }

    public List<WorkspaceItem> searchByProperties(List<String> properties) throws InternalErrorException {
        Validate.notNull(properties, (String)"Properties must be not null");
        LinkedList<WorkspaceItem> list = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:workspaceItem)[");
            int i = 0;
            for (String property : properties) {
                if (i != 0) {
                    query.append(" and ");
                }
                query.append("hl:metadata/@" + property + "");
                ++i;
            }
            query.append("]");
            this.logger.trace(query.toString());
            List<ItemDelegate> itemDelegateList = session.searchItems(query.toString(), "xpath");
            list = new LinkedList<WorkspaceItem>();
            for (ItemDelegate node : itemDelegateList) {
                try {
                    JCRWorkspaceItem item = this.getWorkspaceItem(node);
                    list.add(item);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public boolean isInTrash(ItemDelegate originalParent) throws InternalErrorException, RepositoryException {
        return originalParent.getPath().contains("/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace/Trash/");
    }

    public List<SearchFolderItem> searchFullText(String text) throws InternalErrorException {
        Validate.notNull((Object)text, (String)"text must be not null");
        LinkedList<SearchFolderItem> list = null;
        ArrayList<String> ids = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:workspaceItem)[jcr:contains(., '" + text + "')]");
            this.logger.trace(query.toString());
            List<SearchItemDelegate> itemDelegateList = session.executeQuery(query.toString(), "xpath", 0);
            list = new LinkedList<SearchFolderItem>();
            ids = new ArrayList<String>();
            for (SearchItemDelegate node : itemDelegateList) {
                String id = node.getId();
                try {
                    if (ids.contains(id)) continue;
                    list.add(new JCRSearchFolderItem(node, this.getFolderItemType(node.getPrimaryType())));
                    ids.add(id);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
            this.logger.info("Results: " + list.size());
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public void init(String portalLogin) throws PathNotFoundException, RepositoryException, InternalErrorException, ItemNotFoundException {
        Validate.notNull((Object)portalLogin, (String)"portalLogin must be not null");
        JCRUserManager um = new JCRUserManager();
        String userVersion = JCRRepository.getUserVersion(portalLogin, null);
        this.logger.info(portalLogin + " --> USER VERSION: " + userVersion + " - HL VERSION: " + JCRRepository.HLversion);
        if (!JCRRepository.HLversion.equals(userVersion)) {
            JCRSession session = null;
            try {
                ItemDelegate vreNode;
                session = new JCRSession(this.getOwner().getPortalLogin(), false);
                ItemDelegate userHome = session.getItemByPath("/Home/" + portalLogin);
                DelegateManager userHomeManager = new DelegateManager(userHome, this.getOwner().getPortalLogin());
                ItemDelegate wsNode = null;
                try {
                    wsNode = userHomeManager.addNode(WORKSPACE_ROOT_FOLDER, "nthl:workspaceItem");
                    JCRWorkspaceFolder root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
                    wsNode = root.save();
                    this.logger.info(wsNode.getPath() + " created");
                }
                catch (Exception e) {
                    wsNode = userHomeManager.getNode(WORKSPACE_ROOT_FOLDER);
                    this.logger.info("Getting workspace node: " + wsNode.getPath());
                }
                DelegateManager wrapWsNode = new DelegateManager(wsNode, this.getOwner().getPortalLogin());
                try {
                    ItemDelegate node = wrapWsNode.addNode(APPLICATION_FOLDER, "nthl:workspaceItem");
                    JCRWorkspaceFolder applicationFolder = new JCRWorkspaceFolder(this, node, APPLICATION_FOLDER, "Applications folder");
                    applicationFolder.save();
                    applicationFolder.setHidden(true);
                }
                catch (Exception e) {
                    JCRWorkspaceFolder applicationFolder = new JCRWorkspaceFolder(this, wrapWsNode.getNode(APPLICATION_FOLDER));
                }
                try {
                    vreNode = wrapWsNode.addNode(SPECIAL_FOLDER, "nthl:workspaceItem");
                    JCRWorkspaceFolder mySpecialFolders = new JCRWorkspaceFolder(this, vreNode, SPECIAL_FOLDER, "My Special Folders");
                    mySpecialFolders.save();
                }
                catch (Exception e) {
                    JCRWorkspaceFolder mySpecialFolders = new JCRWorkspaceFolder(this, wrapWsNode.getNode(SPECIAL_FOLDER));
                    vreNode = wrapWsNode.getNode(SPECIAL_FOLDER);
                }
                um.setVersionByUser(portalLogin, JCRRepository.HLversion);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                session.releaseSession();
            }
        }
        this.logger.info("skip init in JCRWorkspace for user: " + portalLogin);
    }

    private String getVRENameByScope(String scope) {
        Validate.notNull((Object)scope, (String)"scope must be not null");
        String newName = scope.startsWith("/") ? scope.replace("/", "-").substring(1) : scope.replace("/", "-");
        return newName;
    }

    public WorkspaceSharedFolder getVREFolderByScope(String scope) throws ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)scope, (String)"scope must be not null");
        String VRE = this.getVRENameByScope(scope);
        WorkspaceSharedFolder folder = (WorkspaceSharedFolder)this.getItemByPath(this.mySpecialFoldersPath + "/" + VRE);
        return folder;
    }

    public long getDiskUsage() throws InternalErrorException {
        this.logger.trace("get getDiskUsage of user " + this.portalLogin);
        long diskUsage = 0L;
        try {
            diskUsage = this.getStorage().getDiskUsageByUser();
        }
        catch (Exception e) {
            this.logger.error("Error retrieving disk usage ", (Throwable)e);
        }
        return diskUsage;
    }

    public int getTotalItems() throws InternalErrorException {
        this.logger.trace("get getTotalItems of user " + this.portalLogin);
        int totItems = 0;
        try {
            totItems = this.getStorage().getTotalItemsByUser();
        }
        catch (Exception e) {
            this.logger.error("Error retrieving total items ", (Throwable)e);
        }
        return totItems;
    }

    public WorkspaceSharedFolder share(List<String> users, String itemId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        return this.shareFolder(users, itemId);
    }

    public List<GCubeItem> searchGCubeItems(SearchQuery queryString) throws InternalErrorException {
        Validate.notNull((Object)queryString, (String)"queryString must be not null");
        JCRSession session = null;
        LinkedList<GCubeItem> list = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:gCubeItem)[");
            if (!queryString.getHasProperties().isEmpty()) {
                int i = 0;
                Set keys = queryString.getHasProperties();
                for (String key : keys) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("hl:metadata/@" + key);
                    ++i;
                }
            }
            if (!queryString.getPropertiesValues().isEmpty()) {
                if (!queryString.getHasProperties().isEmpty()) {
                    query.append(" and ");
                }
                Map properties = queryString.getPropertiesValues();
                int i = 0;
                Set keys = properties.keySet();
                for (String key : keys) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("hl:metadata/@" + key + " = '" + (String)properties.get(key) + "'");
                    ++i;
                }
            }
            if (!queryString.getTypes().isEmpty()) {
                if (!queryString.getHasProperties().isEmpty() || !queryString.getPropertiesValues().isEmpty()) {
                    query.append(" and ");
                }
                Set types = queryString.getTypes();
                int i = 0;
                for (String type : types) {
                    if (i != 0) {
                        query.append(" and ");
                    }
                    query.append("@hl:itemType = '" + type + "'");
                    ++i;
                }
            }
            query.append("]");
            this.logger.trace(query.toString());
            List<ItemDelegate> itemDelegateList = session.searchItems(query.toString(), "xpath");
            list = new LinkedList<GCubeItem>();
            for (ItemDelegate node : itemDelegateList) {
                try {
                    GCubeItem item = (GCubeItem)this.getWorkspaceItem(node);
                    list.add(item);
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (Exception e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public ReportTemplate createReportTemplate(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Created report template");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate node = this.createItemDelegate(session, destinationfolderId, name, "nthl:reportTemplate");
            JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);
            reportTemplate.save();
            try {
                this.logger.info(reportTemplate.getPath() + " has been added to parent folder " + node.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), reportTemplate.getType(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getFolderItemType() : null, reportTemplate.getName(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getMimeType() : null);
                entry.save(session);
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + reportTemplate.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(reportTemplate);
            JCRReportTemplate jCRReportTemplate = reportTemplate;
            return jCRReportTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public Report createReport(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create report");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate node = this.createItemDelegate(session, destinationfolderId, name, "nthl:report");
            JCRReport item = new JCRReport(this, node, name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData);
            item.save();
            try {
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null);
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRReport jCRReport = item;
            return jCRReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public Query createQuery(String name, String description, String query, QueryType queryType, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create query");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            ItemDelegate node = this.createItemDelegate(session, destinationfolderId, name, "nthl:query");
            JCRQuery item = new JCRQuery(this, node, name, description, query, queryType);
            item.save();
            this.fireItemCreatedEvent(item);
            JCRQuery jCRQuery = item;
            return jCRQuery;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public Query createQuery(String name, String description, InputStream query, QueryType queryType, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        try {
            return this.createQuery(name, description, Util.readStreamAsString((InputStream)query), queryType, destinationfolderId);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create TimeSeries item");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate node = this.createItemDelegate(session, destinationFolderId, name, "nthl:timeSeriesItem");
            JCRTimeSeries item = new JCRTimeSeries(this, node, name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV);
            item.save();
            this.fireItemCreatedEvent(item);
            JCRTimeSeries jCRTimeSeries = item;
            return jCRTimeSeries;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowReport item");
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate node = this.createItemDelegate(session, destinationFolderId, name, "nthl:workflowReport");
            JCRWorkflowReport item = new JCRWorkflowReport(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save();
            this.fireItemCreatedEvent(item);
            JCRWorkflowReport jCRWorkflowReport = item;
            return jCRWorkflowReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceInternalLink copyAsLink(String itemId, String destinationFolderId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"item Id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder Id must be not null");
        JCRSession session = null;
        WorkspaceInternalLink item = null;
        ItemDelegate node = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            node = session.createReference(itemId, destinationFolderId);
            item = (WorkspaceInternalLink)this.getWorkspaceItem(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HttpException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return item;
    }

    public List<WorkspaceItem> getParentsById(String id) throws InternalErrorException {
        Validate.notNull((Object)id, (String)"Item id must be not null");
        JCRSession session = null;
        ArrayList<WorkspaceItem> parents = new ArrayList<WorkspaceItem>();
        List<ItemDelegate> list = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            list = session.getParentsById(id);
            for (int size = list.size() - 3; size >= 0; --size) {
                JCRWorkspaceItem item = this.getWorkspaceItem(list.get(size));
                parents.add(item);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HttpException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
        return parents;
    }

    public String getRelativePath(String path) {
        String first = path.substring(path.indexOf(this.getPathSeparator()) + 1);
        String second = first.substring(first.indexOf(this.getPathSeparator()) + 1);
        String relativePath = second.substring(second.indexOf(this.getPathSeparator()));
        return relativePath;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId, Map<String, String> properties) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace folder " + name + " by " + this.getOwner().getPortalLogin());
        JCRSession session = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            ItemDelegate parent = session.getItemById(destinationFolderId);
            ItemDelegate node = this.createItemDelegate(session, parent, name, "nthl:workspaceItem");
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description, properties);
            folder.save();
            try {
                this.logger.info(name + " has been added to parent folder " + parent.getPath());
                JCRAccountingFolderEntryAdd entry = new JCRAccountingFolderEntryAdd(node.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), folder.getType(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getFolderItemType() : null, folder.getName(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getMimeType() : null);
                entry.save(session);
            }
            catch (Exception e) {
                this.logger.error("Error setting add accounting entry for " + name + " to parent folder " + parent.getPath());
            }
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external image");
        JCRSession session = null;
        MetaInfo info = null;
        ItemDelegate parent = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            parent = session.getItemById(destinationFolderId);
            info = WorkspaceItemUtil.getMetadataInfo(imageData, this.getStorage(), parent.getPath() + "/" + name, name);
            if (info.getStorageId() == null) {
                throw new InternalErrorException("Inpustream not saved in storage.");
            }
            ExternalImage externalImage = this.createExternalImage(name, description, info, parent, properties);
            return externalImage;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external file");
        JCRSession session = null;
        MetaInfo info = null;
        ItemDelegate parent = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            parent = session.getItemById(destinationFolderId);
            info = WorkspaceItemUtil.getMetadataInfo(fileData, this.getStorage(), parent.getPath() + "/" + name, name);
            if (info.getStorageId() == null) {
                throw new InternalErrorException("Inpustream not saved in storage.");
            }
            ExternalFile externalFile = this.createExternalFile(name, description, info, parent, properties);
            return externalFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId, Map<String, String> properties) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external pdf file");
        JCRSession session = null;
        MetaInfo info = null;
        ItemDelegate parent = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), false);
            parent = session.getItemById(destinationFolderId);
            info = WorkspaceItemUtil.getMetadataInfo(fileData, this.getStorage(), parent.getPath() + "/" + name, name);
            if (info.getStorageId() == null) {
                throw new InternalErrorException("Inpustream not saved in storage.");
            }
            ExternalPDFFile externalPDFFile = this.createExternalPDFFile(name, description, info, parent, properties);
            return externalPDFFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
    }
}

