/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSession {
    private Map<String, GCoreEndpoint.Profile.Endpoint> servlets;
    private Logger logger = LoggerFactory.getLogger(JCRSession.class);
    private String login;
    private String sessionId;
    private JCRLockManager lockManager;

    public JCRSession(String login, Boolean createSession) throws RepositoryException {
        this.login = login;
        this.servlets = JCRRepository.servlets;
        if (createSession.booleanValue()) {
            this.sessionId = this.getSession();
        }
    }

    public String getLogin() {
        return this.login;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private String loginInfo() {
        StringBuilder loginInfo = new StringBuilder();
        loginInfo.append("?").append("uuid").append("=").append(this.sessionId);
        loginInfo.append("&").append("login").append("=").append(this.login);
        return loginInfo.toString();
    }

    private String getSession() throws RepositoryException {
        String uuid = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("CreateSession").uri().toString() + this.loginInfo());
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            uuid = (String)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSession() {
        if (this.sessionId != null) {
            GetMethod getMethod = null;
            HttpClient httpClient = new HttpClient();
            try {
                getMethod = new GetMethod(this.servlets.get("ReleaseSession").uri().toString() + this.loginInfo());
                TokenUtility.setHeader(getMethod);
                httpClient.executeMethod((HttpMethod)getMethod);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
    }

    public List<ItemDelegate> getChildrenById(String id, Boolean showHidden) throws RepositoryException {
        this.logger.debug("Calling servlet getChildrenById " + id + " by " + this.login);
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("GetChildrenById").uri().toString() + this.loginInfo() + "&id=" + id + "&showHidden=" + showHidden);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            items = (List)xstream.fromXML((Reader)new InputStreamReader(getMethod.getResponseBodyAsStream(), "UTF-8"));
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public List<ItemDelegate> GetHiddenItemsById(String id) throws RepositoryException {
        this.logger.debug("Calling servlet GetHiddenItemsById " + id + " by " + this.login);
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("GetHiddenItemsById").uri().toString() + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public Map<String, String> moveToTrashIds(List<String> ids, String trashId) throws RepositoryException {
        Validate.notNull((Object)trashId, (String)"trashId must be not null");
        Validate.notNull(ids, (String)"ids must be not null");
        this.logger.debug("Calling Servlet MoveToTrashIds on " + ids.size() + " by " + this.login);
        Map error = null;
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.servlets.get("MoveToTrashIds").uri().toString() + this.loginInfo() + "&trashId=" + trashId);
            TokenUtility.setHeader(post);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML(ids), "application/json", null));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            error = (Map)xstream.fromXML(post.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return error;
    }

    public ItemDelegate getItemByPath(String path) throws ItemNotFoundException {
        this.logger.debug("*** Calling Servlet GetItemByPath " + path + " by " + this.login);
        ItemDelegate item = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("GetItemByPath").uri().toString() + this.loginInfo() + "&path=" + URLEncoder.encode(path, "UTF-8"));
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getItemById(String id) throws ItemNotFoundException {
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("GetItemById").uri().toString() + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getParentById(String id) throws ItemNotFoundException {
        this.logger.debug("Servlet getParentById " + id);
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("GetParentById").uri().toString() + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate saveItem(ItemDelegate item) throws RepositoryException {
        Validate.notNull((Object)item, (String)"item must be not null");
        this.logger.debug("Calling Servlet SaveItem " + item.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.servlets.get("SaveItem").uri().toString() + this.loginInfo());
            TokenUtility.setHeader(post);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate clone(String srcAbsPath, String destAbsPath, boolean removeExisting) throws HttpException, IOException {
        this.logger.debug("Calling Servlet Clone from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("Clone").uri().toString() + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&removeExisting=" + removeExisting);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate move(String srcAbsPath, String destAbsPath) throws HttpException, IOException {
        this.logger.debug("Calling Servlet Move from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("Move").uri().toString() + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8"));
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public void removeItem(String absPath) throws RepositoryException {
        this.logger.debug("Calling Servlet RemoveItem " + absPath + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        try {
            post = new PostMethod(this.servlets.get("RemoveItem").uri().toString() + this.loginInfo() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8"));
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Exception removing item " + absPath);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public Boolean changePrimaryType(String id, String primaryType) throws RepositoryException {
        this.logger.debug("Calling Servlet ChangePrimaryType ID" + id + " primaryType " + primaryType + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        Boolean changed = false;
        try {
            post = new PostMethod(this.servlets.get("ChangePrimaryType").uri().toString() + this.loginInfo() + "&id=" + id + "&primaryType=" + primaryType);
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            changed = (Boolean)xstream.fromXML(post.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new RepositoryException("Exception removing item " + id);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate copy(String srcAbsPath, String destAbsPath, Boolean removeSubgraph) throws IOException {
        this.logger.debug("Calling Servlet Copy from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate item = null;
        GetMethod post = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new GetMethod(this.servlets.get("Copy").uri().toString() + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&subgraph=" + removeSubgraph);
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate copyContent(String srcId, String destId) throws IOException {
        this.logger.debug("Calling Servlet CopyContent from id " + srcId + " to id " + destId + " by " + this.login);
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.servlets.get("CopyContent").uri().toString() + this.loginInfo() + "&srcId=" + srcId + "&destId=" + destId);
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchItemDelegate> executeQuery(String query, String lang, int limit) throws HttpException, IOException {
        this.logger.debug("Calling Servlet ExecuteQuery - query: " + query + " - lang: " + lang + " - limit: " + limit + " by " + this.login);
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(this.servlets.get("ExecuteQuery").uri().toString() + this.loginInfo() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&limit=" + limit);
            TokenUtility.setHeader(get);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemDelegate> searchItems(String query, String lang) throws HttpException, IOException {
        this.logger.debug("Calling Servlet SearchItems - query: " + query + " - lang: " + lang + " by " + this.login);
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(this.servlets.get("SearchItems").uri().toString() + this.loginInfo() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang);
            TokenUtility.setHeader(get);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    public void saveAccountingItem(AccountingDelegate item) throws RepositoryException {
        Validate.notNull((Object)item, (String)"item must be not null");
        this.logger.debug("Calling Servlet SaveAccountingItem by " + this.login + " - " + item.getEntryType().toString() + " - " + item.getAccountingProperties().toString());
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.servlets.get("SaveAccountingItem").uri().toString() + this.loginInfo());
            TokenUtility.setHeader(post);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public List<AccountingDelegate> getAccountingById(String id) throws RepositoryException {
        this.logger.debug("Calling Servlet GetAccountingById - id: " + id + " by " + this.login);
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            getMethod = new GetMethod(this.servlets.get("GetAccountingById").uri().toString() + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate createReference(String itemId, String destinationFolderId) throws HttpException, IOException {
        this.logger.debug("Calling Servlet CreateReference of Node Id " + itemId + " to destination folder ID" + destinationFolderId + " by " + this.login);
        ItemDelegate modifiedItem = null;
        PostMethod postMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            postMethod = new PostMethod(this.servlets.get("CreateReference").uri().toString() + this.loginInfo() + "&srcId=" + itemId + "&destId=" + destinationFolderId);
            TokenUtility.setHeader(postMethod);
            int response = httpClient.executeMethod((HttpMethod)postMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(postMethod.getResponseBodyAsStream());
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getReferences(String itemId) throws HttpException, IOException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        this.logger.debug("Calling Servlet CreateReference of Node Id " + itemId + " by " + this.login);
        List list = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("GetReferences").uri().toString() + this.loginInfo() + "&srcId=" + itemId);
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return list;
    }

    public JCRLockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = new JCRLockManager(this.login, this.sessionId);
        }
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemDelegate> getParentsById(String id) throws HttpException, IOException {
        Validate.notNull((Object)id, (String)"Item id must be not null");
        this.logger.debug("Calling Servlet get Parents By Id " + id + " by " + this.login);
        List parents = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(this.servlets.get("GetParentsById").uri().toString() + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader(getMethod);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            parents = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate addNode(ItemDelegate parent, String id) throws HttpException, IOException {
        this.logger.debug("Calling Servlet add node with id " + id + " to node " + parent.getPath());
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(this.servlets.get("AddNode").uri().toString() + this.loginInfo() + "&id=" + id + "&parentId=" + parent.getId());
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }
}

