/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.util.Extensions;
import org.gcube.common.homelibrary.util.FileSystemNameUtil;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;

public class WorkspaceToZipModelConverter {
    protected XStream xstream;

    protected XStream getXStream() {
        if (this.xstream != null) {
            return this.xstream;
        }
        this.xstream = new XStream();
        return this.xstream;
    }

    public ZipItem convert(WorkspaceItem workspaceItem, List<String> idsToExclude) throws InternalErrorException, IOException {
        switch (workspaceItem.getType()) {
            case SHARED_FOLDER: 
            case FOLDER: {
                return this.convertFolder((WorkspaceFolder)workspaceItem, idsToExclude);
            }
            case FOLDER_ITEM: {
                return this.convertFolderItem((FolderItem)workspaceItem, idsToExclude);
            }
        }
        return null;
    }

    public ZipItem convert(List<WorkspaceItem> items, List<String> idsToExclude) throws InternalErrorException, IOException {
        return this.zipItems("ZipItems", "zipping items", items, idsToExclude);
    }

    protected ZipFolder convertFolder(WorkspaceFolder workspaceFolder, List<String> idsToExclude) throws InternalErrorException, IOException {
        String name = FileSystemNameUtil.cleanFileName(workspaceFolder.getName());
        String comment = workspaceFolder.getDescription();
        List<WorkspaceItem> items = workspaceFolder.getChildren();
        return this.zipItems(name, comment, items, idsToExclude);
    }

    private ZipFolder zipItems(String name, String comment, List<WorkspaceItem> items, List<String> idsToExclude) throws InternalErrorException, IOException {
        ZipFolder zipFolder = new ZipFolder(null, name, comment, new byte[0]);
        LinkedList<String> childrenNames = new LinkedList<String>();
        for (WorkspaceItem item : items) {
            ZipItem childItem;
            if (idsToExclude != null && idsToExclude.contains(item.getId()) || (childItem = this.convert(item, idsToExclude)) == null) continue;
            String childName = WorkspaceToZipModelConverter.getUniqueName(childrenNames, childItem.getName());
            childItem.setName(childName);
            childrenNames.add(childName);
            childItem.setParent(zipFolder);
            zipFolder.addChild(childItem);
        }
        return zipFolder;
    }

    protected ZipItem convertFolderItem(FolderItem folderItem, List<String> idsToExclude) throws InternalErrorException, IOException {
        if (idsToExclude != null && idsToExclude.contains(folderItem.getId())) {
            return null;
        }
        String cleanedItemName = FileSystemNameUtil.cleanFileName(folderItem.getName());
        String comment = folderItem.getDescription();
        FolderItemType type = folderItem.getFolderItemType();
        switch (type) {
            case EXTERNAL_IMAGE: 
            case EXTERNAL_PDF_FILE: 
            case EXTERNAL_FILE: {
                ExternalFile externalFile = (ExternalFile)folderItem;
                String name = cleanedItemName;
                InputStream data = externalFile.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
                return null;
            }
            case REPORT_TEMPLATE: {
                ReportTemplate reportTemplate = (ReportTemplate)folderItem;
                String name = cleanedItemName + "." + Extensions.REPORT_TEMPLATE.getValue();
                InputStream data = reportTemplate.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
            }
            case REPORT: {
                Report report = (Report)folderItem;
                String name = cleanedItemName + "." + Extensions.REPORT.getValue();
                InputStream data = report.getData();
                if (data != null) {
                    return new ZipFile(data, name, comment);
                }
            }
            case EXTERNAL_URL: {
                ExternalUrl externalUrl = (ExternalUrl)folderItem;
                String name = cleanedItemName + ".xml";
                ByteArrayInputStream is = new ByteArrayInputStream(externalUrl.getUrl().getBytes());
                if (is != null) {
                    return new ZipFile(is, name, comment);
                }
            }
            case QUERY: {
                Query query = (Query)folderItem;
                String name = cleanedItemName + "." + Extensions.QUERY.getValue();
                ByteArrayInputStream is = new ByteArrayInputStream(query.getQuery().getBytes());
                if (is == null) break;
                return new ZipFile(is, name, comment);
            }
        }
        return null;
    }

    protected ZipFile convertImage(ZipFolder parent, Image image) throws InternalErrorException, IOException {
        String name = FileSystemNameUtil.cleanFileName(image.getName());
        return new ZipFile(parent, image.getData(), name, "");
    }

    protected static String getUniqueName(List<String> usedNames, String name) {
        String candidatePrefix = name;
        String candidateSuffix = "";
        if (name.contains(".")) {
            int dotIndex = name.lastIndexOf(46);
            candidatePrefix = name.substring(0, dotIndex);
            candidateSuffix = name.substring(dotIndex);
        }
        String candidateName = candidatePrefix + candidateSuffix;
        int index = 1;
        while (usedNames.contains(candidateName)) {
            candidateName = candidatePrefix + "(" + index + ")" + candidateSuffix;
            ++index;
        }
        return candidateName;
    }
}

