/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractModel;

public class VectorRegressionModel
extends AbstractModel {
    private static final long serialVersionUID = 8381268071090932037L;
    private String[] labelNames;
    private String[] attributeNames;
    Matrix coefficients;
    private boolean useIntercept = true;

    public VectorRegressionModel(ExampleSet exampleSet, String[] labelNames, Matrix coefficients, boolean useIntercept) {
        super(exampleSet);
        this.labelNames = labelNames;
        this.attributeNames = Tools.getRegularAttributeNames(exampleSet);
        this.coefficients = coefficients;
        this.useIntercept = useIntercept;
    }

    public ExampleSet apply(ExampleSet exampleSet) {
        Attribute[] predictedLabels = new Attribute[this.labelNames.length];
        int i = 0;
        while (i < this.labelNames.length) {
            predictedLabels[i] = AttributeFactory.createAttribute("prediction(" + this.labelNames[i] + ")", 2);
            exampleSet.getExampleTable().addAttribute(predictedLabels[i]);
            exampleSet.getAttributes().addRegular(predictedLabels[i]);
            exampleSet.getAttributes().setSpecialAttribute(predictedLabels[i], "prediction_" + this.labelNames[i]);
            ++i;
        }
        for (Example example : exampleSet) {
            int i2 = 0;
            while (i2 < predictedLabels.length) {
                double predictedLabel = this.useIntercept ? this.coefficients.get(0, i2) : 0.0;
                int j = 0;
                while (j < this.attributeNames.length) {
                    predictedLabel += example.getValue(exampleSet.getAttributes().get(this.attributeNames[j])) * this.coefficients.get(this.useIntercept ? j + 1 : j, i2);
                    ++j;
                }
                example.setValue(predictedLabels[i2], predictedLabel);
                ++i2;
            }
        }
        return exampleSet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.labelNames.length) {
            result.append(String.valueOf(this.labelNames[i]) + " = ");
            boolean first = true;
            int j = this.useIntercept ? 1 : 0;
            while (j < this.attributeNames.length + (this.useIntercept ? 1 : 0)) {
                result.append(String.valueOf(this.getCoefficientString(this.coefficients.get(j, i), first)) + " * " + this.attributeNames[j - (this.useIntercept ? 1 : 0)] + "  ");
                first = false;
                ++j;
            }
            if (this.useIntercept) {
                result.append(this.getCoefficientString(this.coefficients.get(0, i), false));
            }
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
    }
}

