/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.AbstractCriterion;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;
import com.rapidminer.operator.learner.tree.MinimalGainHandler;

public class InfoGainCriterion
extends AbstractCriterion
implements MinimalGainHandler {
    private static double LOG_FACTOR = 1.0 / Math.log(2.0);
    private FrequencyCalculator frequencyCalculator = new FrequencyCalculator();
    private double minimalGain = 0.1;

    public InfoGainCriterion() {
    }

    public InfoGainCriterion(double minimalGain) {
        this.minimalGain = minimalGain;
    }

    public void setMinimalGain(double minimalGain) {
        this.minimalGain = minimalGain;
    }

    public double getNominalBenefit(ExampleSet exampleSet, Attribute attribute) {
        double[][] weightCounts = this.frequencyCalculator.getNominalWeightCounts(exampleSet, attribute);
        return this.getBenefit(weightCounts);
    }

    public double getNumericalBenefit(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        double[][] weightCounts = this.frequencyCalculator.getNumericalWeightCounts(exampleSet, attribute, splitValue);
        return this.getBenefit(weightCounts);
    }

    protected double getBenefit(double[][] weightCounts) {
        int numberOfValues = weightCounts.length;
        int numberOfLabels = weightCounts[0].length;
        double[] entropies = new double[numberOfValues];
        double[] totalWeights = new double[numberOfValues];
        int v = 0;
        while (v < numberOfValues) {
            int l = 0;
            while (l < numberOfLabels) {
                int n = v;
                totalWeights[n] = totalWeights[n] + weightCounts[v][l];
                ++l;
            }
            l = 0;
            while (l < numberOfLabels) {
                if (weightCounts[v][l] > 0.0) {
                    double proportion = weightCounts[v][l] / totalWeights[v];
                    int n = v;
                    entropies[n] = entropies[n] - Math.log(proportion) * LOG_FACTOR * proportion;
                }
                ++l;
            }
            ++v;
        }
        double totalWeight = 0.0;
        double[] dArray = totalWeights;
        int n = totalWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            totalWeight += w;
            ++n2;
        }
        double information = 0.0;
        int v2 = 0;
        while (v2 < numberOfValues) {
            information += totalWeights[v2] / totalWeight * entropies[v2];
            ++v2;
        }
        double[] classWeights = new double[numberOfLabels];
        int l = 0;
        while (l < numberOfLabels) {
            int v3 = 0;
            while (v3 < numberOfValues) {
                int n3 = l;
                classWeights[n3] = classWeights[n3] + weightCounts[v3][l];
                ++v3;
            }
            ++l;
        }
        double totalClassWeight = 0.0;
        double[] dArray2 = classWeights;
        int n4 = classWeights.length;
        int n5 = 0;
        while (n5 < n4) {
            double w = dArray2[n5];
            totalClassWeight += w;
            ++n5;
        }
        double classEntropy = 0.0;
        int l2 = 0;
        while (l2 < numberOfLabels) {
            if (classWeights[l2] > 0.0) {
                double proportion = classWeights[l2] / totalClassWeight;
                classEntropy -= Math.log(proportion) * LOG_FACTOR * proportion;
            }
            ++l2;
        }
        double informationGain = classEntropy - information;
        if (informationGain < this.minimalGain * classEntropy) {
            informationGain = 0.0;
        }
        return informationGain;
    }

    protected double getEntropy(double[] labelWeights, double totalWeight) {
        double entropy = 0.0;
        int i = 0;
        while (i < labelWeights.length) {
            if (labelWeights[i] > 0.0) {
                double proportion = labelWeights[i] / totalWeight;
                entropy -= Math.log(proportion) * LOG_FACTOR * proportion;
            }
            ++i;
        }
        return entropy;
    }

    public boolean supportsIncrementalCalculation() {
        return true;
    }

    public double getIncrementalBenefit() {
        double totalEntropy = this.getEntropy(this.totalLabelWeights, this.totalWeight);
        double gain = this.getEntropy(this.leftLabelWeights, this.leftWeight) * this.leftWeight / this.totalWeight;
        return totalEntropy - (gain += this.getEntropy(this.rightLabelWeights, this.rightWeight) * this.rightWeight / this.totalWeight);
    }
}

