/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.WeightedPerformanceMeasures;
import com.rapidminer.operator.preprocessing.sampling.AbstractSamplingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBasedSampling
extends AbstractSamplingOperator {
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public ModelBasedSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        if (weightAttr == null) {
            weightAttr = Tools.createWeightAttribute(exampleSet);
            Iterator reader = exampleSet.iterator();
            while (reader.hasNext()) {
                ((Example)reader.next()).setValue(weightAttr, 1.0);
            }
        }
        WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(exampleSet);
        WeightedPerformanceMeasures.reweightExamples(exampleSet, wp.getContingencyMatrix(), true);
        exampleSet.recalculateAttributeStatistics(exampleSet.getAttributes().getWeight());
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        LinkedList<DoubleArrayDataRow> dataList = new LinkedList<DoubleArrayDataRow>();
        Iterator reader = exampleSet.iterator();
        double maxWeight = exampleSet.getStatistics(exampleSet.getAttributes().getWeight(), "maximum");
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            if (RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)).nextDouble() > example.getValue(weightAttr) / maxWeight) {
                example.setValue(weightAttr, 1.0);
                double[] values = new double[allAttributes.length];
                int i = 0;
                while (i < values.length) {
                    values[i] = example.getValue(allAttributes[i]);
                    ++i;
                }
                dataList.add(new DoubleArrayDataRow(values));
            }
            this.checkForStop();
        }
        List<Attribute> attributes = Arrays.asList(allAttributes);
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            regularAttributes.add(attribute);
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator<AttributeRole> special = exampleSet.getAttributes().specialAttributes();
        while (special.hasNext()) {
            AttributeRole role = special.next();
            result.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

