/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree.actions;

import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class LockTreeStructureAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final String LOCKED_ICON_NAME = "lock.png";
    private static final String UNLOCKED_ICON_NAME = "lock_open.png";
    private static final Icon[] LOCKED_ICONS = new Icon[IconSize.values().length];
    private static final Icon[] UNLOCKED_ICONS = new Icon[IconSize.values().length];
    private OperatorTree operatorTree;
    private IconSize iconSize;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            LockTreeStructureAction.LOCKED_ICONS[counter] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + LOCKED_ICON_NAME);
            LockTreeStructureAction.UNLOCKED_ICONS[counter] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + UNLOCKED_ICON_NAME);
            ++counter;
            ++n2;
        }
    }

    public LockTreeStructureAction(OperatorTree operatorTree, IconSize size) {
        super("Lock Tree Structure", UNLOCKED_ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Locks or unlocks the tree structure for drag and drop.");
        this.putValue("MnemonicKey", 83);
        this.operatorTree = operatorTree;
        this.iconSize = size;
    }

    public void actionPerformed(ActionEvent e) {
        this.operatorTree.setStructureLocked(!this.operatorTree.isStructureLocked());
    }

    public void updateIcon() {
        if (this.operatorTree.isStructureLocked()) {
            this.putValue("SmallIcon", LOCKED_ICONS[this.iconSize.ordinal()]);
            this.putValue("Name", "Unlock Tree Structure");
        } else {
            this.putValue("SmallIcon", UNLOCKED_ICONS[this.iconSize.ordinal()]);
            this.putValue("Name", "Lock Tree Structure");
        }
    }
}

